static const char *RcsId = "$Header: /cvsroot/tango-ds/Communication/Modbus/ClassFactory.cpp,v 1.4 2005/08/09 15:02:21 bourtemb Exp $";
//+=============================================================================
//
// file :        ClassFactory.cpp
//
// description : C++ source for the class_factory method of the DServer
//               device class. This method is responsible to create
//               all class singletin for a device server. It is called
//               at device server startup
//
// project :     TANGO Device Server
//
// $Author: bourtemb $
//
// $Revision: 1.4 $
//
// $Log: ClassFactory.cpp,v $
// Revision 1.4  2005/08/09 15:02:21  bourtemb
// Serial -> Serial_ns
//
// Revision 1.3  2005/03/31 15:07:05  jlpons
// Changed namespace name
//
// Revision 1.2  2005/03/01 17:53:35  jlpons
// Few updates.
//
// Revision 1.1  2005/01/14 15:36:55  jlpons
// Initial import
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>
#include <SerialClass.h>
#include <ModbusClass.h>

/**
 *	Create ModbusClass singleton and store it in DServer object.
 */

void Tango::DServer::class_factory()
{
   add_class(Serial_ns::SerialClass::init("Serial"));
   add_class(Modbus_ns::ModbusClass::init("Modbus"));
}
