# test pyTango.tangocorba.Database class

from pyTango.tangodatabase import *
from pyTango.tangocorba import PyTangoError
import sys,socket

db = Database ()

#hostname = socket.gethostname ()
hostname = socket.getfqdn ()

try :
    db.get_info ()
#     print "Database object:",db
#     print "Database connection:"
#     db.db_con.con_dump()

    print "Status (dbstatus):", db.dbstatus ()
    print "State (dbstate):", db.dbstate ()
    print "Informations (get_info):"
    for info in db.get_info () : print "\t",info

    print "For db insertion tests, removing server test data (delete_server)."
    try :
        db.delete_server ("pyTangoTester/binaryprocess1")
    except :
        print "\tError when deleting (maybe no remaining data)."

    if "pyTangoTester/binaryprocess1" in db.list_host_server ("crocus") :
        print "Problem: 'pyTangoTester/binaryprocess1' is already registered !!!"

    print "Registering pyTangoTester/binaryprocess1 server (put_server_info)."
    servref = DbServInfo()
    servref.name = "pyTangoTester/binaryprocess1"
    servref.host = hostname
    servref.mode = "0"
    servref.level = "50"
    db.put_server_info (servref)

    if "pyTangoTester/binaryprocess1" not in db.list_host_server ("crocus") :
        print "\tNote: put_server_info ('pyTangoTester/binaryprocess1') dont make it registered for list_host_server!!!"

    print "Registering device server and served devices (add_server)."
    ref1 = DbDevInfo ()
    ref1.name = "dserver/pyTangoTester/binaryprocess1"
    ref1._class = "DServer"
    ref1.server = "pyTangoTester/binaryprocess1"
    ref2 = DbDevInfo ()
    ref2.name = "tango/pyTangoTester/dsmembera"
    ref2._class = "pyTangoFirstClass"
    ref2.server = "pyTangoTester/binaryprocess1"
    ref3 = DbDevInfo ()
    ref3.name = "tango/pyTangoTester/dsmemberb"
    ref3._class = "pyTangoFirstClass"
    ref3.server = "pyTangoTester/binaryprocess1"
    ref4 = DbDevInfo ()
    ref4.name = "tango/pyTangoTester/dsmemberc"
    ref4._class = "pyTangoSecondClass"
    ref4.server = "pyTangoTester/binaryprocess1"
    db.add_server ([ref1,ref2,ref3,ref4])

    print "Registering served device (add_device)."
    ref5 = DbDevInfo ()
    ref5.name = "tango/pyTangoTester/dsmemberd"
    ref5._class = "pyTangoSecondClass"
    ref5.server = "pyTangoTester/binaryprocess1"
    db.add_server (ref5)

    print "Exporting devices from a server (ie at server runtime) (export_server ~ export_device)."
    ref1 = DbDevExportInfo ()
    ref1.name = "dserver/pyTangoTester/binaryprocess1"  # dserver/<server name>
    ref1.ior = "to-be-defined@runtime"
    ref1.host = hostname
    ref1.version = "1.0"
    ref1.pid = 10
    ref2 = DbDevExportInfo ()
    ref2.name = "tango/pyTangoTester/dsmembera"
    ref2.ior = "to-be-defined@runtime"
    ref2.host = hostname
    ref2.version = "1.0"
    ref2.pid = 10
    ref3 = DbDevExportInfo ()
    ref3.name = "tango/pyTangoTester/dsmemberb"
    ref3.ior = "to-be-defined@runtime"
    ref3.host = hostname
    ref3.version = "1.0"
    ref3.pid = 10
    ref4 = DbDevExportInfo ()
    ref4.name = "tango/pyTangoTester/dsmemberc"
    ref4.ior = "to-be-defined@runtime"
    ref4.host = hostname
    ref4.version = "1.0"
    ref4.pid = 10
    ref5 = DbDevExportInfo ()
    ref5.name = "tango/pyTangoTester/dsmemberd"
    ref5.ior = "to-be-defined@runtime"
    ref5.host = hostname
    ref5.version = "1.0"
    ref5.pid = 10
    db.export_server ([ref1,ref2,ref3,ref4,ref5])

    print "Classes (list_class for 'pyTangoTester/binaryprocess1'):"
    clist = db.list_class("pyTangoTester/binaryprocess1")
    if clist :
        for name in clist : print "\t",name
    else :
        print "\tError: empty list."

    print "Device names (get_device_name for 'pyTangoTester/binaryprocess1','pyTangoFirstClas'):"
    for name in db.get_device_name ("pyTangoTester/binaryprocess1","pyTangoFirstClass") : print "\t",name

    print "Hosts (list_host):"
    hostlist = db.list_host ()
    for host in hostlist : print "\t",host

    print "Server by host (list_host_server):"
    for host in hostlist :
        print "\t",host,":"
        for ds in db.list_host_server (host) :
            print "\t\t",ds

    print "Device exported (get_device_exported):"
    for name in db.get_device_exported() : print "\t",name

    print "Domain names (get_device_domain) :"
    for name in db.get_device_domain() : print "\t",name

    print "Family names (get_device_family) :"
    for name in db.get_device_family() : print "\t",name

    print "Device members (get_device_member):"
    for devmemb in db.get_device_member() : print "\t",devmemb

    print "Deleting device tango/pyTangoTester/dsmemberd (delete_device)."
    db.delete_device ("tango/pyTangoTester/dsmemberd")
    if "tango/pyTangoTester/dsmemberd" in db.get_device_member () :
        print "\tError, the device is already listed in get_device_member."

    print "Importing device tango/pyTangoTester/dsmemberc (import_device)."
    print db.import_device ("tango/pyTangoTester/dsmemberc")

    print "Unexporting device tango/pyTangoTester/dsmemberc (unexport_device)."
    db.unexport_device ("tango/pyTangoTester/dsmemberc")

    print "Getting server infos (get_server_info):"
    print db.get_server_info ("pyTangoTester/binaryprocess1")

#Pour le moment je commente ce qui a trait aux properties gnrales... 
#on verra quand Nicolas sera revenu afin de pouvoir redmarrer la BD si elle plante.
#     print "Putting property pyTangoPropTest (put_property)."
#     db.put_property ("pyTangoPropTest", logsystem="thelogsystemreference", procspeed="500MHz")
#
# # Fait planter la BD... peut-tre parce qu'il n'y a pas de property globale dfinie ?
# #     print "Properties (list_property):"
# #     for name in db.list_property() : print "\t",name

    print "List of classes of a device tango/pyTangoTester (list_device_class):"
    dclist = db.list_device_class ("tango/pyTangoTester")
    if dclist :
        for name in dclist : print "\t",name
    else :
        print "\tError: empty list."

#=========================== Device Property

    print "Adding device properties to tango/pyTangoTester/dsmembera (put_device_property):"
    db.put_device_property ("tango/pyTangoTester/dsmembera", oscillation=1,
                duschmoll=["Coucou","Bozo","Le","Clown"],rien="vide",sale=["Non","Sucre"])
    db.put_device_property ("tango/pyTangoTester/dsmembera", { "kerzut":"Hello","Zero":0 } )

    print "List of device property for tango/pyTangoTester/dsmembera (list_device_property):"
    dplist = db.list_device_property ("tango/pyTangoTester/dsmembera")
    if dplist :
        for name in dplist : print "\t",name
    else :
        print "\tError: empty list."

    print "Accessing device properties of tango/pyTangoTester/dsmembera (get_device_property):"
    print "'kerzut'-->",db.get_device_property ("tango/pyTangoTester/dsmembera", "kerzut")
    print "'kerzut','duschmoll','Zero'-->",db.get_device_property ("tango/pyTangoTester/dsmembera", "kerzut", "duschmoll", "Zero")
    print "['kerzut','duschmoll','Zero']-->",db.get_device_property ("tango/pyTangoTester/dsmembera", [ "kerzut", "duschmoll", "Zero"])

    print "Removing device properties of tango/pyTangoTester/dsmembera (delete_device_property):"
    db.delete_device_property ("tango/pyTangoTester/dsmembera", "kerzut","rien")
    db.delete_device_property ("tango/pyTangoTester/dsmembera", ["duschmoll","sale"])
    dplist = db.list_device_property ("tango/pyTangoTester/dsmembera")
    for prop in ["kerzut","rien","duschmoll","sale"] :
        if prop in dplist :
            print "\tError, %s is still in list_device_property." %(prop,)

#=========================== Device Attribute

    print "Adding device attribute properties for tango/pyTangoTester/dsmembera (put_device_attribute_property)."
    db.put_device_attribute_property ("tango/pyTangoTester/dsmembera",
                        myfirstatt={"min":12,"max":24,"unit":"pecos"},
                        mysecondatt={"min":"Zorro","max":"Zorro9","unit":"captain Hadock"})
    db.put_device_attribute_property ("tango/pyTangoTester/dsmembera", {
                        "mythirdatt":{"min":-100,"max":100,"unit":"mm"},
                        "myfourthatt":{"min":0.5,"max":1.5,"unit":"micron"}})

    print "Testing for extra properties (other than min/max/unit)..."
    try :
        db.put_device_attribute_property ("tango/pyTangoTester/dsmembera",
                        myfirstatt={"hello":"Hello","Bozo":"Bozo"})
        print "\t Ok."
    except :
        print "\t Failed."

    print "List of device attributes for tango/pyTangoTester/dsmembera (list_device_attribute):"
    for name in db.list_device_attribute ("tango/pyTangoTester/dsmembera") : print "\t",name

    print "Accessing device attribute properties for tango/pyTangoTester/dsmembera (get_device_attribute_property):"
    print "'myfirstatt'-->",db.get_device_attribute_property ("tango/pyTangoTester/dsmembera","myfirstatt")
    print "'myfirstatt','mysecondatt'-->",db.get_device_attribute_property ("tango/pyTangoTester/dsmembera","myfirstatt","mysecondatt")
    print "['myfirstatt','mysecondatt']-->",db.get_device_attribute_property ("tango/pyTangoTester/dsmembera",["myfirstatt","mysecondatt"])

    print "Deleting device attribute properties for tango/pyTangoTester/dsmembera (delete_device_attribute_property)."
    db.delete_device_attribute_property ("tango/pyTangoTester/dsmembera",["myfirstatt","myfourthatt"])
    attlist = db.list_device_attribute ("tango/pyTangoTester/dsmembera")
    for att in ["myfirstatt","myfourthatt"] :
        proplist = db.get_device_attribute_property ("tango/pyTangoTester/dsmembera",att)
        if len(proplist) :
            print "\tError, %s still has attribute properties."%(att,)

    print "Deleting device attribute for tango/pyTangoTester/dsmembera (delete_device_attribute)"
    db.delete_device_attribute ("tango/pyTangoTester/dsmembera",["myfirstatt","myfourthatt"])
    attlist = db.list_device_attribute ("tango/pyTangoTester/dsmembera")
    for name in ["myfirstatt","myfourthatt"] : 
        if name in attlist :
            print "\tError, remaining attribute",name

#=========================== Class Property

    print "Adding class properties to pyTangoFirstClass (put_class_property):"
    db.put_class_property ("pyTangoFirstClass", oscillation=1,
                duschmoll=["Coucou","Bozo","Le","Clown"],rien="vide",sale=["Non","Sucre"])
    db.put_class_property ("pyTangoFirstClass", { "kerzut":"Hello","Zero":0 } )

    print "List of class property for pyTangoFirstClass (list_class_property):"
    dplist = db.list_class_property ("pyTangoFirstClass")
    if dplist :
        for name in dplist : print "\t",name
    else :
        print "\tError: empty list."

    print "Accessing class properties of pyTangoFirstClass (get_class_property):"
    print "'kerzut'-->",db.get_class_property ("pyTangoFirstClass", "kerzut")
    print "'kerzut','duschmoll','Zero'-->",db.get_class_property ("pyTangoFirstClass", "kerzut", "duschmoll", "Zero")
    print "['kerzut','duschmoll','Zero']-->",db.get_class_property ("pyTangoFirstClass", [ "kerzut", "duschmoll", "Zero"])

    print "Removing class properties of pyTangoFirstClass (delete_class_property):"
    db.delete_class_property ("pyTangoFirstClass", "kerzut","rien")
    db.delete_class_property ("pyTangoFirstClass", ["duschmoll","sale"])
    dplist = db.list_class_property ("pyTangoFirstClass")
    for prop in ["kerzut","rien","duschmoll","sale"] :
        if prop in dplist :
            print "\tError, %s is still in list_class_property." %(prop,)

#=========================== Class Attribute

    print "Adding class attribute properties for pyTangoFirstClass (put_class_attribute_property)."
    db.put_class_attribute_property ("pyTangoFirstClass",
                        myfirstatt={"min":12,"max":24,"unit":"pecos"},
                        mysecondatt={"min":"Zorro","max":"Zorro9","unit":"captain Hadock"})
    db.put_class_attribute_property ("pyTangoFirstClass", {
                        "mythirdatt":{"min":-100,"max":100,"unit":"mm"},
                        "myfourthatt":{"min":0.5,"max":1.5,"unit":"micron"}})

    print "Testing for extra properties (other than min/max/unit)..."
    try :
        db.put_class_attribute_property ("pyTangoFirstClass",
                        myfirstatt={"hello":"Hello","Bozo":"Bozo"})
        print "\t Ok."
    except :
        print "\t Failed."

    print "List of class attributes for pyTangoFirstClass (list_class_attribute):"
    for name in db.list_class_attribute ("pyTangoFirstClass") : print "\t",name

    print "Accessing class attribute properties for pyTangoFirstClass (get_class_attribute_property):"
    print "'myfirstatt'-->",db.get_class_attribute_property ("pyTangoFirstClass","myfirstatt")
    print "'myfirstatt','mysecondatt'-->",db.get_class_attribute_property ("pyTangoFirstClass","myfirstatt","mysecondatt")
    print "['myfirstatt','mysecondatt']-->",db.get_class_attribute_property ("pyTangoFirstClass",["myfirstatt","mysecondatt"])

# Currently there is no DbDeleteClassAttributeProperty DB command...
#     print "Deleting class attribute properties for pyTangoFirstClass (delete_class_attribute_property)."
#     db.delete_class_attribute_property ("pyTangoFirstClass",["myfirstatt","myfourthatt"])
#     attlist = db.list_class_attribute ("pyTangoFirstClass")
#     for att in ["myfirstatt","myfourthatt"] :
#         proplist = db.get_device_attribute_property ("pyTangoFirstClass",att)
#         if len(proplist) :
#             print "\tError, %s still has attribute properties."%(att,)

# Currently there is no DbDeleteClassAttribute DB command...
#     print "Deleting class attribute for pyTangoFirstClass (delete_class_attribute)"
#     db.delete_class_attribute ("pyTangoFirstClass",["myfirstatt","myfourthatt"])
#     attlist = db.list_class_attribute ("pyTangoFirstClass")
#     for name in ["myfirstatt","myfourthatt"] :
#         if name in attlist :
#             print "\tError, remaining attribute",name

#===================================

    print "Unexporing whole server pyTangoTester/binaryprocess1 (unexport_server):"
    db.unexport_server ("pyTangoTester/binaryprocess1")
    if "tango/pyTangoTester/dsmembera" in db.get_device_exported () :
        print "Error: tango/pyTangoTester/dsmembera still in get_device_exported."

    print "Removing server informations pyTangoTester/binaryprocess1 (delete_server_info):"
    db.delete_server_info ("pyTangoTester/binaryprocess1")
    try :
        infos = db.get_server_info ("pyTangoTester/binaryprocess1")
        print "\tNote: Informations still present for get_server_info, as:",infos
    except :
        print "\tOk, all deleted."


except PyTangoError :
    print sys.exc_info()[1].dumpstr ()
except :
    raise


