# testconnexion.py
# Test connexion DB tango.

import os,sys
from omniORB import CORBA
from Tango import Device

# Pour les dbogages CORBA.
#sys.argv += [ "-ORBtraceLevel", "25", "-ORBtraceInvocations" ]
# Pour tests d'interoprabilit:
#sys.argv += ["-ORBstrictIIOP", "1"]
#sys.argv.append ("-ORBlcdMode") # Activation du mode "plus petit denomitateur commun"
#sys.argv += ["-ORBverifyObjectExistsAndType", "0"]

sname = os.getenv ("TANGO_HOST")
orb = CORBA.ORB_init(sys.argv,CORBA.ORB_ID)

ref = "corbaloc:iiop:"+sname+"/database"

print "Test connexion a l'objet:",ref
obj = orb.string_to_object (ref)

print "Cast en Device Tango."
db = obj._narrow (Device)
if db == None :
    print "Echec connexion en tant que Device Tango."
    sys.exit(1)

print "Connexion Ok."
#print "access:",db._get_access()
print "adm_name:",db._get_adm_name()
print "description:",db._get_description()
print "name:",db._get_name()
print "state:",db._get_state()
print "status:",db._get_status()

print "Commandes supportees:"
listcmds = db.command_list_query()
for cmd in listcmds :
    print "\nCommande:",cmd.cmd_name
    print "\tTag:",cmd.cmd_tag
    print "\tType en entree:",cmd.in_type
    print "\tDescription:",cmd.in_type_desc
    print "\tType out:",cmd.out_type
    print "\tDescription:",cmd.out_type_desc


