#!/usr/bin/env python
"""tangocorba.py - Devvice Proxy for Tango-Python modules.

Blabla:
         author : Laurent Pointal (laurent.pointal@lure.u-psud.fr)
       creation : 10 may 2002
          modif :

History:
8 april 2002 - Laurent Pointal - creation of the module.
"""

#===============================================================================
# Imports and exports.
__all__ = [ "DeviceProxy" ]
import time,types
from pyTango import tangocorba,tangodatabase

#===============================================================================
# Globals.
# Debug this module.
DEBUG = 0


#===============================================================================
class DeviceProxy (tangocorba.DeviceConnection,tangodatabase.DbDevice) :
    """Proxy object to access Tango Devices.

    Add tool methods to the simple DeviceConnection Tando.Device methods mapping.
    """
    #---------------------------------------------------------------------------
    def __init__ (self,name,orb=None) :
        tangocorba.DeviceConnection.__init__ (self,name,orb)

        # If using a database, initialize with a connection to that DB, else
        # ignore device name and database in our DbDevice side.
        if self.mcon_devname.databasehost != None :
            dbcon = tangocorba.DeviceConnection ("corbaloc:iiop:"+\
                        self.mcon_devname.databasehost+"/database")
            dbcon.ping ()
            #dbcon.con_dump ()
            tangodatabase.DbDevice.__init__ (self,self.mcon_devname.devicename,
                        dbcon)
        else :
            tangodatabase.DbDevice.__init__ (self,None,None)

    #---------------------------------------------------------------------------
    def __str__ (self) :
        """Return representation string of the DeviceProxy."""
        return "<DeviceProxy at %s>"%self.mcon_devname.sourceurl

    #===========================================================================
    #
    #                       OVERRIDEN INHERITED METHODS
    #
    #===========================================================================
    #---------------------------------------------------------------------------
    def con_connect_device_tango (self) :
        """INTERNAL: connection for tango identification."""
        if self.mcon_corba_device != None : return self.mcon_corba_device

        if self.mcon_devname.databasehost != None :
            try :
                # Get IOR from the database.
                impinfos = self.import_device()
                #print impinfos
                objstr = impinfos.ior
                #if DEBUG :
                #    print "IOR for",self.mcon_devname.devicename,":",objstr
            except :
                raise tangocorba.tango_error ("database access error.",\
                            tangocorba.ERR, \
                            "Access to CORBA object string failed.")
        else :
            objstr = "corbaloc:iiop:"+self.mcon_devname.hostport+\
                        "/"+self.mcon_devname.devicename

        try :
            objref = self.mcon_orb.string_to_object (objstr)
        except :
            raise tangocorba.tango_error ("string_to_object failed",\
                        tangocorba.ERR,"Cant resolve string '%s'."%objstr)

        self.con_set_device (objref)
        return self.mcon_corba_device

    #===========================================================================
    #
    #         PROXY METHODS FROM Tango.Device method with modified semantic
    #
    #===========================================================================
    #---------------------------------------------------------------------------
    def ping (self) :
        """Send a ping to the device and returns elapsed time as microseconds.
        """
        # Ensure the connection is set (dont count first connection time).
        self.con_connect_device ()
        start = time.clock ()
        tangocorba.DeviceConnection.ping (self)
        stop = time.clock ()
        return (stop-start)*1E6

    #===========================================================================
    #
    #            PROXY SPECIFIC METHODS (~copy from other langages APIs)
    #
    #===========================================================================

    #---------------------------------------------------------------------------
    def set_timeout_millis (self,timeout) :
        """Set client side timeout for device in milliseconds.
        Any method which takes longer than this time to execute will throw an
        exception.
        """
        pass

    #---------------------------------------------------------------------------
    def get_timeout_millis (self) :
        """Get the client side timeout in milliseconds.
        """
        pass

    #---------------------------------------------------------------------------
    def import_info (self) :
        return tangodatabase.DbDevImportInfo ()

    #---------------------------------------------------------------------------
    def get_attribute_list (self) :
        return

    #---------------------------------------------------------------------------
    def get_attribute_config (self,names) :
        """
        Adapted to allow one name as parameter (dont force a list of names).
        """
        if type(names)==types.StringType and names != "*":
            return tangocorba.DeviceConnection.get_attribute_config \
                        (self,[names])[0]
        else :
            if names == "*" : names = [names]
            return tangocorba.DeviceConnection.get_attribute_config (self,names)

    #---------------------------------------------------------------------------
    def set_attribute_config (self,configs) :
        """
        Adapted to allow one config as parameter (dont force a list of configs).
        """
        if type(configs)!=types.ListType :
            tangocorba.DeviceConnection.set_attribute_config (self,[configs])
        else :
            tangocorba.DeviceConnection.set_attribute_config (self,configs)

    #---------------------------------------------------------------------------
    def read_attributes (self,names) :
        if type (names) == types.StringType :
            return tangocorba.DeviceConnection.read_attributes (self,[names])[0]
        else :
            return tangocorba.DeviceConnection.read_attributes (self,names)

    #---------------------------------------------------------------------------
    def write_attributes (self,attrib) :
        if type(attrib)!=types.ListType :
            tangocorba.DeviceConnection.write_attributes (self,[attrib])
        else :
            tangocorba.DeviceConnection.write_attributes (self,attrib)


#     def import_device (self) :
#         """query
#         """


# End of pyTango/tangodevice.py

