// ============================================================================
//
// = CONTEXT
//   Tango Generic Client for Matlab
//
// = FILENAME
//   TangoBinding.h
//
// = AUTHOR
//   Nicolas Leclercq - SOLEIL
//
// ============================================================================

#ifndef _TANGO_BINDING_H_
#define _TANGO_BINDING_H_

//=============================================================================
// #DEFINEs
//=============================================================================
#define TANGO_BINDING (TangoBinding::instance())

//=============================================================================
// FORWARD DEC
//=============================================================================
class DeviceDesc;

//=============================================================================
// CLASS : TangoBinding (SINGLETON)
//=============================================================================
class TangoBinding 
{
  friend class MexFile;

public:
  static TangoBinding* instance (void);
  //- Returns the unique instance of <TangoBinding>.
    
  //------------------------------------------------------------------
  // NOTE: MEX-FILE IN/OUT ARGUMENTS ARE PASSED USING THE <MEX_ARGS> 
  //                  SINGLETON (SEE MEXFILE.H)
  //------------------------------------------------------------------

  //- Attribute oriented methods
  //---------------------------------------------
    int get_attr_config (void);
    //- DevProxy::get_attribute_config binding.

    int set_attr_config (void);
    //- DevProxy::set_attribute_config binding.

    int read_attribute (void);
    //- DevProxy::read_attribute binding.

    int read_attributes (void);
    //- DevProxy::read_attributes binding.

    int write_attribute (void);
    //- DevProxy::write_attribute binding.

    int write_attributes (void);
    //- DevProxy::write_attributes binding.

    int get_attribute_list (void);
    //- DevProxy::get_attribute_list binding.

    int attribute_history (void);
    //- DevProxy::attribute_history binding.

  //- Command oriented methods
  //---------------------------------------------
    int command_in_out (void);
    //- DevProxy::command_inout binding.

    int command_query (void);
    //- DevProxy::command_query binding.

    int command_list_query (void);
    //- DevProxy::command_list_query binding.

    int command_history (void);
    //- DevProxy::command_history binding.

  //- Polling oriented methods
  //---------------------------------------------
    int is_command_polled (void);
    //- DevProxy::is_command_polled binding.

    int poll_command (void);
    //- DevProxy::poll_command binding.

    int stop_poll_command (void);
    //- DevProxy::stop_poll_command binding.

    int get_command_poll_period (void);
    //- DevProxy::get_command_poll_period binding.

    int is_attribute_polled (void);
    //- DevProxy::is_attribute_polled binding.

    int poll_attribute (void);
    //- DevProxy::poll_attribute binding.

    int stop_poll_attribute (void);
    //- DevProxy::stop_poll_attribute binding.

    int get_attribute_poll_period (void);
    //- DevProxy::get_attribute_poll_period binding.

    int polling_status (void);
    //- DevProxy::polling_status binding.

  //- Propertioes orientd methods
  //---------------------------------------------
    int get_property (void);
    int get_properties (void);
    //- DevProxy::get_property binding.

    int put_property(void);
    int put_properties (void);
    //- DevProxy::put_property binding.

    int del_property (void);
    int del_properties (void);
    //- DevProxy::delete_property binding.

  //- Miscellaneaous methods
  //---------------------------------------------
    int info (void);
    //- DevProxy::info binding.

    int get_idl_version (void);
    //- Connection::get_idl_version binding.

    int status (void);
    //- DevProxy::status binding.

    int state (void);
    //- DevProxy::state binding.

    int ping (void);
    //- DevProxy::ping binding.

    int description (void);
    //- DevProxy::description binding.

    int admin_name (void);
    //- DevProxy::adm_name binding.

    int set_timeout (void);
    //- Connection::set_timeout binding.

    int get_timeout (void);
    //- Connection::get_timeout binding.

    int set_source (void);
    //- Connection::set_source binding.

    int get_source (void);
    //- Connection::get_source binding.

    int black_box (void);
    //- DevProxy::black_box binding.

    int tango_version (void);
    //- Returns the version of the TANGO lib used
    //- to compile this binding.

  //- Miscellaneaous specific methods
  //---------------------------------------------
    int open_device (void);
    //- Just for test purpose - should be removed in a near future.

    int close_device (void);
    //- Just for test purpose - should be removed in a near future.

private:
  static int init (void);
  //- Instanciates the singleton.
  
  static void cleanup (void);
  //- Releases the singleton.

  int read_attributes_i (DeviceDesc* ddesc);
  // read_attributes internal implementation

  int write_attributes_i (DeviceDesc* ddesc);
  // write_attributes internal implementation

  static TangoBinding* instance_;
  //- The unique instance of <TangoBinding>.

  // = Disallow these operations (except for friend classes).
  //---------------------------------------------------------
  TangoBinding(void);
  TangoBinding (const TangoBinding&);
  virtual ~TangoBinding(void);
  void operator= (const TangoBinding&); 
};

//=============================================================================
// INLINED CODE
//=============================================================================
#if defined (_MEX_INLINE_)
  #include "TangoBinding.i"
#endif 

#endif // _TANGO_BINDING_H_

   
   