// ============================================================================
//
// = CONTEXT
//   Tango Generic Client for Matlab
//
// = FILENAME
//   MexFile.h
//
// = AUTHOR
//   Nicolas Leclercq - SOLEIL
//
// ============================================================================

#ifndef _MEX_FILE_H_
#define _MEX_FILE_H_

//=============================================================================
// CLASS MexFile
//=============================================================================
class MexFile
{
  friend void mexFunction (int, mxArray **, int, const mxArray **);

 public:

  static const char * kMEX_VERSION;
  
  enum {
    MEX_VERSION = -2,
    TANGO_VERSION = -1,
    ERROR_CODE = 0,
    ERROR_STACK,
    OPEN_DEVICE,
    CLOSE_DEVICE,
    COMMAND_IN_OUT,
    READ_ATTRIBUTE, 
    READ_ATTRIBUTES,
    WRITE_ATTRIBUTE,
    WRITE_ATTRIBUTES,
    STATUS,
    PING,
    INFO,
    STATE,
    DESCRIPTION,
    ADMIN_NAME,
    GET_ATTR_CONFIG,
    SET_ATTR_CONFIG,
    BLACK_BOX,
    CMD_LIST_QUERY,
    CMD_QUERY,
    SET_TIMEOUT,
    GET_TIMEOUT,
    SET_SOURCE,
    GET_SOURCE,
    COMMAND_HISTORY,
    ATTRIBUTE_LIST,
    ATTRIBUTE_HISTORY,
    POLLING_STATUS,
    IS_CMD_POLLED,
    IS_ATTR_POLLED,
    POLL_CMD,
    POLL_ATTR,
    STOP_POLL_CMD,
    STOP_POLL_ATTR,
    GET_CMD_POLL_PERIOD,
    GET_ATTR_POLL_PERIOD,
    IDL_VERSION,
    GET_PROPERTIES,
    PUT_PROPERTIES,
    DEL_PROPERTIES,
    GET_PROPERTY,
    PUT_PROPERTY,
    DEL_PROPERTY
  };
  // Cmd-IDs

  static int init (void);
  //- Initialization.

  static void cleanup (void);
  //- Terminaison.

  static MexArgs args;
  //- MEX-File arguments

private:

  static void exec (int nlhs, mxArray **plhs, int nrhs, const mxArray **prhs);
  //- Executes a MEX-File command providing the command ID and the i/o arguments.

  static int initialized;
  //- Initialization flag  

  static void version (void);
  //- Returns this MEX-file version
};

//=============================================================================
// #DEFINEs
//=============================================================================
#define MEX_ARGS (&MexFile::args)


#endif // _MEX_FILE_H_


