// ============================================================================
//
// = CONTEXT
//   Tango Generic Client for Matlab
//
// = FILENAME
//   StandardHeader.h
//
// = AUTHOR
//   Nicolas Leclercq - SOLEIL
//
// ============================================================================

#ifndef _STD_HEADER_H_
#define _STD_HEADER_H_

//-----------------------------------------------------------------------------
// DEBUG 
//-----------------------------------------------------------------------------
#if defined (WIN32)
# if defined (_DEBUG)
#   define _MEX_DEBUG_
# endif
#else
# if defined (DEBUG)
#   define _MEX_DEBUG_
# endif
#endif

//-----------------------------------------------------------------------------
// INLINE
//-----------------------------------------------------------------------------
#if !defined(_MEX_DEBUG_)
# define _MEX_INLINE_
# define MEX_INLINE inline
#else
# define MEX_INLINE
#endif

//-----------------------------------------------------------------------------
// MATLAB MEX-FILE SUPPORT
//-----------------------------------------------------------------------------
#include <mex.h>

//-----------------------------------------------------------------------------
// TANGO SUPPORT
//-----------------------------------------------------------------------------
#include <tango.h>

//-----------------------------------------------------------------------------
// MISC MEX-FILE UTILITIES
//-----------------------------------------------------------------------------
#include "MexUtils.h"
#include "MexArgs.h"
#include "MexFile.h"

//-----------------------------------------------------------------------------
// CONSTS
//-----------------------------------------------------------------------------
const int kNoError =  0;
const int kError   = -1;

//-----------------------------------------------------------------------------
// DEFINEs
//-----------------------------------------------------------------------------
#define MAX_DEV_NAME 255

//-----------------------------------------------------------------------------
// MACROS
//-----------------------------------------------------------------------------
//-- BEGIN _SET_DEFAULT_PRHS ---------------------------------
#define _SET_DEFAULT_PRHS \
  if (MEX_ARGS->nlhs()) { \
    MEX_ARGS->set_output_array(k1ST_ARG, MEX_ARGS->default_prhs()); \
  } \
//-- END _SET_DEFAULT_PRHS -----------------------------------

//-- BEGIN _SET_DEFAULT_PRHS_THEN_RETURN ---------------------
#define _SET_DEFAULT_PRHS_THEN_RETURN(X) \
  if (MEX_ARGS->nlhs()) { \
    MEX_ARGS->set_output_array(k1ST_ARG, MEX_ARGS->default_prhs()); \
  } \
  return X; \
//-- END _SET_DEFAULT_PRHS_THEN_RETURN -----------------------


#endif // __STD_HEADER_H_
