// ============================================================================
//
// = CONTEXT
//   Tango Generic Client for Matlab
//
// = FILENAME
//   MexUtils.i
//
// = AUTHOR
//   Nicolas Leclercq - SOLEIL
//
// ============================================================================

//=============================================================================
// MexUtils::instance
//=============================================================================
MEX_INLINE MexUtils* MexUtils::instance (void)
{
  return MexUtils::instance_;
}

//=============================================================================
// MexUtils::notify
//=============================================================================
MEX_INLINE void MexUtils::notify (const std::string& txt)
{
  this->notify(txt.c_str());
}

//=============================================================================
// MexUtils::reset_error                                         
//=============================================================================
MEX_INLINE void MexUtils::reset_error (void)
{
  this->set_global_error_code(0);
  this->error_.errors.length(0);
}

//=============================================================================
// MexUtils::set_error                                         
//=============================================================================
MEX_INLINE void MexUtils::set_error (const std::string& _r, 
                                     const std::string& _d, 
                                     const std::string& _o,
                                     Tango::ErrSeverity _s)
{
  this->set_error(_r.c_str(), _d.c_str(), _o.c_str(), _s);
}

//=============================================================================
// MexUtils::push_error                                         
//=============================================================================
MEX_INLINE void MexUtils::push_error (const std::string& _r, 
                                      const std::string& _d, 
                                      const std::string& _o,
                                      Tango::ErrSeverity _s)
{
  this->push_error(_r.c_str(), _d.c_str(), _o.c_str(), _s);
}
