// ============================================================================
//
// = CONTEXT
//   Tango Generic Client for Matlab
//
// = FILENAME
//   MexUtils::.h
//
// = AUTHOR
//   Nicolas Leclercq - SOLEIL
//
// ============================================================================

#ifndef _MEX_UTILS_H_
#define _MEX_UTILS_H_

//=============================================================================
// Class MexUtils (SINGLETON)
//=============================================================================
class MexUtils
{
  friend class MexFile;

public:
  static MexUtils* instance (void);
  // Returns the unique instance of <MexUtils::>.

  void notify (const char *format, ...); 
  //

  void notify (const std::string& txt); 
  //

  void reset_error (void);
  //

  void set_error (const char *r, 
                  const char *d, 
                  const char *o,
                  Tango::ErrSeverity s = Tango::ERR);
  //
  void set_error (const std::string& r, 
                  const std::string& d, 
                  const std::string& o,
                  Tango::ErrSeverity s = Tango::ERR); 
  //

  void set_error (const Tango::DevFailed &e);
  //

  void push_error (const char *r, 
                   const char *d, 
                   const char *o,
                   Tango::ErrSeverity s = Tango::ERR);
  //

  void push_error (const std::string& r, 
                   const std::string& d, 
                   const std::string& o,
                   Tango::ErrSeverity s = Tango::ERR); 
  //

  void push_error (const Tango::DevFailed &e);
  //

  int error_code (void);
  //

  int error_stack (void);
  //

  int set_global_error_code (int _err_code = -1);
  //

private:
  static int init (void);
  //- Instanciates the singleton.
  
  static void cleanup (void);
  //- Releases the singleton.

  static MexUtils* instance_;
  //- The unique instance of <MexUtils::>.

  MexUtils ();
  //- Ctor

  Tango::DevFailed error_;
  //- Last error

  mxArray* global_err_code_;
  //- Last error code  (stored in the global workspace).
  //- Set to -1 on error, 0 otherwise.

  // = Disallow these operations (except for friends).
  //---------------------------------------------------------
  MexUtils (const MexUtils&);
  virtual ~MexUtils ();
  void operator= (const MexUtils&); 
};


//=============================================================================
// MACROS 
//=============================================================================
#define MEX_UTILS MexUtils::instance()

#if defined (_MEX_DEBUG_)

# define MEX_ERROR(X) \
    do { \
      MEX_UTILS->notify("*** TANGO BINDING::ERROR\r"); \
      MEX_UTILS->notify("\t|-near line...%d\r",__LINE__ - 2); \
      MEX_UTILS->notify("\t|-in file.....%s\r",__FILE__); \
      MEX_UTILS->notify("\t|-msg........."); \
      MEX_UTILS->notify(X); \
      MEX_UTILS->notify("\r"); \
    } while (0)

# define MEX_WARNING(X) \
    do { \
      MEX_UTILS->notify("@@@ TANGO BINDING::WARNING\r"); \
      MEX_UTILS->notify("\t|-near line...%d\r",__LINE__ - 2); \
      MEX_UTILS->notify("\t|-in file.....%s\r",__FILE__); \
      MEX_UTILS->notify("\t|-msg........."); \
      MEX_UTILS->notify(X); \
      MEX_UTILS->notify("\r"); \
    } while (0)

# define MEX_MSG(X) \
    do { \
      MEX_UTILS->notify("--- TANGO BINDING MSG\r"); \
      MEX_UTILS->notify("\t|-"); \
      MEX_UTILS->notify(X); \
      MEX_UTILS->notify("\r"); \
    } while (0) 

# define MEX_DEBUG ::mexPrintf 

#else  // _MEX_DEBUG_

# define MEX_ERROR(X)
# define MEX_WARNING(X)
# define MEX_MSG(X)
# define MEX_DEBUG
#endif // _MEX_DEBUG_

//=============================================================================
// INLINED CODE
//=============================================================================
#if defined (_MEX_INLINE_)
  #include "MexUtils.i"
#endif 

#endif // _MEX_UTILS_H_