/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.Tango.ZmqCallInfo;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceInterface;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.events.EventCallBackStruct;
import fr.esrf.TangoApi.events.EventChannelStruct;
import fr.esrf.TangoApi.events.EventConsumer;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventQueue;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoApi.events.ZmqEventConsumer;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZmqMainThread
extends Thread {
    private static final int HearBeatSock = 0;
    private static final int EventSock = 1;
    private static final int ControlSock = 2;
    private ZMQ.Socket controlSocket;
    private ZMQ.Socket heartbeatSocket;
    private ZMQ.Socket eventSocket;
    private ZmqPollers pollers;
    private boolean stop = false;
    private Hashtable<String, EventList> connectedMap = new Hashtable();
    private int heartbeatDrift = 0;
    private int eventDrift = 0;
    private static final int NameIdx = 0;
    private static final int EndianIdx = 1;
    private static final int ZmqInfoIdx = 2;
    private static final int ValueIdx = 3;
    private static final int NbFields = 4;
    private static final long SendHwmSocket = 10000L;
    private static int zmqSubscribeCounter = 0;
    private boolean traceZmqSub = false;
    private boolean traceZmqSubRead = false;

    ZmqMainThread(ZMQ.Context context) {
        this.setName("ZmqMainThread");
        this.controlSocket = context.socket(4);
        this.heartbeatSocket = context.socket(2);
        this.eventSocket = context.socket(2);
        this.controlSocket.setLinger(0L);
        this.controlSocket.bind("inproc://control");
        this.heartbeatSocket.setLinger(0L);
        this.eventSocket.setLinger(0L);
        this.eventSocket.setSndHWM(10000L);
        try {
            this.heartbeatSocket.setReconnectIVL(-1L);
            this.eventSocket.setReconnectIVL(-1L);
        }
        catch (Exception exception) {
            long l = 300000L;
            this.heartbeatSocket.setReconnectIVL(l);
            this.eventSocket.setReconnectIVL(l);
        }
        this.pollers = new ZmqPollers(context, 3);
        this.pollers.register(this.heartbeatSocket, 1);
        this.pollers.register(this.eventSocket, 1);
        this.pollers.register(this.controlSocket, 1);
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                this.pollers.poll();
                for (int i = 0; i < this.pollers.getSize(); ++i) {
                    if (!this.pollers.pollin(i)) continue;
                    this.manageInputBuffer(i);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Error error) {
                error.printStackTrace();
            }
        }
        ApiUtil.printTrace((String)"------------ End of ZmqMainThread ---------------");
    }

    private byte[][] readSocket(ZMQ.Socket socket, int n) {
        int n2;
        byte[][] byArrayArray = new byte[n][];
        if (socket == this.heartbeatSocket) {
            if (this.heartbeatDrift > 0) {
                System.err.println("------> try to resynchronize heartbeat (" + this.heartbeatDrift + ")");
                for (n2 = 0; n2 < this.heartbeatDrift; ++n2) {
                    this.heartbeatSocket.recv(0);
                }
                this.heartbeatDrift = 0;
            }
        } else if (socket == this.eventSocket && this.eventDrift > 0) {
            System.err.println("------> try to resynchronize event (" + this.eventDrift + ")");
            for (n2 = 0; n2 < this.eventDrift; ++n2) {
                this.eventSocket.recv(0);
            }
            this.eventDrift = 0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArrayArray[n2] = socket.recv(0);
        }
        return byArrayArray;
    }

    private void manageInputBuffer(int n) {
        switch (n) {
            case 2: {
                try {
                    byte[] byArray = this.controlSocket.recv(0);
                    this.manageControl(byArray);
                    this.controlSocket.send("".getBytes(), 0);
                }
                catch (DevFailed devFailed) {
                    this.controlSocket.send(devFailed.errors[0].desc.getBytes(), 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.controlSocket.send(exception.toString().getBytes(), 0);
                }
                break;
            }
            case 0: {
                try {
                    byte[][] byArray = this.readSocket(this.heartbeatSocket, 3);
                    this.manageHeartbeat(byArray);
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
                break;
            }
            case 1: {
                try {
                    byte[][] byArray = this.readSocket(this.eventSocket, 4);
                    this.manageEvent(byArray);
                    break;
                }
                catch (DevFailed devFailed) {
                    Except.print_exception((Exception)((Object)devFailed));
                }
            }
        }
    }

    private String getDeviceName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    private String getEventName(byte[] byArray) {
        String string = new String(byArray);
        int n = string.lastIndexOf(46);
        for (int i = 0; i < 4; ++i) {
            n = string.lastIndexOf(47, n - 1);
        }
        return string.substring(n + 1);
    }

    private void checkEventMessage(byte[][] byArray) throws Exception {
        if (byArray.length < 4) {
            System.err.println("NbFields=4");
            this.eventDrift = 4 - byArray.length;
            Except.throw_exception((String)"Api_BadParameterException", (String)"Cannot decode event  (message size !)", (String)"ZmqMainThread.checkEventMessage()");
        }
        if (new String(byArray[0]).startsWith("tango://")) {
            return;
        }
        byte[] byArray2 = byArray[0];
        if (byArray2.length == 1) {
            this.eventDrift = 3;
            Except.throw_exception((String)"Api_BadParameterException", (String)"Cannot decode event  (start with endianess)", (String)"ZmqMainThread.checkEventMessage()");
        } else if (byArray2[0] == 12 && byArray2[1] == 0 && byArray2[2] == 13 && byArray2[3] == 14) {
            this.eventDrift = 1;
            Except.throw_exception((String)"Api_BadParameterException", (String)"Cannot decode event  (start with data)", (String)"ZmqMainThread.checkEventMessage()");
        } else {
            this.eventDrift = 2;
            Except.throw_exception((String)"Api_BadParameterException", (String)"Cannot decode event  (start with specifications)", (String)"ZmqMainThread.checkEventMessage()");
        }
    }

    private void manageEvent(byte[][] byArray) throws DevFailed {
        try {
            ZmqCallInfo zmqCallInfo;
            this.checkEventMessage(byArray);
            String string = new String(byArray[0]);
            boolean bl = true;
            if (byArray[1].length > 0) {
                boolean bl2 = bl = byArray[1][0] != 0;
            }
            if ((zmqCallInfo = ZMQutils.deMarshallZmqCallInfo((byte[])byArray[2], (boolean)bl)) == null) {
                throw new Exception("DeMarshalling returns null");
            }
            this.manageEventValue(string, ApiUtil.toLongUnsigned((int)zmqCallInfo.ctr), byArray[3], bl, zmqCallInfo.call_is_except);
        }
        catch (Exception exception) {
            if (exception instanceof DevFailed) {
                throw (DevFailed)((Object)exception);
            }
            exception.printStackTrace();
            Except.throw_exception((String)"Api_CatchException", (String)("API catch a " + exception.toString() + " exception"), (String)"ZmqMainThread.manageEvent()");
        }
    }

    private EventCallBackStruct getEventCallBackStruct(String string) {
        ArrayList arrayList = EventConsumer.possibleTangoHosts;
        Hashtable hashtable = ZmqEventConsumer.getEventCallbackMap();
        if (hashtable.containsKey(string)) {
            return (EventCallBackStruct)hashtable.get(string);
        }
        int n = string.indexOf("//");
        if (n > 0) {
            n = string.indexOf(47, n + 2);
            for (String string2 : arrayList) {
                String string3 = string2 + string.substring(n);
                if (!hashtable.containsKey(string3)) continue;
                return (EventCallBackStruct)hashtable.get(string3);
            }
        }
        if (string.contains("maxtempchange")) {
            System.err.println("===============================================================");
            System.err.println(string + " NOT FOUND");
            System.err.println("keys are:");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                System.err.println((String)enumeration.nextElement());
            }
        }
        return null;
    }

    private void manageEventValue(String string, long l, byte[] byArray, boolean bl, boolean bl2) throws DevFailed {
        EventCallBackStruct eventCallBackStruct = this.getEventCallBackStruct(string);
        if (eventCallBackStruct != null) {
            Object object;
            DeviceAttribute deviceAttribute = null;
            DevicePipe devicePipe = null;
            AttributeInfoEx attributeInfoEx = null;
            AttDataReady attDataReady = null;
            DeviceInterface deviceInterface = null;
            DevError[] devErrorArray = null;
            boolean bl3 = this.manageEventCounter(eventCallBackStruct, string, l);
            ZMQutils.zmqEventTrace((String)("ZMQ event from " + string));
            if (bl2) {
                devErrorArray = ZMQutils.deMarshallErrorList((byte[])byArray, (boolean)bl);
            } else {
                object = EventConsumer.getChannelMap();
                EventChannelStruct eventChannelStruct = (EventChannelStruct)((Hashtable)object).get(eventCallBackStruct.channel_name);
                if (eventChannelStruct != null) {
                    try {
                        int n = eventCallBackStruct.device.get_idl_version();
                        switch (ZMQutils.getEventType((String)string)) {
                            case 5: {
                                attributeInfoEx = ZMQutils.deMarshallAttributeConfig((byte[])byArray, (boolean)bl, (int)n);
                                break;
                            }
                            case 8: {
                                devicePipe = ZMQutils.deMarshallPipe((byte[])byArray, (boolean)bl, (int)n);
                                break;
                            }
                            case 6: {
                                attDataReady = ZMQutils.deMarshallAttDataReady((byte[])byArray, (boolean)bl);
                                break;
                            }
                            case 7: {
                                deviceInterface = ZMQutils.deMarshallAttInterfaceChange((byte[])byArray, (boolean)bl);
                                break;
                            }
                            default: {
                                deviceAttribute = ZMQutils.deMarshallAttribute((byte[])byArray, (boolean)bl, (int)n);
                                break;
                            }
                        }
                    }
                    catch (DevFailed devFailed) {
                        devErrorArray = devFailed.errors;
                    }
                }
            }
            if (bl3) {
                object = this.getDeviceName(string);
                this.pushEventData(eventCallBackStruct, new EventData(eventCallBackStruct.device, (String)object, string, eventCallBackStruct.event_type, 0, deviceAttribute, devicePipe, attributeInfoEx, attDataReady, deviceInterface, devErrorArray));
            }
        } else {
            System.err.println(string + " ?  NOT FOUND");
        }
    }

    private boolean manageEventCounter(EventCallBackStruct eventCallBackStruct, String string, long l) throws DevFailed {
        long l2;
        long l3;
        long l4 = eventCallBackStruct.getZmqCounter();
        if (l4 == Long.MAX_VALUE) {
            eventCallBackStruct.setZmqCounter(l);
            if (eventCallBackStruct.event_name.equals(TangoConst.eventNames[6])) {
                eventCallBackStruct.setSynchronousDone(true);
            }
            int n = 5000;
            for (int i = 0; !eventCallBackStruct.isSynchronousDone() && i < n; ++i) {
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return true;
        }
        long l5 = l - l4;
        if (l5 == 0L) {
            eventCallBackStruct.setZmqCounter(l);
            return false;
        }
        if (l <= 0L) {
            eventCallBackStruct.setZmqCounter(l);
            return false;
        }
        if (l5 == 1L) {
            eventCallBackStruct.setZmqCounter(l);
            return true;
        }
        if (l5 < 0L && (l3 = (l2 = ApiUtil.toLongUnsigned((int)-1)) - l5) == 1L) {
            eventCallBackStruct.setZmqCounter(l);
            return true;
        }
        l2 = l - (l4 + 1L);
        DevError[] devErrorArray = new DevError[]{new DevError("Api_MissedEvents", ErrSeverity.ERR, "Missed " + l2 + " events (" + l + "-" + (l4 + 1L) + ") ! ZMQ queue has reached HWM or resynchronize ?", "ZmqMainThread.manageEventCounter()")};
        String string2 = this.getDeviceName(string);
        this.pushEventData(eventCallBackStruct, new EventData(eventCallBackStruct.device, string2, string, eventCallBackStruct.event_type, 0, null, null, null, null, null, devErrorArray));
        eventCallBackStruct.setZmqCounter(l);
        return true;
    }

    private void pushEventData(EventCallBackStruct eventCallBackStruct, EventData eventData) {
        if (eventCallBackStruct.use_ev_queue) {
            EventQueue eventQueue = eventCallBackStruct.device.getEventQueue();
            eventQueue.insert_event(eventData);
        } else if (eventCallBackStruct.callback != null) {
            eventCallBackStruct.callback.push_event(eventData);
        }
    }

    private void manageHeartbeat(byte[][] byArray) throws DevFailed {
        String string = new String(byArray[0]);
        int n = string.indexOf("dserver/");
        if (n < 0) {
            long l = System.currentTimeMillis();
            System.err.println(ZmqMainThread.formatTime(l) + ":\n heartbeat: " + string + " cannot be parsed ! length=" + byArray[0].length);
            ZMQutils.dump((byte[])byArray[0]);
            this.heartbeatDrift = byArray[0].length == 1 ? 2 : 1;
            return;
        }
        int n2 = string.lastIndexOf(46);
        string = string.substring(0, n2);
        ZmqEventConsumer.getInstance().push_structured_event_heartbeat(string);
        if (byArray[1].length == 0) {
            System.err.println("heartbeat " + string + ":   endianess is missing !!!");
        }
    }

    private String getConnectedEndPoint(String string) {
        Enumeration<String> enumeration = this.connectedMap.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            EventList eventList = this.connectedMap.get(string2);
            for (String string3 : eventList) {
                if (!string3.equals(string)) continue;
                return string2;
            }
        }
        return null;
    }

    private boolean isForcedJustified(ZMQutils.ControlStructure controlStructure) {
        EventList eventList = this.connectedMap.get(controlStructure.endPoint);
        if (eventList == null) {
            return true;
        }
        if (eventList.size() == 0) {
            return true;
        }
        return ((String)eventList.get(0)).equals(controlStructure.eventName);
    }

    private boolean alreadyConnected(String string) {
        return this.connectedMap.containsKey(string);
    }

    private void manageControl(byte[] byArray) throws DevFailed {
        ZMQutils.ControlStructure controlStructure = ZMQutils.getInstance().decodeControlBuffer(byArray);
        ApiUtil.printTrace((String)("From Control:\n" + controlStructure));
        switch (controlStructure.commandCode) {
            case 0: {
                this.stop = true;
                break;
            }
            case 1: {
                this.connectIfNotDone(this.heartbeatSocket, controlStructure);
                this.heartbeatSocket.subscribe(controlStructure.eventName.getBytes());
                break;
            }
            case 2: {
                this.disconnect(this.heartbeatSocket, controlStructure.eventName);
                break;
            }
            case 3: {
                this.connectIfNotDone(this.eventSocket, controlStructure);
                this.eventSocket.subscribe(controlStructure.eventName.getBytes());
                break;
            }
            case 4: {
                this.disconnect(this.eventSocket, controlStructure.eventName);
            }
        }
    }

    private void connectIfNotDone(ZMQ.Socket socket, ZMQutils.ControlStructure controlStructure) {
        this.traceZmqSubscription(controlStructure.eventName, true);
        if (controlStructure.forceReconnection || !this.alreadyConnected(controlStructure.endPoint)) {
            ApiUtil.printTrace((String)("Set socket buffer for HWM to " + controlStructure.hwm));
            if (controlStructure.forceReconnection && this.alreadyConnected(controlStructure.endPoint)) {
                try {
                    socket.disconnect(controlStructure.endPoint);
                }
                catch (ZMQException zMQException) {
                    System.err.println(zMQException.getMessage());
                }
            }
            socket.setHWM((long)controlStructure.hwm);
            socket.connect(controlStructure.endPoint);
            if (!this.alreadyConnected(controlStructure.endPoint)) {
                EventList eventList = new EventList();
                eventList.add(controlStructure.eventName);
                this.connectedMap.put(controlStructure.endPoint, eventList);
            } else {
                EventList eventList = this.connectedMap.get(controlStructure.endPoint);
                String string = eventList.getEvent(controlStructure.eventName);
                if (string == null) {
                    eventList.add(controlStructure.eventName);
                }
            }
        } else {
            EventList eventList = this.connectedMap.get(controlStructure.endPoint);
            String string = eventList.getEvent(controlStructure.eventName);
            if (string == null) {
                eventList.add(controlStructure.eventName);
            }
            ApiUtil.printTrace((String)((controlStructure.commandCode == 3 ? "Event" : "Heartbeat") + " already connected to " + controlStructure.endPoint));
        }
    }

    private void disconnect(ZMQ.Socket socket, String string) {
        EventList eventList;
        String string2 = this.getConnectedEndPoint(string);
        if (string2 != null && (eventList = this.connectedMap.get(string2)) != null) {
            socket.unsubscribe(string.getBytes());
            this.traceZmqSubscription(string, false);
            eventList.remove(string);
            if (eventList.size() == 0) {
                socket.disconnect(string2);
                this.connectedMap.remove(string2);
            }
        }
    }

    private void traceZmqSubscription(String string, boolean bl) {
        String string2;
        if (!this.traceZmqSubRead) {
            string2 = System.getenv("TraceSubscribe");
            this.traceZmqSub = string2 != null && string2.equals("true");
            this.traceZmqSubRead = true;
        }
        if (this.traceZmqSub) {
            if (bl) {
                ++zmqSubscribeCounter;
                string2 = "subscribe";
            } else {
                --zmqSubscribeCounter;
                string2 = "unsubscribe";
            }
            System.out.println(new Date() + ":  #### " + zmqSubscribeCounter + " -> " + string2 + " eventSocket to " + string);
        }
    }

    private static String formatTime(long l) {
        StringTokenizer stringTokenizer = new StringTokenizer(new Date(l).toString());
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String string = (String)arrayList.get(3);
        double d = (double)l / 1000.0;
        long l2 = l / 1000L;
        d = (d - (double)l2) * 1000.0;
        l = (long)d;
        return string + "." + l;
    }

    private class EventList
    extends ArrayList<String> {
        private EventList() {
        }

        private String getEvent(String string) {
            for (String string2 : this) {
                if (!string2.equals(string)) continue;
                return string2;
            }
            return null;
        }
    }

    private class ZmqPollers
    extends ZMQ.Poller {
        private ZmqPollers(ZMQ.Context context, int n) {
            super(context, n);
        }
    }
}

