/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DispLevel;
import fr.esrf.TangoDs.DeviceImpl;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.TemplCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.omg.CORBA.Any;

public class TemplCommandInOut
extends TemplCommand
implements TangoConst {
    public TemplCommandInOut(String name, String exe_method, String state_method) {
        super(name);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method) {
        super(name);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method, String state_method, String in_desc, String out_desc) {
        super(name, in_desc, out_desc, 0.0);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method, String in_desc, String out_desc) {
        super(name, in_desc, out_desc, 0.0);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method, String state_method, DispLevel disp) {
        super(name, disp);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method, DispLevel disp) {
        super(name, disp);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method, String state_method, String in_desc, String out_desc, DispLevel disp) {
        super(name, in_desc, out_desc, disp, 0.0);
        this.exe_method_name = exe_method;
        this.state_method_name = state_method;
        this.template_cmd = true;
    }

    public TemplCommandInOut(String name, String exe_method, String in_desc, String out_desc, DispLevel disp) {
        super(name, in_desc, out_desc, disp, 0.0);
        this.exe_method_name = exe_method;
        this.state_method_name = null;
        this.template_cmd = true;
    }

    @Override
    public void analyse_methods() throws DevFailed {
        this.exe_method = this.analyse_method_exe(this.device_class_name, this.exe_method_name);
        if (this.state_method_name != null) {
            this.state_method = this.analyse_method_state(this.device_class_name, this.state_method_name);
        }
    }

    private Method analyse_method_exe(String cl_name, String exe_method) throws DevFailed {
        Method meth = null;
        try {
            Class<?>[] param_type;
            StringBuffer mess;
            StringBuffer str = new StringBuffer(cl_name);
            str.append(".");
            str.append(cl_name);
            Class<?> cl = Class.forName(str.toString());
            Method[] meth_list = cl.getDeclaredMethods();
            if (meth_list.length == 0) {
                mess = new StringBuffer("Command ");
                mess.append(this.name);
                mess.append(": Can't find method ");
                mess.append(exe_method);
                Except.throw_exception("API_MethodNotFound", mess.toString(), "TemplCommandInOut.analyse_method_exe()");
            }
            if (!Modifier.isPublic((meth = this.find_method(meth_list, exe_method)).getModifiers())) {
                mess = new StringBuffer("Command ");
                mess.append(this.name);
                mess.append(": The method ");
                mess.append(exe_method);
                mess.append(" is not public");
                Except.throw_exception("API_MethodArgument", mess.toString(), "TemplCommandInOut.analyse_method_exe()");
            }
            if ((param_type = meth.getParameterTypes()).length != 1) {
                StringBuffer mess2 = new StringBuffer("Command ");
                mess2.append(this.name);
                if (param_type.length == 0) {
                    mess2.append(": No argument defined for method ");
                } else {
                    mess2.append(": More than one argument defined for method ");
                }
                mess2.append(exe_method);
                Except.throw_exception("API_MethodArgument", mess2.toString(), "TemplCommandInOut.analyse_method_exe()");
            }
            this.in_type = this.get_tango_type(param_type[0]);
            Class<?> ret_type = meth.getReturnType();
            if (ret_type.equals(Void.TYPE)) {
                StringBuffer mess3 = new StringBuffer("Command ");
                mess3.append(this.name);
                mess3.append(": Return type not defined for method ");
                mess3.append(exe_method);
                Except.throw_exception("API_MethodArgument", mess3.toString(), "TemplCommandInOut.analyse_method_exe()");
            }
            this.out_type = this.get_tango_type(ret_type);
        }
        catch (ClassNotFoundException ex) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Can't find class ");
            mess.append(cl_name);
            Except.throw_exception("API_ClassNotFound", mess.toString(), "TemplCommandInOut.analyse_method_exe()");
        }
        catch (SecurityException ex) {
            StringBuffer mess = new StringBuffer("Command ");
            mess.append(this.name);
            mess.append(": Security violation when trying to retrieve method list for class ");
            mess.append(cl_name);
            Except.throw_exception("API_JavaRuntimeSecurityException", mess.toString(), "TemplCommandInOut.analyse_method_exe()");
        }
        return meth;
    }

    @Override
    public boolean is_allowed(DeviceImpl dev, Any data_in) {
        if (this.state_method == null) {
            return true;
        }
        try {
            Object[] meth_param = new Object[]{data_in};
            Object obj = this.state_method.invoke((Object)dev, meth_param);
            return (Boolean)obj;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
    }

    @Override
    public Any execute(DeviceImpl dev, Any in_any) throws DevFailed {
        Any returned_data = null;
        try {
            Object[] meth_param = new Object[1];
            switch (this.in_type) {
                case 1: {
                    meth_param[0] = this.extract_DevBoolean(in_any);
                    break;
                }
                case 2: {
                    meth_param[0] = this.extract_DevShort(in_any);
                    break;
                }
                case 3: {
                    meth_param[0] = this.extract_DevLong(in_any);
                    break;
                }
                case 23: {
                    meth_param[0] = this.extract_DevLong64(in_any);
                    break;
                }
                case 4: {
                    meth_param[0] = Float.valueOf(this.extract_DevFloat(in_any));
                    break;
                }
                case 5: {
                    meth_param[0] = this.extract_DevDouble(in_any);
                    break;
                }
                case 8: {
                    meth_param[0] = this.extract_DevString(in_any);
                    break;
                }
                case 9: {
                    meth_param[0] = this.extract_DevVarCharArray(in_any);
                    break;
                }
                case 10: {
                    meth_param[0] = this.extract_DevVarShortArray(in_any);
                    break;
                }
                case 11: {
                    meth_param[0] = this.extract_DevVarLongArray(in_any);
                    break;
                }
                case 25: {
                    meth_param[0] = this.extract_DevVarLong64Array(in_any);
                    break;
                }
                case 12: {
                    meth_param[0] = this.extract_DevVarFloatArray(in_any);
                    break;
                }
                case 13: {
                    meth_param[0] = this.extract_DevVarDoubleArray(in_any);
                    break;
                }
                case 16: {
                    meth_param[0] = this.extract_DevVarStringArray(in_any);
                    break;
                }
                case 17: {
                    meth_param[0] = this.extract_DevVarLongStringArray(in_any);
                    break;
                }
                case 18: {
                    meth_param[0] = this.extract_DevVarDoubleStringArray(in_any);
                    break;
                }
                case 19: {
                    meth_param[0] = this.extract_DevState(in_any);
                }
            }
            Object obj = this.exe_method.invoke((Object)dev, meth_param);
            switch (this.out_type) {
                case 1: {
                    returned_data = this.insert((Boolean)obj);
                    break;
                }
                case 2: {
                    returned_data = this.insert((Short)obj);
                    break;
                }
                case 3: {
                    returned_data = this.insert((Integer)obj);
                    break;
                }
                case 23: {
                    returned_data = this.insert(((Integer)obj).longValue());
                    break;
                }
                case 4: {
                    returned_data = this.insert(((Float)obj).floatValue());
                    break;
                }
                case 5: {
                    returned_data = this.insert((Double)obj);
                    break;
                }
                case 8: {
                    returned_data = this.insert((String)obj);
                    break;
                }
                case 9: {
                    returned_data = this.insert((byte[])obj);
                    break;
                }
                case 10: {
                    returned_data = this.insert((short[])obj);
                    break;
                }
                case 11: {
                    returned_data = this.insert((int[])obj);
                    break;
                }
                case 12: {
                    returned_data = this.insert((float[])obj);
                    break;
                }
                case 13: {
                    returned_data = this.insert((double[])obj);
                    break;
                }
                case 16: {
                    returned_data = this.insert((String[])obj);
                    break;
                }
                case 17: {
                    returned_data = this.insert((DevVarLongStringArray)obj);
                    break;
                }
                case 18: {
                    returned_data = this.insert((DevVarDoubleStringArray)obj);
                    break;
                }
                case 19: {
                    returned_data = this.insert((DevState)obj);
                }
            }
        }
        catch (InvocationTargetException e) {
            throw (DevFailed)((Object)e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            StringBuffer mess = new StringBuffer("Argument error when trying to invoke method ");
            mess.append(this.exe_method);
            Except.throw_exception("API_MethodArgument", mess.toString(), "TemplCommandOut.execute()");
        }
        catch (IllegalAccessException e) {
            StringBuffer mess = new StringBuffer("Argument error when trying to invoke method ");
            mess.append(this.exe_method);
            Except.throw_exception("API_MethodArgument", mess.toString(), "TemplCommandOut.execute()");
        }
        return returned_data;
    }
}

