/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.Tango.MultiDevFailed;
import fr.esrf.TangoDs.NamedDevFailed;
import java.util.ArrayList;

public class NamedDevFailedList
extends DevFailed {
    private final ArrayList<NamedDevFailed> err_list = new ArrayList();

    public NamedDevFailedList(MultiDevFailed corba_ex, String dev_name, String op_name, String reason) {
        int nb_obj_failed = corba_ex.errors.length;
        for (int i = 0; i < nb_obj_failed; ++i) {
            NamedDevFailed tmp_err = new NamedDevFailed(corba_ex.errors[i].err_list, corba_ex.errors[i].name, corba_ex.errors[i].index_in_call);
            this.err_list.add(tmp_err);
        }
        String desc = "Failed to execute " + op_name + " on device " + dev_name + ", object(s) ";
        for (int i = 0; i < nb_obj_failed; ++i) {
            desc = desc + corba_ex.errors[i].name;
            if (i == nb_obj_failed - 1) continue;
            desc = desc + ", ";
        }
        this.errors = new DevError[1];
        this.errors[0] = new DevError();
        this.errors[0].severity = ErrSeverity.ERR;
        this.errors[0].reason = reason;
        this.errors[0].origin = op_name;
        this.errors[0].desc = desc;
        System.out.println("NamedDevFailedList\n" + desc);
    }

    public int get_faulty_attr_nb() {
        return this.err_list.size();
    }

    public NamedDevFailed elementAt(int i) {
        return this.err_list.get(i);
    }

    public boolean call_failed() {
        return this.err_list.size() == 0 && this.errors.length != 0;
    }
}

