/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoDs;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DispLevel;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoDs.Attr;
import fr.esrf.TangoDs.AttrProperty;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.ImageAttr;
import fr.esrf.TangoDs.SpectrumAttr;
import fr.esrf.TangoDs.TangoAttrCheckVal;
import fr.esrf.TangoDs.TangoAttrValue;
import fr.esrf.TangoDs.TangoConst;
import fr.esrf.TangoDs.Util;
import java.util.Date;
import java.util.Vector;

public class Attribute
implements TangoConst {
    protected String name;
    protected AttrWriteType writable;
    protected int data_type;
    protected AttrDataFormat data_format;
    protected int max_x;
    protected int max_y;
    protected String label;
    protected String description;
    protected String unit;
    protected String standard_unit;
    protected String display_unit;
    protected String format;
    protected String writable_attr_name;
    protected String min_alarm_str;
    protected String max_alarm_str;
    protected String min_value_str;
    protected String max_value_str;
    protected TangoAttrCheckVal min_alarm;
    protected TangoAttrCheckVal max_alarm;
    protected TangoAttrCheckVal min_value;
    protected TangoAttrCheckVal max_value;
    protected boolean check_min_alarm = false;
    protected boolean check_max_alarm = false;
    protected boolean check_min_value = false;
    protected boolean check_max_value = false;
    protected boolean min_alarm_on;
    protected boolean max_alarm_on;
    protected boolean date = true;
    protected int data_size;
    protected AttrQuality quality;
    protected TimeVal when;
    protected TangoAttrValue value;
    protected boolean value_flag;
    protected boolean active = false;
    private DevEncoded[] tmp_enc = new DevEncoded[2];
    private DevState[] tmp_st = new DevState[2];
    private short[] tmp_sh = new short[2];
    private int[] tmp_lo = new int[2];
    private long[] tmp_lo64 = new long[2];
    private float[] tmp_fl = new float[2];
    private double[] tmp_db = new double[2];
    private String[] tmp_str = new String[2];
    private boolean[] tmp_bool = new boolean[2];
    int dim_x;
    int dim_y;
    private int name_size;
    private String name_upper;
    protected int assoc_ind;
    protected DispLevel disp_level = DispLevel.OPERATOR;
    protected int poll_period;

    public Attribute(Vector prop_list, Attr tmp_attr, String dev_name) throws DevFailed {
        this.min_alarm = new TangoAttrCheckVal();
        this.max_alarm = new TangoAttrCheckVal();
        this.min_value = new TangoAttrCheckVal();
        this.max_value = new TangoAttrCheckVal();
        this.value = new TangoAttrValue();
        this.when = new TimeVal();
        this.quality = AttrQuality.ATTR_VALID;
        this.name = tmp_attr.get_name();
        this.name_size = this.name.length();
        this.name_upper = this.name.toUpperCase();
        this.data_type = tmp_attr.get_type();
        this.writable = tmp_attr.get_writable();
        this.data_format = tmp_attr.get_format();
        this.disp_level = tmp_attr.get_disp_level();
        this.poll_period = tmp_attr.get_polling_period();
        this.writable_attr_name = tmp_attr.get_assoc();
        switch (this.data_format.value()) {
            case 1: {
                this.max_x = ((SpectrumAttr)tmp_attr).get_max_x();
                this.max_y = 0;
                this.dim_y = 0;
                break;
            }
            case 2: {
                this.max_x = ((ImageAttr)tmp_attr).get_max_x();
                this.max_y = ((ImageAttr)tmp_attr).get_max_y();
                break;
            }
            default: {
                this.max_x = 1;
                this.max_y = 0;
                this.dim_x = 1;
                this.dim_y = 0;
            }
        }
        this.init_opt_prop(prop_list, dev_name);
    }

    private int find(Vector prop_list, String prop_name) throws DevFailed {
        int i;
        int nb_prop = prop_list.size();
        for (i = 0; i < nb_prop && !((AttrProperty)prop_list.elementAt(i)).get_name().equals(prop_name); ++i) {
        }
        if (i == nb_prop) {
            StringBuffer o = new StringBuffer("Property ");
            o.append(prop_name);
            o.append(" not found");
            Except.throw_exception("API_AttrWrongDefined", o.toString(), "Attribute.find");
        }
        return i;
    }

    private void init_opt_prop(Vector prop_list, String dev_name) throws DevFailed {
        this.label = this.get_attr_value(prop_list, "label");
        this.description = this.get_attr_value(prop_list, "description");
        this.unit = this.get_attr_value(prop_list, "unit");
        this.standard_unit = this.get_attr_value(prop_list, "standard_unit");
        this.display_unit = this.get_attr_value(prop_list, "display_unit");
        this.format = this.get_attr_value(prop_list, "format");
        this.min_alarm_str = this.get_attr_value(prop_list, "min_alarm");
        if (!this.min_alarm_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_alarm.sh = Short.parseShort(this.min_alarm_str);
                        break;
                    }
                    case 3: {
                        this.min_alarm.lg = Integer.parseInt(this.min_alarm_str);
                        break;
                    }
                    case 5: {
                        this.min_alarm.db = Double.valueOf(this.min_alarm_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("min_alarm", dev_name);
            }
            this.check_min_alarm = true;
        }
        this.max_alarm_str = this.get_attr_value(prop_list, "max_alarm");
        if (!this.max_alarm_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_alarm.sh = Short.parseShort(this.max_alarm_str);
                        break;
                    }
                    case 3: {
                        this.max_alarm.lg = Integer.parseInt(this.max_alarm_str);
                        break;
                    }
                    case 5: {
                        this.max_alarm.db = Double.valueOf(this.max_alarm_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("max_alarm", dev_name);
            }
            this.check_max_alarm = true;
        }
        this.min_value_str = this.get_attr_value(prop_list, "min_value");
        if (!this.min_value_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_value.sh = Short.parseShort(this.min_value_str);
                        break;
                    }
                    case 3: {
                        this.min_value.lg = Integer.parseInt(this.min_value_str);
                        break;
                    }
                    case 5: {
                        this.min_value.db = Double.valueOf(this.min_value_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("min_value", dev_name);
            }
            this.check_min_value = true;
        }
        this.max_value_str = this.get_attr_value(prop_list, "max_value");
        if (!this.max_value_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_value.sh = Short.parseShort(this.max_value_str);
                        break;
                    }
                    case 3: {
                        this.max_value.lg = Integer.parseInt(this.max_value_str);
                        break;
                    }
                    case 5: {
                        this.max_value.db = Double.valueOf(this.max_value_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("max_value", dev_name);
            }
            this.check_max_value = true;
        }
    }

    private String get_attr_value(Vector prop_list, String prop_name) throws DevFailed {
        int pos = 0;
        try {
            pos = this.find(prop_list, prop_name);
        }
        catch (DevFailed ex) {
            StringBuffer o = new StringBuffer("Property ");
            o.append(prop_name);
            o.append(" is missing for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.get_attr_value");
        }
        return ((AttrProperty)prop_list.elementAt(pos)).get_value()[0];
    }

    private void throw_err_format(String prop_name, String dev_name) throws DevFailed {
        StringBuffer o = new StringBuffer("Device ");
        o.append(dev_name);
        o.append("-> Attribute");
        o.append(this.name);
        o.append("\nThe property ");
        o.append(prop_name);
        o.append(" is defined in a unsupported format");
        Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.throw_err_format");
    }

    private void set_data_size() {
        switch (this.data_format.value()) {
            case 0: {
                this.data_size = 1;
                break;
            }
            case 1: {
                this.data_size = this.dim_x;
                break;
            }
            case 2: {
                this.data_size = this.dim_x * this.dim_y;
            }
        }
    }

    public boolean is_writ_associated() {
        return !this.writable_attr_name.equals("None");
    }

    public boolean is_alarmed() {
        return this.check_min_alarm || this.check_max_alarm;
    }

    public void get_properties(AttributeConfig conf) {
        conf.writable = this.writable;
        conf.data_format = this.data_format;
        conf.max_dim_x = this.max_x;
        conf.max_dim_y = this.max_y;
        conf.data_type = this.data_type;
        conf.name = this.name;
        conf.label = this.label;
        conf.description = this.description;
        conf.unit = this.unit;
        conf.standard_unit = this.standard_unit;
        conf.display_unit = this.display_unit;
        conf.format = this.format;
        conf.writable_attr_name = this.writable_attr_name;
        conf.min_alarm = this.min_alarm_str;
        conf.max_alarm = this.max_alarm_str;
        conf.min_value = this.min_value_str;
        conf.max_value = this.max_value_str;
        conf.extensions = new String[0];
    }

    AttributeConfig_2 get_properties_2() {
        AttributeConfig_2 conf = new AttributeConfig_2();
        conf.writable = this.writable;
        conf.data_format = this.data_format;
        conf.max_dim_x = this.max_x;
        conf.max_dim_y = this.max_y;
        conf.data_type = this.data_type;
        conf.name = this.name;
        conf.label = this.label;
        conf.description = this.description;
        conf.unit = this.unit;
        conf.standard_unit = this.standard_unit;
        conf.display_unit = this.display_unit;
        conf.format = this.format;
        conf.writable_attr_name = this.writable_attr_name;
        conf.min_alarm = this.min_alarm_str;
        conf.max_alarm = this.max_alarm_str;
        conf.min_value = this.min_value_str;
        conf.max_value = this.max_value_str;
        conf.level = this.disp_level;
        conf.extensions = new String[0];
        return conf;
    }

    void set_properties(AttributeConfig conf, String dev_name) throws DevFailed {
        this.description = conf.description;
        this.label = conf.label;
        this.unit = conf.unit;
        this.standard_unit = conf.standard_unit;
        this.display_unit = conf.display_unit;
        this.format = conf.format;
        this.min_alarm_str = conf.min_alarm;
        if (!this.min_alarm_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_alarm.sh = Short.parseShort(this.min_alarm_str);
                        break;
                    }
                    case 3: {
                        this.min_alarm.lg = Integer.parseInt(this.min_alarm_str);
                        break;
                    }
                    case 5: {
                        this.min_alarm.db = Double.valueOf(this.min_alarm_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("min_alarm", dev_name);
            }
            this.check_min_alarm = true;
        } else {
            this.check_min_value = false;
        }
        this.max_alarm_str = conf.max_alarm;
        if (!this.max_alarm_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_alarm.sh = Short.parseShort(this.max_alarm_str);
                        break;
                    }
                    case 3: {
                        this.max_alarm.lg = Integer.parseInt(this.max_alarm_str);
                        break;
                    }
                    case 5: {
                        this.max_alarm.db = Double.valueOf(this.max_alarm_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("max_alarm", dev_name);
            }
            this.check_max_alarm = true;
        } else {
            this.check_max_alarm = false;
        }
        this.min_value_str = conf.min_value;
        if (!this.min_value_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.min_value.sh = Short.parseShort(this.min_value_str);
                        break;
                    }
                    case 3: {
                        this.min_value.lg = Integer.parseInt(this.min_value_str);
                        break;
                    }
                    case 5: {
                        this.min_value.db = Double.valueOf(this.min_value_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("min_value", dev_name);
            }
            this.check_min_value = true;
        } else {
            this.check_min_value = false;
        }
        this.max_value_str = conf.max_value;
        if (!this.max_value_str.equals("Not specified") && this.data_type != 8 && this.data_type != 1) {
            try {
                switch (this.data_type) {
                    case 2: {
                        this.max_value.sh = Short.parseShort(this.max_value_str);
                        break;
                    }
                    case 3: {
                        this.max_value.lg = Integer.parseInt(this.max_value_str);
                        break;
                    }
                    case 5: {
                        this.max_value.db = Double.valueOf(this.max_value_str);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.throw_err_format("max_value", dev_name);
            }
            this.check_max_value = true;
        } else {
            this.check_max_value = false;
        }
    }

    void upd_database(AttributeConfig conf, String dev_name) throws DevFailed {
        Util.out4.println("Entering upd_database method for attribute " + this.name);
        DbAttribute db_attr = new DbAttribute(this.name);
        if (!conf.description.equals("No description")) {
            db_attr.add("description", new String[]{conf.description});
        }
        if (!conf.label.equals("No label")) {
            db_attr.add("label", new String[]{conf.label});
        }
        if (!conf.unit.equals("No unit")) {
            db_attr.add("unit", new String[]{conf.unit});
        }
        if (!conf.standard_unit.equals("No standard unit")) {
            db_attr.add("standard_unit", new String[]{conf.standard_unit});
        }
        if (!conf.display_unit.equals("No display unit")) {
            db_attr.add("display_unit", new String[]{conf.display_unit});
        }
        if (!conf.format.equals("No format")) {
            db_attr.add("format", new String[]{conf.format});
        }
        if (!conf.min_value.equals("Not specified")) {
            db_attr.add("min_value", new String[]{conf.min_value});
        }
        if (!conf.max_value.equals("Not specified")) {
            db_attr.add("max_value", new String[]{conf.max_value});
        }
        if (!conf.min_alarm.equals("Not specified")) {
            db_attr.add("min_alarm", new String[]{conf.min_alarm});
        }
        if (!conf.max_alarm.equals("Not specified")) {
            db_attr.add("max_alarm", new String[]{conf.max_alarm});
        }
        if (db_attr.size() > 0) {
            Util.out4.println(db_attr.size() + " properties to update in db");
            ApiUtil.get_db_obj().put_device_attribute_property(dev_name, db_attr);
        }
        Util.out4.println("Leaving upd_database method");
    }

    void add_write_value(DevEncoded val) {
        this.tmp_enc[1] = val;
        this.value.enc_value = this.tmp_enc;
    }

    void add_write_value(DevState val) {
        this.tmp_st[1] = val;
        this.value.state_seq = this.tmp_st;
    }

    void add_write_value(boolean val) {
        this.tmp_bool[1] = val;
        this.value.bool_seq = this.tmp_bool;
    }

    void add_write_value(short val) {
        this.tmp_sh[1] = val;
        this.value.sh_seq = this.tmp_sh;
    }

    void add_write_value(int val) {
        this.tmp_lo[1] = val;
        this.value.lg_seq = this.tmp_lo;
    }

    void add_write_value(long val) {
        this.tmp_lo64[1] = val;
        this.value.lg64_seq = this.tmp_lo64;
    }

    void add_write_value(float val) {
        this.tmp_fl[1] = val;
        this.value.fl_seq = this.tmp_fl;
    }

    void add_write_value(double val) {
        this.tmp_db[1] = val;
        this.value.db_seq = this.tmp_db;
    }

    void add_write_value(String val) {
        this.tmp_str[1] = val;
        this.value.str_seq = this.tmp_str;
    }

    public void set_value(DevState[] p_data, int x, int y) throws DevFailed {
        if (this.data_type != 19) {
            Except.throw_exception("API_AttrOptProp", "Invalid data type for attribute " + this.name, "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            Except.throw_exception("API_AttrOptProp", "Data size for attribute " + this.name + " exceeds given limit", "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.state_seq = p_data;
            } else {
                this.value.state_seq = new DevState[this.data_size];
                System.arraycopy(p_data, 0, this.value.state_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_st[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.state_seq = p_data;
        } else {
            this.value.state_seq = new DevState[this.data_size];
            System.arraycopy(p_data, 0, this.value.state_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(DevEncoded[] p_data, int x, int y) throws DevFailed {
        if (this.data_type != 28) {
            Except.throw_exception("API_AttrOptProp", "Invalid data type for attribute " + this.name, "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            Except.throw_exception("API_AttrOptProp", "Data size for attribute " + this.name + " exceeds given limit", "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.enc_value = p_data;
            } else {
                this.value.enc_value = new DevEncoded[this.data_size];
                System.arraycopy(p_data, 0, this.value.enc_value, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_enc[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.enc_value = p_data;
        } else {
            this.value.enc_value = new DevEncoded[this.data_size];
            System.arraycopy(p_data, 0, this.value.enc_value, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(boolean[] p_data, int x, int y) throws DevFailed {
        if (this.data_type != 1) {
            Except.throw_exception("API_AttrOptProp", "Invalid data type for attribute " + this.name, "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            Except.throw_exception("API_AttrOptProp", "Data size for attribute " + this.name + " exceeds given limit", "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.bool_seq = p_data;
            } else {
                this.value.bool_seq = new boolean[this.data_size];
                System.arraycopy(p_data, 0, this.value.bool_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_bool[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.bool_seq = p_data;
        } else {
            this.value.bool_seq = new boolean[this.data_size];
            System.arraycopy(p_data, 0, this.value.bool_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(short[] p_data, int x, int y) throws DevFailed {
        StringBuffer o;
        if (this.data_type != 2 && this.data_type != 6) {
            o = new StringBuffer("Invalid data type for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            o = new StringBuffer("Data size for attribute ");
            o.append(this.name);
            o.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.sh_seq = p_data;
            } else {
                this.value.sh_seq = new short[this.data_size];
                System.arraycopy(p_data, 0, this.value.sh_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_sh[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.sh_seq = p_data;
        } else {
            this.value.sh_seq = new short[this.data_size];
            System.arraycopy(p_data, 0, this.value.sh_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(int[] p_data, int x, int y) throws DevFailed {
        StringBuffer o;
        if (this.data_type != 3 && this.data_type != 7) {
            o = new StringBuffer("Invalid data type for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            o = new StringBuffer("Data size for attribute ");
            o.append(this.name);
            o.append(" exceeds given limit ");
            if (x > this.max_x) {
                o.append("(").append(x).append(" > ").append(this.max_x).append(")");
            }
            if (y > this.max_y) {
                o.append("(").append(y).append(" > ").append(this.max_y).append(")");
            }
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.lg_seq = p_data;
            } else {
                this.value.lg_seq = new int[this.data_size];
                System.arraycopy(p_data, 0, this.value.lg_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_lo[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.lg_seq = p_data;
        } else {
            this.value.lg_seq = new int[this.data_size];
            System.arraycopy(p_data, 0, this.value.lg_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(long[] p_data, int x, int y) throws DevFailed {
        StringBuffer o;
        if (this.data_type != 23) {
            o = new StringBuffer("Invalid data type for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            o = new StringBuffer("Data size for attribute ");
            o.append(this.name);
            o.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.lg64_seq = p_data;
            } else {
                this.value.lg64_seq = new long[this.data_size];
                System.arraycopy(p_data, 0, this.value.lg64_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_lo64[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.lg64_seq = p_data;
        } else {
            this.value.lg64_seq = new long[this.data_size];
            System.arraycopy(p_data, 0, this.value.lg64_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(float[] p_data, int x, int y) throws DevFailed {
        StringBuffer o;
        if (this.data_type != 4) {
            o = new StringBuffer("Invalid data type for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            o = new StringBuffer("Data size for attribute ");
            o.append(this.name);
            o.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.fl_seq = p_data;
            } else {
                this.value.fl_seq = new float[this.data_size];
                System.arraycopy(p_data, 0, this.value.fl_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_fl[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.fl_seq = p_data;
        } else {
            this.value.fl_seq = new float[this.data_size];
            System.arraycopy(p_data, 0, this.value.fl_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(double[] p_data, int x, int y) throws DevFailed {
        StringBuffer o;
        if (this.data_type != 5) {
            o = new StringBuffer("Invalid data type for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            o = new StringBuffer("Data size for attribute ");
            o.append(this.name);
            o.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.db_seq = p_data;
            } else {
                this.value.db_seq = new double[this.data_size];
                System.arraycopy(p_data, 0, this.value.db_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_db[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.db_seq = p_data;
        } else {
            this.value.db_seq = new double[this.data_size];
            System.arraycopy(p_data, 0, this.value.db_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.min_alarm_on = false;
        this.max_alarm_on = false;
        this.set_time();
    }

    public void set_value(String[] p_data, int x, int y) throws DevFailed {
        StringBuffer o;
        if (this.data_type != 8) {
            o = new StringBuffer("Invalid data type for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        if (x > this.max_x || y > this.max_y) {
            o = new StringBuffer("Data size for attribute ");
            o.append(this.name);
            o.append(" exceeds given limit");
            Except.throw_exception("API_AttrOptProp", o.toString(), "Attribute.set_value");
        }
        this.dim_x = x;
        this.dim_y = y;
        this.set_data_size();
        this.quality = AttrQuality.ATTR_VALID;
        if (!this.date) {
            if (p_data.length == this.data_size) {
                this.value.str_seq = p_data;
            } else {
                this.value.str_seq = new String[this.data_size];
                System.arraycopy(p_data, 0, this.value.str_seq, 0, this.data_size);
            }
        } else if (this.is_writ_associated()) {
            this.tmp_str[0] = p_data[0];
        } else if (p_data.length == this.data_size) {
            this.value.str_seq = p_data;
        } else {
            this.value.str_seq = new String[this.data_size];
            System.arraycopy(p_data, 0, this.value.str_seq, 0, this.data_size);
        }
        this.value_flag = true;
        this.quality = AttrQuality.ATTR_VALID;
        this.set_time();
    }

    public void set_value(DevState p_data) throws DevFailed {
        DevState[] tmp = new DevState[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(DevEncoded p_data) throws DevFailed {
        DevEncoded[] tmp = new DevEncoded[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(boolean p_data) throws DevFailed {
        boolean[] tmp = new boolean[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(short p_data) throws DevFailed {
        short[] tmp = new short[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(int p_data) throws DevFailed {
        int[] tmp = new int[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(long p_data) throws DevFailed {
        long[] tmp = new long[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(double p_data) throws DevFailed {
        double[] tmp = new double[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(String p_data) throws DevFailed {
        String[] tmp = new String[]{p_data};
        this.set_value(tmp, 1, 0);
    }

    public void set_value(DevState[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    public void set_value(boolean[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    public void set_value(short[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    public void set_value(int[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    public void set_value(long[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    public void set_value(double[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    public void set_value(String[] p_data, int x) throws DevFailed {
        this.set_value(p_data, x, 0);
    }

    private void set_time() {
        if (this.date) {
            Date d = new Date();
            long nb_millisec = d.getTime();
            this.when.tv_sec = (int)(nb_millisec / 1000L);
            this.when.tv_usec = (int)((nb_millisec - (long)(this.when.tv_sec * 1000)) * 1000L);
            this.when.tv_nsec = 0;
        }
    }

    public boolean check_alarm() throws DevFailed {
        if (!this.is_alarmed()) {
            StringBuffer o = new StringBuffer("No alarm defined for attribute ");
            o.append(this.name);
            Except.throw_exception("API_AttrNoAlarm", o.toString(), "Attribute.check_alarm");
        }
        if (this.check_min_alarm) {
            switch (this.data_type) {
                case 2: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (this.value.sh_seq[i] > this.min_alarm.sh) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (this.value.lg_seq[i] > this.min_alarm.lg) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 23: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (this.value.lg64_seq[i] > this.min_alarm.lg64) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (!(this.value.db_seq[i] <= this.min_alarm.db)) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.min_alarm_on = true;
                        return true;
                    }
                    break;
                }
            }
            this.min_alarm_on = false;
        }
        if (this.check_max_alarm) {
            switch (this.data_type) {
                case 2: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (this.value.sh_seq[i] < this.max_alarm.sh) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (this.value.lg_seq[i] < this.max_alarm.lg) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 23: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (this.value.lg64_seq[i] < this.max_alarm.lg64) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < this.data_size; ++i) {
                        if (!(this.value.db_seq[i] >= this.max_alarm.db)) continue;
                        this.quality = AttrQuality.ATTR_ALARM;
                        this.max_alarm_on = true;
                        return true;
                    }
                    break;
                }
            }
            this.max_alarm_on = false;
        }
        return false;
    }

    public String toString() {
        AttributeConfig_2 conf = this.get_properties_2();
        StringBuffer o = new StringBuffer();
        o.append("Attribute name = ");
        o.append(conf.name);
        o.append("\nAttribute data_type = ");
        switch (conf.data_type) {
            case 1: {
                o.append("Tango_DevBoolean");
                break;
            }
            case 2: {
                o.append("Tango_DevShort");
                break;
            }
            case 3: {
                o.append("Tango_DevLong");
                break;
            }
            case 23: {
                o.append("Tango_DevLong64");
                break;
            }
            case 5: {
                o.append("Tango_DevDouble");
                break;
            }
            case 8: {
                o.append("Tango_DevString");
            }
        }
        o.append("\nAttribute data_format = ");
        switch (conf.data_format.value()) {
            case 0: {
                o.append("scalar");
                break;
            }
            case 1: {
                o.append("spectrum, max_x = ");
                o.append(conf.max_dim_x);
                break;
            }
            case 2: {
                o.append("image, max_dim_x = ");
                o.append(conf.max_dim_x);
                o.append(", max_dim_y = ");
                o.append(conf.max_dim_y);
            }
        }
        if (conf.writable == AttrWriteType.READ) {
            o.append("\nAttribute is not writable");
        } else {
            o.append("\nAttribute is writable");
        }
        o.append("\nAttribute label = ");
        o.append(conf.label);
        o.append("\nAttribute description = ");
        o.append(conf.description);
        o.append("\nAttribute unit = ");
        o.append(conf.unit);
        o.append(", standard unit = ");
        o.append(conf.standard_unit);
        o.append(", display unit = ");
        o.append(conf.display_unit);
        o.append("\nAttribute format = ");
        o.append(conf.format);
        o.append("\nAttribute min alarm = ");
        o.append(conf.min_alarm);
        o.append("\nAttribute max alarm = ");
        o.append(conf.max_alarm);
        o.append("\nAttribute min value = ");
        o.append(conf.min_value);
        o.append("\nAttribute max value = ");
        o.append(conf.max_value);
        o.append("\nAttribute poll_period = ");
        o.append(this.poll_period);
        o.append("\nAttribute writable_attr_name = ");
        o.append(conf.writable_attr_name);
        if (conf.level == DispLevel.OPERATOR) {
            o.append("\nDisplay Level = OPERATOR");
        } else {
            o.append("\nDisplay Level = EXPERT");
        }
        o.append("\n");
        return o.toString();
    }

    void set_value() throws DevFailed {
    }

    public AttrWriteType get_writable() {
        return this.writable;
    }

    public String get_name() {
        return this.name;
    }

    public String get_assoc_name() {
        return this.writable_attr_name;
    }

    public int get_data_type() {
        return this.data_type;
    }

    public boolean is_min_alarm() {
        return this.min_alarm_on;
    }

    public boolean is_max_alarm() {
        return this.max_alarm_on;
    }

    public AttrDataFormat get_data_format() {
        return this.data_format;
    }

    public int get_assoc_ind() {
        return this.assoc_ind;
    }

    public void set_assoc_ind(int val) {
        this.assoc_ind = val;
    }

    public int get_data_size() {
        return this.data_size;
    }

    int get_x() {
        return this.dim_x;
    }

    int get_y() {
        return this.dim_y;
    }

    public AttrQuality get_quality() {
        return this.quality;
    }

    public void set_quality(AttrQuality qua) {
        this.quality = qua;
    }

    public TimeVal get_when() {
        return this.when;
    }

    public TimeVal get_date() {
        return this.when;
    }

    public void set_date(TimeVal date) {
        this.when = date;
    }

    void wanted_date(boolean val) {
        this.date = val;
    }

    String get_upper_name() {
        return this.name_upper;
    }

    int get_name_size() {
        return this.name_size;
    }

    void set_value_flag(boolean val) {
        this.value_flag = val;
    }

    boolean get_value_flag() {
        return this.value_flag;
    }

    DevEncoded[] get_enc_value() {
        return this.value.enc_value;
    }

    DevState[] get_state_value() {
        return this.value.state_seq;
    }

    boolean[] get_boolean_value() {
        return this.value.bool_seq;
    }

    short[] get_short_value() {
        return this.value.sh_seq;
    }

    int[] get_long_value() {
        return this.value.lg_seq;
    }

    long[] get_long64_value() {
        return this.value.lg64_seq;
    }

    float[] get_float_value() {
        return this.value.fl_seq;
    }

    double[] get_double_value() {
        return this.value.db_seq;
    }

    String[] get_string_value() {
        return this.value.str_seq;
    }

    int get_polling_period() {
        return this.poll_period;
    }

    void set_polling_period(int p) {
        this.poll_period = p;
    }

    void setActive(boolean b) {
        this.active = b;
    }

    boolean isActive() {
        return this.active;
    }

    synchronized void waitEndOfRead() {
        long t0 = System.currentTimeMillis();
        long dt = 0L;
        while (this.isActive() && dt < 3000L) {
            long t1 = System.currentTimeMillis();
            dt = t1 - t0;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        this.setActive(true);
        this.set_value_flag(false);
    }
}

