/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoPipeListener;
import fr.esrf.TangoApi.events.TangoPipeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoPipe
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoPipe(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoPipeListener(ITangoPipeListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoPipeListener.class, listener);
        this.event_identifier = this.subscribe_pipe_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoPipeListener(ITangoPipeListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoPipeListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoPipe tangoPipe = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoPipe.this.fireTangoPipeEvent(tangoPipe, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoPipeEvent(tangoPipe, eventData);
        }
    }

    private void fireTangoPipeEvent(TangoPipe tangoPipe, EventData eventData) {
        TangoPipeEvent tangoPipeEvent = new TangoPipeEvent(tangoPipe, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoPipeListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoPipeListener)eventListener).pipe(tangoPipeEvent);
        }
    }
}

