/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.events.EventData;
import fr.esrf.TangoApi.events.EventDispatcher;
import fr.esrf.TangoApi.events.EventUtil;
import fr.esrf.TangoApi.events.ITangoArchiveListener;
import fr.esrf.TangoApi.events.TangoArchiveEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.SwingUtilities;

public class TangoArchive
extends EventDispatcher
implements Serializable {
    String attr_name;
    int event_identifier;
    String[] filters;

    public TangoArchive(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        this.event_identifier = -1;
    }

    public void addTangoArchiveListener(ITangoArchiveListener listener, boolean stateless) throws DevFailed {
        this.event_listeners.add(ITangoArchiveListener.class, listener);
        this.event_identifier = this.subscribe_archive_event(this.attr_name, this.filters, stateless);
    }

    public void removeTangoArchiveListener(ITangoArchiveListener listener) throws DevFailed {
        this.event_listeners.remove(ITangoArchiveListener.class, listener);
        if (this.event_listeners.size() == 0) {
            this.unsubscribe_event(this.event_identifier);
        }
    }

    @Override
    public void dispatch_event(final EventData eventData) {
        final TangoArchive tangoArchive = this;
        if (EventUtil.graphicAvailable()) {
            Runnable do_work_later = new Runnable(){

                @Override
                public void run() {
                    TangoArchive.this.fireTangoArchiveEvent(tangoArchive, eventData);
                }
            };
            SwingUtilities.invokeLater(do_work_later);
        } else {
            this.fireTangoArchiveEvent(tangoArchive, eventData);
        }
    }

    private void fireTangoArchiveEvent(TangoArchive tangoArchive, EventData eventData) {
        TangoArchiveEvent archiveEvent = new TangoArchiveEvent(tangoArchive, eventData);
        ArrayList<EventListener> listeners = this.event_listeners.getListeners(ITangoArchiveListener.class);
        for (EventListener eventListener : listeners) {
            ((ITangoArchiveListener)eventListener).archive(archiveEvent);
        }
    }
}

