/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.TangoEnv;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class TangoUrl
implements ApiDefs,
Serializable {
    int protocol;
    String host;
    String strPort;
    int port;
    String devname;
    boolean fromEnv;
    boolean use_db;
    private static boolean envRead = false;
    public static final String NO_DATABASE = "#dbase=no";

    public TangoUrl(String urlStr) throws DevFailed {
        URL url;
        block30: {
            int len;
            this.protocol = 0;
            this.host = null;
            this.strPort = null;
            this.port = -1;
            this.devname = null;
            this.fromEnv = false;
            this.use_db = true;
            int idx = urlStr.indexOf(protocol_name[0] + ":");
            if (idx >= 0) {
                this.protocol = 0;
            } else {
                idx = urlStr.indexOf(protocol_name[1] + ":");
                if (idx >= 0) {
                    this.protocol = 1;
                    this.use_db = false;
                }
            }
            if (idx < 0) {
                len = 0;
                idx = 0;
            } else {
                len = protocol_name[this.protocol].length() + 1;
            }
            String newUrlStr = "http:" + urlStr.substring(idx + len);
            url = null;
            try {
                url = new URL(newUrlStr);
            }
            catch (MalformedURLException e) {
                int start;
                boolean ok = false;
                int comma = newUrlStr.indexOf(",");
                if (comma > 0 && (start = newUrlStr.indexOf("//")) >= 0) {
                    int end = newUrlStr.indexOf("/", start += 2);
                    if (end < 0) {
                        end = newUrlStr.length();
                    }
                    if (end > start) {
                        String[] array = ApiUtil.parseTangoHost(newUrlStr.substring(start, end));
                        this.host = array[0];
                        this.strPort = array[1];
                        this.port = Integer.parseInt(this.strPort);
                        String tmp = newUrlStr.substring(0, comma) + newUrlStr.substring(end);
                        try {
                            url = new URL(tmp);
                            ok = true;
                        }
                        catch (MalformedURLException ex) {
                            // empty catch block
                        }
                    }
                }
                if (ok) break block30;
                Except.throw_wrong_syntax_exception("TangoApi_BAD_URL", "Bad url parameter", "TangoUrl.TangoUrl()");
            }
        }
        assert (url != null);
        this.host = url.getHost();
        this.port = url.getPort();
        this.strPort = Integer.toString(this.port);
        this.devname = url.getFile();
        if (this.protocol == 0 && (this.host == null || this.host.isEmpty())) {
            Database db = null;
            if (ApiUtil.default_db_obj_exists()) {
                db = ApiUtil.get_default_db_obj();
            } else {
                this.setFromEnv();
                db = this.host != null && !this.host.isEmpty() ? ApiUtil.get_db_obj(this.host, this.strPort) : ApiUtil.get_db_obj();
            }
            if (db != null) {
                envRead = true;
            }
            if (!envRead) {
                this.setFromEnv();
                if (this.protocol == 0 && this.port < 0) {
                    Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "TangoUrl.TangoUrl()");
                }
            } else {
                this.host = db.url.host;
                this.port = db.url.port;
                this.strPort = Integer.toString(this.port);
                this.fromEnv = true;
            }
        }
        while (this.devname.startsWith("/")) {
            this.devname = this.devname.substring(1);
        }
        if (this.devname.length() > 0) {
            int nb_slash = 0;
            for (int i = 0; i < this.devname.length(); ++i) {
                if (this.devname.charAt(i) != '/') continue;
                ++nb_slash;
            }
            if (nb_slash != 0 && nb_slash != 2) {
                Except.throw_wrong_syntax_exception("TangoApi_BAD_DEVICE_NAME", "Device name (" + this.devname + ") wrong definition.", "TangoUrl.TangoUrl()");
            }
        } else if (this.strPort.endsWith("/")) {
            Except.throw_wrong_syntax_exception("TangoApi_BAD_DEVICE_NAME", "Device name (" + this.devname + ") wrong definition.", "TangoUrl.TangoUrl()");
        }
        if (this.devname.indexOf(35) >= 0 && this.devname.contains("->")) {
            Except.throw_wrong_syntax_exception("TangoApi_BAD_DEVICE_NAME", "Device name (" + this.devname + ") wrong definition.", "TangoUrl.TangoUrl()");
        }
        if (this.protocol == 0) {
            if (url.getRef() != null && url.getRef().indexOf("dbase=no") == 0) {
                this.use_db = false;
            }
            if (this.host != null) {
                this.host = TangoUrl.getCanonicalName(this.host);
            }
        }
    }

    public TangoUrl() throws DevFailed {
        this.protocol = 0;
        this.host = null;
        this.strPort = null;
        this.port = -1;
        this.devname = null;
        this.fromEnv = false;
        this.use_db = true;
        if (this.protocol == 0) {
            this.setFromEnv();
        }
    }

    public static String getCanonicalName(String hostName) throws DevFailed {
        String canonicalHostName = null;
        try {
            canonicalHostName = InetAddress.getByName(hostName).getCanonicalHostName();
            if (!canonicalHostName.contains(hostName)) {
                ApiUtil.printTrace(hostName + " ========> " + canonicalHostName);
            }
        }
        catch (UnknownHostException e) {
            Except.throw_exception("Api_GetCanonicalHostNameFailed", e.toString());
        }
        return canonicalHostName;
    }

    private void setFromEnv() throws DevFailed {
        String env = TangoEnv.getTangoHost();
        assert (env != null);
        if (!env.contains(":")) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Unknown \"TANGO_HOST\" property " + env, "TangoUrl.setFromEnv()");
        }
        String[] array = ApiUtil.parseTangoHost(env);
        this.host = array[0];
        this.strPort = array[1];
        this.port = Integer.parseInt(this.strPort);
        envRead = true;
        this.fromEnv = true;
    }

    public String getTangoHost() {
        return this.host + ":" + this.port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.protocol == 0) {
            sb.append("tango://").append(this.host).append(":").append(this.strPort);
        } else {
            sb.append("taco");
        }
        sb.append("/").append(this.devname);
        if (!this.use_db) {
            sb.append(NO_DATABASE);
        }
        return sb.toString();
    }

    public void trace(String urlStr) {
        System.out.println("\n================" + urlStr + "====================");
        System.out.println("\tprotocol = " + protocol_name[this.protocol]);
        if (this.host != null) {
            System.out.println("\thost name= " + this.host);
        }
        System.out.println("\tport num = " + this.strPort);
        System.out.println("\tdevice   = " + this.devname);
        if (this.use_db) {
            System.out.println("\tuse database");
        } else {
            System.out.println("\tDo NOT use database");
        }
        System.out.println();
    }
}

