/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoDs.Except;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class TangORBversion
implements Serializable {
    public String Tango = null;
    public String api = null;
    public String JacORB = null;
    public String ZMQ = null;
    public String slf4j = null;
    public String guava;
    public String javatuples;
    public String transmorph;
    public String cal10n;
    public String jarfile;
    private static final String[] packages = new String[]{"API", "Tango", "JacORB", "ZMQ", "slf4j", "guava", "javatuples", "transmorph", "cal10n"};

    public TangORBversion() throws DevFailed, IOException {
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String target = "JTango";
        int start = classpath.indexOf(target);
        if (start < 0 && (start = classpath.indexOf(target = "TangORB")) < 0) {
            Except.throw_exception("TangORB_NotFound", "TangORB jar file not found in CLASSPATH", "TangORBversion.TangORBversion()");
        }
        start = (start = classpath.lastIndexOf(separator, start)) < 0 ? 0 : ++start;
        int end = classpath.indexOf(separator, start);
        this.jarfile = end < 0 ? classpath.substring(start) : classpath.substring(start, end);
        this.initObject();
    }

    public TangORBversion(String filename) throws DevFailed, IOException {
        this.jarfile = filename;
        this.initObject();
    }

    private void initObject() throws DevFailed, IOException {
        if (!new File(this.jarfile).exists()) {
            Except.throw_exception("FileNotFoundException", this.jarfile + " No such file or directory");
        }
        JarFile jf = new JarFile(this.jarfile);
        Manifest manif = jf.getManifest();
        Attributes attr = manif.getMainAttributes();
        int max_length = 0;
        for (String pack : packages) {
            if (pack.length() <= max_length) continue;
            max_length = pack.length();
        }
        block12: for (int i = 0; i < packages.length; ++i) {
            String target = packages[i] + "-Version";
            String version = attr.getValue(target);
            if (version == null) continue;
            switch (i) {
                case 0: {
                    this.api = version.trim();
                    continue block12;
                }
                case 1: {
                    this.Tango = version.trim();
                    continue block12;
                }
                case 2: {
                    this.JacORB = version.trim();
                    continue block12;
                }
                case 3: {
                    this.ZMQ = version.trim();
                    continue block12;
                }
                case 4: {
                    this.slf4j = version.trim();
                    continue block12;
                }
                case 5: {
                    this.guava = version.trim();
                    continue block12;
                }
                case 6: {
                    this.javatuples = version.trim();
                    continue block12;
                }
                case 7: {
                    this.transmorph = version.trim();
                    continue block12;
                }
                case 8: {
                    this.cal10n = version.trim();
                }
            }
        }
    }

    public String toString() {
        int max_length = 0;
        for (String pack : packages) {
            if (pack.length() <= max_length) continue;
            max_length = pack.length();
        }
        StringBuilder sb = new StringBuilder();
        block12: for (int i = 0; i < packages.length; ++i) {
            switch (i) {
                case 0: {
                    sb.append(this.buildVersion(packages[i], this.api, max_length));
                    continue block12;
                }
                case 1: {
                    sb.append(this.buildVersion(packages[i], this.Tango, max_length));
                    continue block12;
                }
                case 2: {
                    sb.append(this.buildVersion(packages[i], this.JacORB, max_length));
                    continue block12;
                }
                case 3: {
                    sb.append(this.buildVersion(packages[i], this.ZMQ, max_length));
                    continue block12;
                }
                case 4: {
                    sb.append(this.buildVersion(packages[i], this.slf4j, max_length));
                    continue block12;
                }
                case 5: {
                    sb.append(this.buildVersion(packages[i], this.guava, max_length));
                    continue block12;
                }
                case 6: {
                    sb.append(this.buildVersion(packages[i], this.javatuples, max_length));
                    continue block12;
                }
                case 7: {
                    sb.append(this.buildVersion(packages[i], this.transmorph, max_length));
                    continue block12;
                }
                case 8: {
                    sb.append(this.buildVersion(packages[i], this.cal10n, max_length));
                }
            }
        }
        return sb.toString().trim();
    }

    private String buildVersion(String packageName, String release, int maxLength) {
        if (release == null || release.isEmpty()) {
            return "";
        }
        int length = maxLength - packageName.length() + 3;
        StringBuilder sb = new StringBuilder(packageName + " version");
        for (int j = 0; j < length; ++j) {
            sb.append(".");
        }
        sb.append(release).append('\n');
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            TangORBversion tangORB = args.length > 0 ? new TangORBversion(args[0]) : new TangORBversion();
            System.out.println(tangORB);
        }
        catch (DevFailed e) {
            Except.print_exception((Exception)((Object)e));
        }
        catch (IOException e) {
            System.out.println(e);
            System.exit(-1);
        }
        System.exit(0);
    }
}

