/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DispLevel;
import fr.esrf.Tango.PipeConfig;
import fr.esrf.Tango.PipeWriteType;

public class PipeInfo {
    private String name = "";
    private String description = "";
    private String label = "";
    private DispLevel level;
    private PipeWriteType writeType;
    private String[] extensions = new String[0];

    public PipeInfo(PipeConfig pipeConfig) {
        this.name = pipeConfig.name;
        this.description = pipeConfig.description;
        this.label = pipeConfig.label;
        this.level = pipeConfig.level;
        this.writeType = pipeConfig.writable;
    }

    public PipeInfo(String name, String description, String label, DispLevel level, PipeWriteType writeType) {
        this.name = name;
        this.description = description;
        this.label = label;
        this.level = level;
        this.writeType = writeType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public DispLevel getLevel() {
        return this.level;
    }

    public boolean isWritable() {
        return this.writeType == PipeWriteType.PIPE_READ_WRITE;
    }

    public PipeWriteType getWriteType() {
        return this.writeType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLevel(DispLevel level) {
        this.level = level;
    }

    public void setWriteType(PipeWriteType writeType) {
        this.writeType = writeType;
    }

    public void setWritable(boolean b) {
        this.writeType = b ? PipeWriteType.PIPE_READ_WRITE : PipeWriteType.PIPE_READ;
    }

    public PipeConfig getPipeConfig() {
        return new PipeConfig(this.name, this.description, this.label, this.level, this.writeType, this.extensions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Pipe Name:     ").append(this.name).append("\n");
        sb.append("Description:   ").append(this.description).append('\n');
        sb.append("Label:         ").append(this.label).append('\n');
        sb.append("Display Level: ").append(this.level == DispLevel.EXPERT ? "EXPERT" : "OPERATOR").append('\n');
        sb.append("Writable:      ").append(this.isWritable()).append('\n');
        return sb.toString().trim();
    }
}

