/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.TangoUrl;
import java.util.Hashtable;

public class DeviceProxyFactory {
    private static Hashtable<String, DeviceProxy> proxy_table = new Hashtable();

    public static DeviceProxy get(String deviceName) throws DevFailed {
        String fullDeviceName = deviceName.startsWith("tango:") ? deviceName : new TangoUrl(deviceName).toString().toLowerCase();
        String tangoHost = deviceName.contains("dbase=no") ? "" : ApiUtil.get_default_db_obj().getUrl().getTangoHost();
        return DeviceProxyFactory.get(fullDeviceName, tangoHost);
    }

    public static DeviceProxy get(String deviceName, String tangoHost) throws DevFailed {
        String fullDeviceName = deviceName.startsWith("tango://") || deviceName.startsWith("//") ? deviceName : "tango://" + tangoHost + "/" + deviceName;
        DeviceProxy dev = proxy_table.get(fullDeviceName);
        if (dev == null) {
            try {
                dev = new DeviceProxy(deviceName);
                proxy_table.put(fullDeviceName, dev);
            }
            catch (DevFailed e) {
                e.printStackTrace();
                throw e;
            }
        }
        return dev;
    }

    public static boolean exists(String deviceName) throws DevFailed {
        String fullDeviceName = new TangoUrl(deviceName).toString();
        DeviceProxy dev = proxy_table.get(fullDeviceName);
        return dev != null;
    }

    public static void remove(String deviceName) {
        try {
            String fullDeviceName = new TangoUrl(deviceName).toString();
            if (proxy_table.containsKey(fullDeviceName)) {
                proxy_table.remove(fullDeviceName);
            }
        }
        catch (DevFailed e) {
            System.err.println(e.errors[0].desc);
        }
    }

    public static void remove(DeviceProxy dev) {
        String fullDeviceName = dev.url.toString();
        if (proxy_table.containsKey(fullDeviceName)) {
            proxy_table.remove(fullDeviceName);
        }
    }

    static void add(DeviceProxy dev) {
        String fullDeviceName = dev.url.toString();
        DeviceProxy tmp_dev = proxy_table.get(fullDeviceName);
        if (tmp_dev == null) {
            proxy_table.put(fullDeviceName, dev);
        }
    }
}

