/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevPipeBlob;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.PipeBlob;
import fr.esrf.TangoApi.PipeDataElement;
import fr.esrf.TangoApi.PipeScanner;
import fr.esrf.TangoDs.TangoConst;
import java.lang.reflect.Array;
import java.util.concurrent.atomic.AtomicInteger;

public class DevicePipe
implements PipeScanner {
    private static final DevError[] DEV_ERRORS = new DevError[0];
    private String pipeName = "";
    private TimeVal timeVal;
    private PipeBlob pipeBlob;
    private final int size;
    private final AtomicInteger ndx = new AtomicInteger(0);

    public DevicePipe(String pipeName, PipeBlob pipeBlob) {
        this.pipeName = pipeName;
        long t = System.currentTimeMillis();
        int sec = (int)(t / 1000L);
        int usec = (int)(t - (long)(1000 * sec)) * 1000;
        this.timeVal = new TimeVal(sec, usec, 0);
        this.pipeBlob = pipeBlob;
        this.size = pipeBlob.size();
    }

    public DevicePipe(DevPipeData pipeData) {
        this.pipeName = pipeData.name;
        this.timeVal = pipeData.time;
        this.pipeBlob = new PipeBlob(pipeData.data_blob);
        this.size = this.pipeBlob.size();
    }

    public DevPipeData getDevPipeDataObject() {
        DevPipeBlob devPipeBlob = this.pipeBlob.getDevPipeBlobObject();
        return new DevPipeData(this.pipeName, this.timeVal, devPipeBlob);
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public void setPipeName(String pipeName) {
        this.pipeName = pipeName;
    }

    public PipeBlob getPipeBlob() {
        return this.pipeBlob;
    }

    public void setPipeBlob(PipeBlob pipeBlob) {
        this.pipeBlob = pipeBlob;
    }

    public TimeVal getTimeVal() {
        return this.timeVal;
    }

    public void setTimeVal(TimeVal timeVal) {
        this.timeVal = timeVal;
    }

    public void setTimeVal(long t) {
        int seconds = (int)(t / 1000L);
        int millis = (int)(t - 1000L * t);
        this.timeVal = new TimeVal(seconds, millis * 1000, 0);
    }

    public long getTimeValSec() throws DevFailed {
        return this.timeVal.tv_sec;
    }

    public long getTimeValMillisSec() throws DevFailed {
        return (long)this.timeVal.tv_sec * 1000L + (long)(this.timeVal.tv_usec / 1000);
    }

    @Override
    public boolean hasNext() {
        return this.ndx.get() < this.size;
    }

    @Override
    public void move() {
        this.ndx.incrementAndGet();
    }

    @Override
    public void advance(int steps) {
        if (this.ndx.addAndGet(steps) >= this.size) {
            throw new IllegalArgumentException("Can not advance by " + steps + ": exceeds size of " + this.size);
        }
    }

    @Override
    public void reset() {
        this.ndx.set(0);
    }

    @Override
    public boolean nextBoolean() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Boolean.TYPE) {
            throw new DevFailed("Wrong type! Expected boolean, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getBoolean(array, 0);
    }

    @Override
    public byte nextByte() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Byte.TYPE) {
            throw new DevFailed("Wrong type! Expected byte, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getByte(array, 0);
    }

    @Override
    public char nextChar() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Character.TYPE) {
            throw new DevFailed("Wrong type! Expected char, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getChar(array, 0);
    }

    @Override
    public short nextShort() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Short.TYPE) {
            throw new DevFailed("Wrong type! Expected short, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getShort(array, 0);
    }

    @Override
    public int nextInt() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Integer.TYPE) {
            throw new DevFailed("Wrong type! Expected int, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getInt(array, 0);
    }

    @Override
    public long nextLong() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Long.TYPE) {
            throw new DevFailed("Wrong type! Expected long, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getLong(array, 0);
    }

    @Override
    public float nextFloat() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Float.TYPE) {
            throw new DevFailed("Wrong type! Expected float, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getFloat(array, 0);
    }

    @Override
    public double nextDouble() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != Double.TYPE) {
            throw new DevFailed("Wrong type! Expected double, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return Array.getDouble(array, 0);
    }

    @Override
    public String nextString() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != String.class) {
            throw new DevFailed("Wrong type! Expected String, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return (String)String.class.cast(Array.get(array, 0));
    }

    @Override
    public DevState nextState() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != DevState.class) {
            throw new DevFailed("Wrong type! Expected DevState, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return (DevState)DevState.class.cast(Array.get(array, 0));
    }

    @Override
    public DevEncoded nextEncoded() throws DevFailed {
        Object array = this.nextArray();
        if (array.getClass().getComponentType() != DevEncoded.class) {
            throw new DevFailed("Wrong type! Expected DevEncoded, but was " + array.getClass().getComponentType().getSimpleName(), DEV_ERRORS);
        }
        return (DevEncoded)DevEncoded.class.cast(Array.get(array, 0));
    }

    @Override
    public PipeScanner nextScanner() throws DevFailed {
        PipeBlob blob = this.getPipeBlob();
        PipeDataElement el = (PipeDataElement)blob.get(this.ndx.getAndIncrement());
        if (el.getType() != 30) {
            throw new DevFailed("Wrong type! Expected PipeBlob, but was " + TangoConst.Tango_CmdArgTypeName[el.getType()], DEV_ERRORS);
        }
        return new DevicePipe(this.pipeName, el.extractPipeBlob());
    }

    @Override
    public <T> void nextArray(T[] target, int size) throws DevFailed {
        Object array = this.nextArray();
        if (Array.getLength(array) != size) {
            throw new DevFailed("size is not equal to array's length: " + size + "!=" + Array.getLength(array), DEV_ERRORS);
        }
        if (target.getClass().getComponentType() != array.getClass().getComponentType()) {
            throw new DevFailed("target array type " + target.getClass().getComponentType() + " does not match underlying array type " + array.getClass().getComponentType(), new DevError[0]);
        }
        System.arraycopy(array, 0, target, 0, size);
    }

    @Override
    public void nextArray(Object target, int size) throws DevFailed {
        Object array = this.nextArray();
        if (Array.getLength(array) != size) {
            throw new DevFailed("size is not equal to array's length: " + size + "!=" + Array.getLength(array), DEV_ERRORS);
        }
        if (target.getClass().getComponentType() != array.getClass().getComponentType()) {
            throw new DevFailed("target array type " + target.getClass().getComponentType() + " does not match underlying array type " + array.getClass().getComponentType(), DEV_ERRORS);
        }
        System.arraycopy(array, 0, target, 0, size);
    }

    private Object nextArray() throws DevFailed {
        if (!this.hasNext()) {
            throw new DevFailed("EOF pipe has reached!", DEV_ERRORS);
        }
        PipeDataElement el = (PipeDataElement)this.getPipeBlob().get(this.ndx.getAndIncrement());
        switch (el.getType()) {
            case 30: {
                throw new DevFailed("Unexpected state! Blobs are not welcome here...", DEV_ERRORS);
            }
            case 1: {
                return el.extractBooleanArray();
            }
            case 21: {
                return el.extractCharArray();
            }
            case 22: {
                return el.extractUCharArray();
            }
            case 2: {
                return el.extractShortArray();
            }
            case 6: {
                return el.extractUShortArray();
            }
            case 3: {
                return el.extractLongArray();
            }
            case 7: {
                return el.extractULongArray();
            }
            case 23: {
                return el.extractLong64Array();
            }
            case 5: {
                return el.extractDoubleArray();
            }
            case 4: {
                return el.extractFloatArray();
            }
            case 8: {
                return el.extractStringArray();
            }
            case 19: {
                return el.extractDevStateArray();
            }
            case 28: {
                return el.extractDevEncodedArray();
            }
        }
        throw new AssertionError((Object)"Unreachable statement");
    }
}

