/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DbPipe;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DbDevice
implements Serializable {
    private Database database;
    private String deviceName;

    public DbDevice(String deviceName) throws DevFailed {
        TangoUrl url = new TangoUrl(deviceName);
        if (!url.use_db) {
            Except.throw_non_db_exception("Api_NonDatabaseDevice", "Device " + deviceName + " do not use database", "DbDevice.DbDevice()");
        }
        this.database = ApiUtil.get_db_obj();
        this.deviceName = deviceName;
    }

    public DbDevice(String deviceName, String host, String port) throws DevFailed {
        this.database = host == null || port == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(host, port);
        this.deviceName = deviceName;
    }

    public DeviceInfo get_info() throws DevFailed {
        return this.database.get_device_info(this.deviceName);
    }

    public DbDevImportInfo import_device() throws DevFailed {
        return this.database.import_device(this.deviceName);
    }

    public void export_device(DbDevExportInfo devinfo) throws DevFailed {
        this.database.export_device(devinfo);
    }

    public void unexport_device() throws DevFailed {
        this.database.unexport_device(this.deviceName);
    }

    public void add_device(DbDevInfo devinfo) throws DevFailed {
        this.database.add_device(devinfo);
    }

    public void delete_device() throws DevFailed {
        this.database.delete_device(this.deviceName);
    }

    public String get_class() throws DevFailed {
        return this.database.get_class_for_device(this.deviceName);
    }

    public String[] get_class_inheritance() throws DevFailed {
        return this.database.get_class_inheritance_for_device(this.deviceName);
    }

    public void put_alias(String aliasName) throws DevFailed {
        this.database.put_device_alias(this.deviceName, aliasName);
    }

    public String get_alias() throws DevFailed {
        if (this.deviceName.contains("/")) {
            this.deviceName = ApiUtil.get_db_obj().get_device_from_alias(this.deviceName);
        }
        return this.database.get_alias_from_device(this.deviceName);
    }

    public String[] get_property_list(String wildcard) throws DevFailed {
        return this.database.get_device_property_list(this.deviceName, wildcard);
    }

    public DbDatum[] get_property(String[] propertyNames) throws DevFailed {
        return this.database.get_device_property(this.deviceName, propertyNames);
    }

    public DbDatum get_property(String propertyName) throws DevFailed {
        return this.database.get_device_property(this.deviceName, propertyName);
    }

    public DbDatum[] get_property(DbDatum[] properties) throws DevFailed {
        return this.database.get_device_property(this.deviceName, properties);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        this.database.put_device_property(this.deviceName, properties);
    }

    public void delete_property(String[] propnames) throws DevFailed {
        this.database.delete_device_property(this.deviceName, propnames);
    }

    public void delete_property(String propertyName) throws DevFailed {
        this.database.delete_device_property(this.deviceName, propertyName);
    }

    public void delete_property(DbDatum[] properties) throws DevFailed {
        this.database.delete_device_property(this.deviceName, properties);
    }

    public void put_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.database.put_device_attribute_property(this.deviceName, attr);
    }

    public void put_attribute_property(DbAttribute attr) throws DevFailed {
        this.database.put_device_attribute_property(this.deviceName, attr);
    }

    public void delete_attribute_property(String attname, String[] propnames) throws DevFailed {
        this.database.delete_device_attribute_property(this.deviceName, attname, propnames);
    }

    public void delete_attribute_property(String attname, String propname) throws DevFailed {
        this.database.delete_device_attribute_property(this.deviceName, attname, propname);
    }

    public void delete_attribute_property(DbAttribute attr) throws DevFailed {
        this.database.delete_device_attribute_property(this.deviceName, attr);
    }

    public void delete_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.database.delete_device_attribute_property(this.deviceName, attr);
    }

    public String[] get_attribute_list() throws DevFailed {
        return this.database.get_device_attribute_list(this.deviceName);
    }

    public DbAttribute[] get_attribute_property(String[] attributeNames) throws DevFailed {
        return this.database.get_device_attribute_property(this.deviceName, attributeNames);
    }

    public DbAttribute get_attribute_property(String attributeNames) throws DevFailed {
        return this.database.get_device_attribute_property(this.deviceName, attributeNames);
    }

    public void delete_attribute(String attributeNames) throws DevFailed {
        this.database.delete_device_attribute(this.deviceName, attributeNames);
    }

    public int get_attribute_polling_period(String attributeNames) throws DevFailed {
        return this.get_polling_period(attributeNames, 1);
    }

    public int get_command_polling_period(String commandName) throws DevFailed {
        return this.get_polling_period(commandName, 0);
    }

    private int get_polling_period(String name, int src) throws DevFailed {
        String propname = src == 1 ? "polled_attr" : "polled_cmd";
        DbDatum datum = this.get_property(propname);
        if (datum.is_empty()) {
            Except.throw_exception("NOT_POLLED", (src == 1 ? "Attribute " : "Command ") + name + " not polled", "DbDevice.get_polling_period()");
        }
        String[] str = datum.extractStringArray();
        String _name = name.toLowerCase();
        for (int i = 0; i < str.length; i += 2) {
            if (!str[i].toLowerCase().equals(_name)) continue;
            if (i < str.length - 1) {
                try {
                    return Integer.parseInt(str[i + 1]);
                }
                catch (NumberFormatException e) {
                    Except.throw_exception("BAD_PARAM", "Period value is not coherent", "DbDevice.get_polling_period()");
                    continue;
                }
            }
            Except.throw_exception("BAD_PARAM", "Period value is not coherent", "DbDevice.get_polling_period()");
        }
        Except.throw_exception("NOT_POLLED", (src == 1 ? "Attribute " : "Command ") + name + " not polled", "DbDevice.get_polling_period()");
        return -1;
    }

    public String getName() {
        return this.deviceName;
    }

    public String name() {
        return this.deviceName;
    }

    public DbPipe getPipeProperties(String pipeName) throws DevFailed {
        return this.database.getDevicePipeProperties(this.deviceName, pipeName);
    }

    public DbDatum getPipeProperty(String pipeName, String propertyName) throws DevFailed {
        DbPipe dbPipe = this.database.getDevicePipeProperties(this.deviceName, pipeName);
        DbDatum datum = dbPipe.getDatum(propertyName);
        if (datum == null) {
            Except.throw_exception("TangoApi_PropertyNotFound", "Property " + propertyName + " not found for pipe " + pipeName);
        }
        return datum;
    }

    public void putPipeProperty(DbPipe dbPipe) throws DevFailed {
        this.database.putDevicePipeProperty(this.deviceName, dbPipe);
    }

    public void putPipeProperty(ArrayList<DbPipe> dbPipes) throws DevFailed {
        for (DbPipe dbPipe : dbPipes) {
            this.database.putDevicePipeProperty(this.deviceName, dbPipe);
        }
    }

    public List<String> getPipeList() throws DevFailed {
        return this.getPipeList("*");
    }

    public List<String> getPipeList(String wildcard) throws DevFailed {
        return this.database.getDevicePipeList(this.deviceName, wildcard);
    }

    public void deletePipeProperty(String pipeName, String propertyName) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(propertyName);
        this.deletePipeProperties(pipeName, list);
    }

    public void deletePipeProperties(String pipeName, String[] propertyNames) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(propertyNames.length);
        Collections.addAll(list, propertyNames);
        this.deletePipeProperties(pipeName, list);
    }

    public void deletePipeProperties(String pipeName, List<String> propertyNames) throws DevFailed {
        this.database.deleteDevicePipeProperties(this.deviceName, pipeName, propertyNames);
    }

    public void deletePipe(String pipeName) throws DevFailed {
        this.database.deleteDevicePipe(this.deviceName, pipeName);
    }

    public void deleteAllPipeProperty(String pipeName) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(pipeName);
        this.deleteAllPipeProperty(list);
    }

    public void deleteAllPipeProperty(String[] pipeNames) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(pipeNames.length);
        Collections.addAll(list, pipeNames);
        this.deleteAllPipeProperty(list);
    }

    public void deleteAllPipeProperty(List<String> pipeNames) throws DevFailed {
        this.database.deleteAllDevicePipeProperty(this.deviceName, pipeNames);
    }

    public List<DbHistory> getPipePropertyHistory(String pipeName, String propertyName) throws DevFailed {
        return this.database.getDevicePipePropertyHistory(this.deviceName, pipeName, propertyName);
    }
}

