/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DbPipe;
import fr.esrf.TangoDs.Except;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DbClass
implements Serializable {
    private Database database;
    private String className;

    public DbClass(String className) throws DevFailed {
        this.database = ApiUtil.get_db_obj();
        this.className = className;
    }

    public DbClass(String className, String host, String port) throws DevFailed {
        this.database = ApiUtil.get_db_obj(host, port);
        this.className = className;
    }

    public String[] get_property_list(String wildcard) throws DevFailed {
        return this.database.get_class_property_list(this.className, wildcard);
    }

    public DbDatum[] get_property(String[] propertyNames) throws DevFailed {
        return this.database.get_class_property(this.className, propertyNames);
    }

    public DbDatum get_property(String propertyName) throws DevFailed {
        return this.database.get_class_property(this.className, propertyName);
    }

    public DbDatum[] get_property(DbDatum[] properties) throws DevFailed {
        return this.database.get_class_property(this.className, properties);
    }

    public void put_property(DbDatum[] properties) throws DevFailed {
        this.database.put_class_property(this.className, properties);
    }

    public void delete_property(String[] propertyNames) throws DevFailed {
        this.database.delete_class_property(this.className, propertyNames);
    }

    public void delete_property(String propertyName) throws DevFailed {
        this.database.delete_class_property(this.className, propertyName);
    }

    public void delete_property(DbDatum[] properties) throws DevFailed {
        this.database.delete_class_property(this.className, properties);
    }

    public String[] get_attribute_list(String wildcard) throws DevFailed {
        return this.database.get_class_attribute_list(this.className, wildcard);
    }

    public void put_attribute_property(DbAttribute[] attr) throws DevFailed {
        this.database.put_class_attribute_property(this.className, attr);
    }

    public void put_attribute_property(DbAttribute attr) throws DevFailed {
        this.database.put_class_attribute_property(this.className, attr);
    }

    public void delete_attribute_property(String attributeName, String[] propertyNames) throws DevFailed {
        this.database.delete_class_attribute_property(this.className, attributeName, propertyNames);
    }

    public void delete_attribute_property(String attributeName, String propertyName) throws DevFailed {
        this.database.delete_class_attribute_property(this.className, attributeName, propertyName);
    }

    public DbAttribute[] get_attribute_property(String[] attributeNames) throws DevFailed {
        return this.database.get_class_attribute_property(this.className, attributeNames);
    }

    public DbAttribute get_attribute_property(String attributeName) throws DevFailed {
        return this.database.get_class_attribute_property(this.className, attributeName);
    }

    public String name() {
        return this.className;
    }

    public DbPipe getPipeProperties(String pipeName) throws DevFailed {
        return this.database.getClassPipeProperties(this.className, pipeName);
    }

    public DbDatum getPipeProperty(String pipeName, String propertyName) throws DevFailed {
        DbPipe dbPipe = this.database.getClassPipeProperties(this.className, pipeName);
        DbDatum datum = dbPipe.getDatum(propertyName);
        if (datum == null) {
            Except.throw_exception("TangoApi_PropertyNotFound", "Property " + propertyName + " not found for pipe " + pipeName);
        }
        return datum;
    }

    public void putPipeProperty(DbPipe dbPipe) throws DevFailed {
        this.database.putClassPipeProperty(this.className, dbPipe);
    }

    public void putPipeProperty(ArrayList<DbPipe> dbPipes) throws DevFailed {
        for (DbPipe dbPipe : dbPipes) {
            this.database.putClassPipeProperty(this.className, dbPipe);
        }
    }

    public List<String> getPipeList() throws DevFailed {
        return this.getPipeList("*");
    }

    public List<String> getPipeList(String wildcard) throws DevFailed {
        return this.database.getClassPipeList(this.className, wildcard);
    }

    public void deletePipeProperty(String pipeName, String propertyName) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(propertyName);
        this.deletePipeProperties(pipeName, list);
    }

    public void deletePipeProperties(String pipeName, String[] propertyNames) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>(propertyNames.length);
        Collections.addAll(list, propertyNames);
        this.deletePipeProperties(pipeName, list);
    }

    public void deletePipeProperties(String pipeName, List<String> propertyNames) throws DevFailed {
        this.database.deleteClassPipeProperties(this.className, pipeName, propertyNames);
    }

    public void deletePipe(String pipeName) throws DevFailed {
        this.database.deleteClassPipe(this.className, pipeName);
    }

    public List<DbHistory> getPipePropertyHistory(String pipeName, String propertyName) throws DevFailed {
        return this.database.getClassPipePropertyHistory(this.className, pipeName, propertyName);
    }
}

