/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import zmq.Clock;
import zmq.Ctx;
import zmq.Msg;
import zmq.PollItem;
import zmq.Proxy;
import zmq.SocketBase;
import zmq.ZError;

public class ZMQ {
    public static final int ZMQ_VERSION_MAJOR = 3;
    public static final int ZMQ_VERSION_MINOR = 2;
    public static final int ZMQ_VERSION_PATCH = 2;
    public static final int ZMQ_IO_THREADS = 1;
    public static final int ZMQ_MAX_SOCKETS = 2;
    public static final int ZMQ_IO_THREADS_DFLT = 1;
    public static final int ZMQ_MAX_SOCKETS_DFLT = 1024;
    public static final int ZMQ_PAIR = 0;
    public static final int ZMQ_PUB = 1;
    public static final int ZMQ_SUB = 2;
    public static final int ZMQ_REQ = 3;
    public static final int ZMQ_REP = 4;
    public static final int ZMQ_DEALER = 5;
    public static final int ZMQ_ROUTER = 6;
    public static final int ZMQ_PULL = 7;
    public static final int ZMQ_PUSH = 8;
    public static final int ZMQ_XPUB = 9;
    public static final int ZMQ_XSUB = 10;
    @Deprecated
    public static final int ZMQ_XREQ = 5;
    @Deprecated
    public static final int ZMQ_XREP = 6;
    public static final int ZMQ_AFFINITY = 4;
    public static final int ZMQ_IDENTITY = 5;
    public static final int ZMQ_SUBSCRIBE = 6;
    public static final int ZMQ_UNSUBSCRIBE = 7;
    public static final int ZMQ_RATE = 8;
    public static final int ZMQ_RECOVERY_IVL = 9;
    public static final int ZMQ_SNDBUF = 11;
    public static final int ZMQ_RCVBUF = 12;
    public static final int ZMQ_RCVMORE = 13;
    public static final int ZMQ_FD = 14;
    public static final int ZMQ_EVENTS = 15;
    public static final int ZMQ_TYPE = 16;
    public static final int ZMQ_LINGER = 17;
    public static final int ZMQ_RECONNECT_IVL = 18;
    public static final int ZMQ_BACKLOG = 19;
    public static final int ZMQ_RECONNECT_IVL_MAX = 21;
    public static final int ZMQ_MAXMSGSIZE = 22;
    public static final int ZMQ_SNDHWM = 23;
    public static final int ZMQ_RCVHWM = 24;
    public static final int ZMQ_MULTICAST_HOPS = 25;
    public static final int ZMQ_RCVTIMEO = 27;
    public static final int ZMQ_SNDTIMEO = 28;
    public static final int ZMQ_IPV4ONLY = 31;
    public static final int ZMQ_LAST_ENDPOINT = 32;
    public static final int ZMQ_ROUTER_MANDATORY = 33;
    public static final int ZMQ_TCP_KEEPALIVE = 34;
    public static final int ZMQ_TCP_KEEPALIVE_CNT = 35;
    public static final int ZMQ_TCP_KEEPALIVE_IDLE = 36;
    public static final int ZMQ_TCP_KEEPALIVE_INTVL = 37;
    public static final int ZMQ_TCP_ACCEPT_FILTER = 38;
    public static final int ZMQ_DELAY_ATTACH_ON_CONNECT = 39;
    public static final int ZMQ_XPUB_VERBOSE = 40;
    public static final int ZMQ_ENCODER = 1001;
    public static final int ZMQ_DECODER = 1002;
    public static final int ZMQ_MORE = 1;
    public static final int ZMQ_DONTWAIT = 1;
    public static final int ZMQ_SNDMORE = 2;
    public static final int ZMQ_NOBLOCK = 1;
    public static final int ZMQ_FAIL_UNROUTABLE = 33;
    public static final int ZMQ_ROUTER_BEHAVIOR = 33;
    public static final int ZMQ_EVENT_CONNECTED = 1;
    public static final int ZMQ_EVENT_CONNECT_DELAYED = 2;
    public static final int ZMQ_EVENT_CONNECT_RETRIED = 4;
    public static final int ZMQ_EVENT_CONNECT_FAILED = 1024;
    public static final int ZMQ_EVENT_LISTENING = 8;
    public static final int ZMQ_EVENT_BIND_FAILED = 16;
    public static final int ZMQ_EVENT_ACCEPTED = 32;
    public static final int ZMQ_EVENT_ACCEPT_FAILED = 64;
    public static final int ZMQ_EVENT_CLOSED = 128;
    public static final int ZMQ_EVENT_CLOSE_FAILED = 256;
    public static final int ZMQ_EVENT_DISCONNECTED = 512;
    public static final int ZMQ_EVENT_ALL = 1023;
    public static final int ZMQ_POLLIN = 1;
    public static final int ZMQ_POLLOUT = 2;
    public static final int ZMQ_POLLERR = 4;
    public static final int ZMQ_STREAMER = 1;
    public static final int ZMQ_FORWARDER = 2;
    public static final int ZMQ_QUEUE = 3;
    private static final ThreadLocal<PollSelector> POLL_SELECTOR = new ThreadLocal();

    public static Ctx zmq_ctx_new() {
        Ctx ctx = new Ctx();
        return ctx;
    }

    private static void zmq_ctx_destroy(Ctx ctx_) {
        if (ctx_ == null || !ctx_.check_tag()) {
            throw new IllegalStateException();
        }
        ctx_.terminate();
    }

    public static void zmq_ctx_set(Ctx ctx_, int option_, int optval_) {
        if (ctx_ == null || !ctx_.check_tag()) {
            throw new IllegalStateException();
        }
        ctx_.set(option_, optval_);
    }

    public static int zmq_ctx_get(Ctx ctx_, int option_) {
        if (ctx_ == null || !ctx_.check_tag()) {
            throw new IllegalStateException();
        }
        return ctx_.get(option_);
    }

    public static Ctx zmq_init(int io_threads_) {
        if (io_threads_ >= 0) {
            Ctx ctx = ZMQ.zmq_ctx_new();
            ZMQ.zmq_ctx_set(ctx, 1, io_threads_);
            return ctx;
        }
        throw new IllegalArgumentException("io_threds must not be negative");
    }

    public static void zmq_term(Ctx ctx_) {
        ZMQ.zmq_ctx_destroy(ctx_);
    }

    public static SocketBase zmq_socket(Ctx ctx_, int type_) {
        if (ctx_ == null || !ctx_.check_tag()) {
            throw new IllegalStateException();
        }
        SocketBase s = ctx_.create_socket(type_);
        return s;
    }

    public static void zmq_close(SocketBase s_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        s_.close();
    }

    public static void zmq_setsockopt(SocketBase s_, int option_, Object optval_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        s_.setsockopt(option_, optval_);
    }

    public static Object zmq_getsockoptx(SocketBase s_, int option_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        return s_.getsockoptx(option_);
    }

    public static int zmq_getsockopt(SocketBase s_, int opt) {
        return s_.getsockopt(opt);
    }

    public static boolean zmq_socket_monitor(SocketBase s_, String addr_, int events_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        return s_.monitor(addr_, events_);
    }

    public static boolean zmq_bind(SocketBase s_, String addr_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        return s_.bind(addr_);
    }

    public static boolean zmq_connect(SocketBase s_, String addr_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        return s_.connect(addr_);
    }

    public static boolean zmq_unbind(SocketBase s_, String addr_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        return s_.term_endpoint(addr_);
    }

    public static boolean zmq_disconnect(SocketBase s_, String addr_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        return s_.term_endpoint(addr_);
    }

    public static int zmq_send(SocketBase s_, String str, int flags_) {
        byte[] data = str.getBytes();
        return ZMQ.zmq_send(s_, data, data.length, flags_);
    }

    public static int zmq_send(SocketBase s_, Msg msg, int flags_) {
        int rc = ZMQ.s_sendmsg(s_, msg, flags_);
        if (rc < 0) {
            return -1;
        }
        return rc;
    }

    public static int zmq_send(SocketBase s_, byte[] buf_, int len_, int flags_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        Msg msg = new Msg(len_);
        msg.put(buf_, 0, len_);
        int rc = ZMQ.s_sendmsg(s_, msg, flags_);
        if (rc < 0) {
            return -1;
        }
        return rc;
    }

    public int zmq_sendiov(SocketBase s_, byte[][] a_, int count_, int flags_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        int rc = 0;
        for (int i = 0; i < count_; ++i) {
            Msg msg = new Msg(a_[i]);
            if (i == count_ - 1) {
                flags_ &= 0xFFFFFFFD;
            }
            if ((rc = ZMQ.s_sendmsg(s_, msg, flags_)) >= 0) continue;
            rc = -1;
            break;
        }
        return rc;
    }

    private static int s_sendmsg(SocketBase s_, Msg msg_, int flags_) {
        int sz = ZMQ.zmq_msg_size(msg_);
        boolean rc = s_.send(msg_, flags_);
        if (!rc) {
            return -1;
        }
        return sz;
    }

    public static Msg zmq_recv(SocketBase s_, int flags_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        Msg msg = ZMQ.s_recvmsg(s_, flags_);
        if (msg == null) {
            return null;
        }
        return msg;
    }

    public int zmq_recviov(SocketBase s_, byte[][] a_, int count_, int flags_) {
        if (s_ == null || !s_.check_tag()) {
            throw new IllegalStateException();
        }
        int nread = 0;
        boolean recvmore = true;
        for (int i = 0; recvmore && i < count_; ++i) {
            Msg msg = ZMQ.s_recvmsg(s_, flags_);
            if (msg == null) {
                nread = -1;
                break;
            }
            a_[i] = msg.data();
            recvmore = msg.has_more();
        }
        return nread;
    }

    public static Msg s_recvmsg(SocketBase s_, int flags_) {
        return s_.recv(flags_);
    }

    public static Msg zmq_msg_init() {
        return new Msg();
    }

    public static Msg zmq_msg_init_size(int message_size) {
        return new Msg(message_size);
    }

    public static int zmq_msg_size(Msg msg_) {
        return msg_.size();
    }

    public static Msg zmq_recvmsg(SocketBase s_, int flags_) {
        return ZMQ.zmq_recv(s_, flags_);
    }

    public static int zmq_sendmsg(SocketBase s_, Msg msg_, int flags_) {
        return ZMQ.zmq_send(s_, msg_, flags_);
    }

    public static int zmq_msg_get(Msg msg_) {
        return ZMQ.zmq_msg_get(msg_, 1);
    }

    public static int zmq_msg_get(Msg msg_, int option_) {
        switch (option_) {
            case 1: {
                return msg_.has_more() ? 1 : 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public static void zmq_sleep(int s) {
        try {
            Thread.sleep((long)s * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean zmq_proxy(SocketBase frontend_, SocketBase backend_, SocketBase control_) {
        if (frontend_ == null || backend_ == null) {
            throw new IllegalArgumentException();
        }
        return Proxy.proxy(frontend_, backend_, control_);
    }

    @Deprecated
    public static boolean zmq_device(int device_, SocketBase insocket_, SocketBase outsocket_) {
        return Proxy.proxy(insocket_, outsocket_, null);
    }

    public static int zmq_poll(PollItem[] items_, long timeout_) {
        return ZMQ.zmq_poll(items_, items_.length, timeout_);
    }

    public static int zmq_poll(PollItem[] items_, int count, long timeout_) {
        Selector selector = null;
        try {
            selector = PollSelector.open();
        }
        catch (IOException e) {
            throw new ZError.IOException(e);
        }
        int ret = ZMQ.zmq_poll(selector, items_, count, timeout_);
        return ret;
    }

    public static int zmq_poll(Selector selector, PollItem[] items_, long timeout_) {
        return ZMQ.zmq_poll(selector, items_, items_.length, timeout_);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zmq_poll(Selector selector, PollItem[] items_, int count, long timeout_) {
        if (items_ == null) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            if (timeout_ == 0L) {
                return 0;
            }
            try {
                Thread.sleep(timeout_);
                return 0;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            return 0;
        }
        long now = 0L;
        long end = 0L;
        HashMap<SelectableChannel, SelectionKey> saved = new HashMap<SelectableChannel, SelectionKey>();
        for (SelectionKey key : selector.keys()) {
            if (!key.isValid()) continue;
            saved.put(key.channel(), key);
        }
        for (int i = 0; i < count; ++i) {
            PollItem item = items_[i];
            if (item == null) continue;
            SelectableChannel ch = item.getChannel();
            SelectionKey key = (SelectionKey)saved.remove(ch);
            if (key != null) {
                if (key.interestOps() != item.interestOps()) {
                    key.interestOps(item.interestOps());
                }
                key.attach(item);
                continue;
            }
            try {
                ch.register(selector, item.interestOps(), item);
                continue;
            }
            catch (ClosedChannelException e) {
                throw new ZError.IOException(e);
            }
        }
        if (!saved.isEmpty()) {
            for (SelectionKey deprecated : saved.values()) {
                deprecated.cancel();
            }
        }
        boolean first_pass = true;
        int nevents = 0;
        while (true) {
            long timeout = first_pass ? 0L : (timeout_ < 0L ? -1L : end - now);
            try {
                int rc = 0;
                rc = timeout < 0L ? selector.select(0L) : (timeout == 0L ? selector.selectNow() : selector.select(timeout));
                for (SelectionKey key : selector.keys()) {
                    PollItem item = (PollItem)key.attachment();
                    int ready = item.readyOps(key, rc);
                    if (ready < 0) {
                        return -1;
                    }
                    if (ready <= 0) continue;
                    ++nevents;
                }
                selector.selectedKeys().clear();
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
            if (timeout_ == 0L || nevents > 0) return nevents;
            if (timeout_ < 0L) {
                if (!first_pass) continue;
                first_pass = false;
                continue;
            }
            if (first_pass) {
                now = Clock.now_ms();
                if (now == (end = now + timeout_)) return nevents;
                first_pass = false;
                continue;
            }
            now = Clock.now_ms();
            if (now >= end) return nevents;
        }
    }

    public static long zmq_stopwatch_start() {
        return System.nanoTime();
    }

    public static long zmq_stopwatch_stop(long watch) {
        return (System.nanoTime() - watch) / 1000L;
    }

    public static int ZMQ_MAKE_VERSION(int major, int minor, int patch) {
        return major * 10000 + minor * 100 + patch;
    }

    public static String zmq_strerror(int errno) {
        return "Errno = " + errno;
    }

    private static class PollSelector {
        private Selector selector;

        private PollSelector(Selector selector) {
            this.selector = selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Selector open() throws IOException {
            PollSelector polls = (PollSelector)POLL_SELECTOR.get();
            if (polls == null) {
                ThreadLocal threadLocal = POLL_SELECTOR;
                synchronized (threadLocal) {
                    polls = (PollSelector)POLL_SELECTOR.get();
                    try {
                        if (polls == null) {
                            polls = new PollSelector(Selector.open());
                            POLL_SELECTOR.set(polls);
                        }
                    }
                    catch (IOException e) {
                        throw new ZError.IOException(e);
                    }
                }
            }
            return polls.get();
        }

        public Selector get() {
            assert (this.selector != null);
            assert (this.selector.isOpen());
            return this.selector;
        }

        public void finalize() {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class Event {
        private static final int VALUE_INTEGER = 1;
        private static final int VALUE_CHANNEL = 2;
        public final int event;
        public final String addr;
        private final Object arg;
        private final int flag;

        public Event(int event, String addr, Object arg) {
            this.event = event;
            this.addr = addr;
            this.arg = arg;
            this.flag = arg instanceof Integer ? 1 : (arg instanceof SelectableChannel ? 2 : 0);
        }

        public boolean write(SocketBase s) {
            int size = 5 + this.addr.length() + 1;
            if (this.flag == 1) {
                size += 4;
            }
            ByteBuffer buffer = ByteBuffer.allocate(size);
            buffer.putInt(this.event);
            buffer.put((byte)this.addr.length());
            buffer.put(this.addr.getBytes());
            buffer.put((byte)this.flag);
            if (this.flag == 1) {
                buffer.putInt((Integer)this.arg);
            }
            Msg msg = new Msg(buffer);
            return s.send(msg, 0);
        }

        public static Event read(SocketBase s) {
            Msg msg = s.recv(0);
            if (msg == null) {
                return null;
            }
            ByteBuffer buffer = msg.buf();
            int event = buffer.getInt();
            byte len = buffer.get();
            byte[] addr = new byte[len];
            buffer.get(addr);
            byte flag = buffer.get();
            Integer arg = null;
            if (flag == 1) {
                arg = buffer.getInt();
            }
            return new Event(event, new String(addr), arg);
        }
    }
}

