/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Address;
import zmq.Ctx;
import zmq.Dealer;
import zmq.IOThread;
import zmq.Msg;
import zmq.Options;
import zmq.SocketBase;

public class Req
extends Dealer {
    private boolean receiving_reply = false;
    private boolean message_begins = true;

    public Req(Ctx parent_, int tid_, int sid_) {
        super(parent_, tid_, sid_);
        this.options.type = 3;
    }

    @Override
    public boolean xsend(Msg msg_) {
        boolean rc;
        if (this.receiving_reply) {
            throw new IllegalStateException("Cannot send another request");
        }
        if (this.message_begins) {
            Msg bottom = new Msg();
            bottom.set_flags(1);
            rc = super.xsend(bottom);
            if (!rc) {
                return rc;
            }
            this.message_begins = false;
        }
        boolean more = msg_.has_more();
        rc = super.xsend(msg_);
        if (!rc) {
            return rc;
        }
        if (!more) {
            this.receiving_reply = true;
            this.message_begins = true;
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        if (!this.receiving_reply) {
            throw new IllegalStateException("Cannot wait before send");
        }
        Msg msg_ = null;
        if (this.message_begins) {
            msg_ = super.xrecv();
            if (msg_ == null) {
                return null;
            }
            if (!msg_.has_more() || msg_.size() != 0) {
                do {
                    msg_ = super.xrecv();
                    assert (msg_ != null);
                } while (msg_.has_more());
                this.errno.set(35);
                return null;
            }
            this.message_begins = false;
        }
        if ((msg_ = super.xrecv()) == null) {
            return null;
        }
        if (!msg_.has_more()) {
            this.receiving_reply = false;
            this.message_begins = true;
        }
        return msg_;
    }

    @Override
    public boolean xhas_in() {
        if (!this.receiving_reply) {
            return false;
        }
        return super.xhas_in();
    }

    @Override
    public boolean xhas_out() {
        if (this.receiving_reply) {
            return false;
        }
        return super.xhas_out();
    }

    public static class ReqSession
    extends Dealer.DealerSession {
        State state = State.identity;

        public ReqSession(IOThread io_thread_, boolean connect_, SocketBase socket_, Options options_, Address addr_) {
            super(io_thread_, connect_, socket_, options_, addr_);
        }

        @Override
        public int push_msg(Msg msg_) {
            switch (this.state) {
                case bottom: {
                    if (msg_.flags() != 1 || msg_.size() != 0) break;
                    this.state = State.body;
                    return super.push_msg(msg_);
                }
                case body: {
                    if (msg_.flags() == 1) {
                        return super.push_msg(msg_);
                    }
                    if (msg_.flags() != 0) break;
                    this.state = State.bottom;
                    return super.push_msg(msg_);
                }
                case identity: {
                    if (msg_.flags() != 0) break;
                    this.state = State.bottom;
                    return super.push_msg(msg_);
                }
            }
            throw new IllegalStateException(this.state.toString());
        }

        @Override
        public void reset() {
            super.reset();
            this.state = State.identity;
        }

        static enum State {
            identity,
            bottom,
            body;

        }
    }
}

