/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Address {
    private final String protocol;
    private final String address;
    private IZAddress resolved;

    public Address(String protocol_, String address_) {
        this.protocol = protocol_;
        this.address = address_;
        this.resolved = null;
    }

    public Address(SocketAddress sockaddr_) {
        this.protocol = "tcp";
        InetSocketAddress sockaddr = (InetSocketAddress)sockaddr_;
        this.address = sockaddr.getAddress().getHostAddress() + ":" + sockaddr.getPort();
    }

    public String toString() {
        if (this.protocol.equals("tcp") ? this.resolved != null : this.protocol.equals("ipc") && this.resolved != null) {
            return ((Object)this.resolved).toString();
        }
        if (!this.protocol.isEmpty() && !this.address.isEmpty()) {
            return this.protocol + "://" + this.address;
        }
        return null;
    }

    public String protocol() {
        return this.protocol;
    }

    public String address() {
        return this.address;
    }

    public IZAddress resolved() {
        return this.resolved;
    }

    public IZAddress resolved(IZAddress value) {
        this.resolved = value;
        return this.resolved;
    }

    public static interface IZAddress {
        public String toString();

        public void resolve(String var1, boolean var2);

        public SocketAddress address();
    }
}

