/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import org.zeromq.ZMQException;
import zmq.Ctx;
import zmq.DecoderBase;
import zmq.EncoderBase;
import zmq.Msg;
import zmq.SocketBase;
import zmq.ZError;

public class ZMQ {
    public static final int SNDMORE = 2;
    public static final int DONTWAIT = 1;
    public static final int NOBLOCK = 1;
    public static final int PAIR = 0;
    public static final int PUB = 1;
    public static final int SUB = 2;
    public static final int REQ = 3;
    public static final int REP = 4;
    public static final int DEALER = 5;
    public static final int XREQ = 5;
    public static final int ROUTER = 6;
    public static final int XREP = 6;
    public static final int PULL = 7;
    public static final int PUSH = 8;
    public static final int XPUB = 9;
    public static final int XSUB = 10;
    public static final int STREAMER = 1;
    public static final int FORWARDER = 2;
    public static final int QUEUE = 3;
    @Deprecated
    public static final int UPSTREAM = 7;
    @Deprecated
    public static final int DOWNSTREAM = 8;
    public static final int EVENT_CONNECTED = 1;
    public static final int EVENT_DELAYED = 2;
    public static final int EVENT_RETRIED = 4;
    public static final int EVENT_CONNECT_FAILED = 1024;
    public static final int EVENT_LISTENING = 8;
    public static final int EVENT_BIND_FAILED = 16;
    public static final int EVENT_ACCEPTED = 32;
    public static final int EVENT_ACCEPT_FAILED = 64;
    public static final int EVENT_CLOSED = 128;
    public static final int EVENT_CLOSE_FAILED = 256;
    public static final int EVENT_DISCONNECTED = 512;
    public static final int EVENT_ALL = 1023;

    public static Context context(int ioThreads) {
        return new Context(ioThreads);
    }

    @Deprecated
    public static boolean device(int type_, Socket frontend, Socket backend) {
        return zmq.ZMQ.zmq_proxy(frontend.base, backend.base, null);
    }

    public static boolean proxy(Socket frontend, Socket backend, Socket capture) {
        return zmq.ZMQ.zmq_proxy(frontend.base, backend.base, capture != null ? capture.base : null);
    }

    public static int poll(PollItem[] items, long timeout) {
        return ZMQ.poll(items, items.length, timeout);
    }

    public static int poll(PollItem[] items, int count, long timeout) {
        zmq.PollItem[] items_ = new zmq.PollItem[count];
        for (int i = 0; i < count; ++i) {
            items_[i] = items[i].base;
        }
        return zmq.ZMQ.zmq_poll(items_, count, timeout);
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 2;
    }

    public static int getPatchVersion() {
        return 2;
    }

    public static int getFullVersion() {
        return zmq.ZMQ.ZMQ_MAKE_VERSION(3, 2, 2);
    }

    public static int makeVersion(int major, int minor, int patch) {
        return zmq.ZMQ.ZMQ_MAKE_VERSION(major, minor, patch);
    }

    public static String getVersionString() {
        return "3.2.2";
    }

    public static enum Error {
        ENOTSUP(45L),
        EPROTONOSUPPORT(43L),
        ENOBUFS(55L),
        ENETDOWN(50L),
        EADDRINUSE(48L),
        EADDRNOTAVAIL(49L),
        ECONNREFUSED(61L),
        EINPROGRESS(36L),
        EMTHREAD(156384766L),
        EFSM(156384763L),
        ENOCOMPATPROTO(156384764L),
        ETERM(156384765L);

        private final long code;

        private Error(long code) {
            this.code = code;
        }

        public long getCode() {
            return this.code;
        }

        public static Error findByCode(int code) {
            for (Error e : (Error[])Error.class.getEnumConstants()) {
                if (e.getCode() != (long)code) continue;
                return e;
            }
            throw new IllegalArgumentException("Unknown " + Error.class.getName() + " enum code:" + code);
        }
    }

    public static class PollItem {
        private final zmq.PollItem base;
        private final Socket socket;

        public PollItem(Socket socket, int ops) {
            this.socket = socket;
            this.base = new zmq.PollItem(socket.base, ops);
        }

        public PollItem(SelectableChannel channel, int ops) {
            this.base = new zmq.PollItem(channel, ops);
            this.socket = null;
        }

        protected final zmq.PollItem base() {
            return this.base;
        }

        public final SelectableChannel getRawSocket() {
            return this.base.getRawSocket();
        }

        public final Socket getSocket() {
            return this.socket;
        }

        public final boolean isReadable() {
            return this.base.isReadable();
        }

        public final boolean isWritable() {
            return this.base.isWritable();
        }

        public final boolean isError() {
            return this.base.isError();
        }

        public final int readyOps() {
            return this.base.readyOps();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PollItem)) {
                return false;
            }
            PollItem target = (PollItem)obj;
            if (this.socket != null && this.socket == target.socket) {
                return true;
            }
            return this.getRawSocket() != null && this.getRawSocket() == target.getRawSocket();
        }
    }

    public static class Poller {
        public static final int POLLIN = 1;
        public static final int POLLOUT = 2;
        public static final int POLLERR = 4;
        private static final int SIZE_DEFAULT = 32;
        private static final int SIZE_INCREMENT = 16;
        private PollItem[] items;
        private long timeout;
        private int next;

        public Poller(int size) {
            this(null, size);
        }

        protected Poller(Context context, int size) {
            this.items = new PollItem[size];
            this.timeout = -1L;
            this.next = 0;
        }

        protected Poller(Context context) {
            this(context, 32);
        }

        public int register(Socket socket) {
            return this.register(socket, 7);
        }

        public int register(Socket socket, int events) {
            return this.insert(new PollItem(socket, events));
        }

        public int register(SelectableChannel channel, int events) {
            return this.insert(new PollItem(channel, events));
        }

        public int register(PollItem item) {
            return this.insert(item);
        }

        private int insert(PollItem item) {
            int pos;
            if ((pos = this.next++) == this.items.length) {
                PollItem[] nitems = new PollItem[this.items.length + 16];
                System.arraycopy(this.items, 0, nitems, 0, this.items.length);
                this.items = nitems;
            }
            this.items[pos] = item;
            return pos;
        }

        public void unregister(Socket socket) {
            for (int pos = 0; pos < this.items.length; ++pos) {
                PollItem item = this.items[pos];
                if (item.getSocket() != socket) continue;
                this.remove(pos);
                break;
            }
        }

        public void unregister(SelectableChannel channel) {
            for (int pos = 0; pos < this.items.length; ++pos) {
                PollItem item = this.items[pos];
                if (item.getRawSocket() != channel) continue;
                this.remove(pos);
                break;
            }
        }

        private void remove(int pos) {
            --this.next;
            if (pos != this.next) {
                this.items[pos] = this.items[this.next];
            }
            this.items[this.next] = null;
        }

        public PollItem getItem(int index) {
            if (index < 0 || index >= this.next) {
                return null;
            }
            return this.items[index];
        }

        public Socket getSocket(int index) {
            if (index < 0 || index >= this.next) {
                return null;
            }
            return this.items[index].getSocket();
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            if (timeout < -1L) {
                return;
            }
            this.timeout = timeout;
        }

        public int getSize() {
            return this.items.length;
        }

        public int getNext() {
            return this.next;
        }

        public int poll() {
            long tout = -1L;
            if (this.timeout > -1L) {
                tout = this.timeout;
            }
            return this.poll(tout);
        }

        public int poll(long tout) {
            zmq.PollItem[] pollItems = new zmq.PollItem[this.next];
            for (int i = 0; i < this.next; ++i) {
                pollItems[i] = this.items[i].base();
            }
            return zmq.ZMQ.zmq_poll(pollItems, this.next, tout);
        }

        public boolean pollin(int index) {
            if (index < 0 || index >= this.next) {
                return false;
            }
            return this.items[index].isReadable();
        }

        public boolean pollout(int index) {
            if (index < 0 || index >= this.next) {
                return false;
            }
            return this.items[index].isWritable();
        }

        public boolean pollerr(int index) {
            if (index < 0 || index >= this.next) {
                return false;
            }
            return this.items[index].isError();
        }
    }

    public static class Socket {
        private static final int DYNFROM = 49152;
        private static final int DYNTO = 65535;
        private final Ctx ctx;
        private final SocketBase base;

        protected Socket(Context context, int type) {
            this.ctx = context.ctx;
            this.base = this.ctx.create_socket(type);
        }

        protected Socket(SocketBase base_) {
            this.ctx = null;
            this.base = base_;
        }

        public SocketBase base() {
            return this.base;
        }

        public final void close() {
            this.base.close();
        }

        public final int getType() {
            return this.base.getsockopt(16);
        }

        public final long getLinger() {
            return this.base.getsockopt(17);
        }

        private void setsockopt(int option, Object value) {
            try {
                this.base.setsockopt(option, value);
            }
            catch (ZError.CtxTerminatedException ctxTerminatedException) {
                // empty catch block
            }
        }

        public final void setLinger(long value) {
            this.base.setsockopt(17, (int)value);
        }

        public final long getReconnectIVL() {
            return this.base.getsockopt(18);
        }

        public final void setReconnectIVL(long value) {
            this.base.setsockopt(18, (int)value);
        }

        public final long getBacklog() {
            return this.base.getsockopt(19);
        }

        public final void setBacklog(long value) {
            this.setsockopt(19, (int)value);
        }

        public final long getReconnectIVLMax() {
            return this.base.getsockopt(21);
        }

        public final void setReconnectIVLMax(long value) {
            this.setsockopt(21, (int)value);
        }

        public final long getMaxMsgSize() {
            return (Long)this.base.getsockoptx(22);
        }

        public final void setMaxMsgSize(long value) {
            this.setsockopt(22, value);
        }

        public final long getSndHWM() {
            return this.base.getsockopt(23);
        }

        public final void setSndHWM(long value) {
            this.setsockopt(23, (int)value);
        }

        public final long getRcvHWM() {
            return this.base.getsockopt(24);
        }

        public final void setRcvHWM(long value) {
            this.setsockopt(24, (int)value);
        }

        @Deprecated
        public final long getHWM() {
            return -1L;
        }

        public final void setHWM(long hwm) {
            this.setSndHWM(hwm);
            this.setRcvHWM(hwm);
        }

        @Deprecated
        public final long getSwap() {
            return -1L;
        }

        @Deprecated
        public final void setSwap(long value) {
            throw new UnsupportedOperationException();
        }

        public final long getAffinity() {
            return (Long)this.base.getsockoptx(4);
        }

        public final void setAffinity(long value) {
            this.setsockopt(4, value);
        }

        public final byte[] getIdentity() {
            return (byte[])this.base.getsockoptx(5);
        }

        public final void setIdentity(byte[] identity) {
            this.setsockopt(5, identity);
        }

        public final long getRate() {
            return this.base.getsockopt(8);
        }

        public final void setRate(long value) {
            throw new UnsupportedOperationException();
        }

        public final long getRecoveryInterval() {
            return this.base.getsockopt(9);
        }

        public final void setRecoveryInterval(long value) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public final boolean hasMulticastLoop() {
            return false;
        }

        @Deprecated
        public final void setMulticastLoop(boolean mcast_loop) {
            throw new UnsupportedOperationException();
        }

        public final long getMulticastHops() {
            return this.base.getsockopt(25);
        }

        public final void setMulticastHops(long value) {
            throw new UnsupportedOperationException();
        }

        public final int getReceiveTimeOut() {
            return this.base.getsockopt(27);
        }

        public final void setReceiveTimeOut(int value) {
            this.setsockopt(27, value);
        }

        public final int getSendTimeOut() {
            return this.base.getsockopt(28);
        }

        public final void setSendTimeOut(int value) {
            this.setsockopt(28, value);
        }

        public final long getSendBufferSize() {
            return this.base.getsockopt(11);
        }

        public final void setSendBufferSize(long value) {
            this.setsockopt(11, (int)value);
        }

        public final long getReceiveBufferSize() {
            return this.base.getsockopt(12);
        }

        public final void setReceiveBufferSize(long value) {
            this.setsockopt(12, (int)value);
        }

        public final boolean hasReceiveMore() {
            return this.base.getsockopt(13) == 1;
        }

        public final SelectableChannel getFD() {
            return (SelectableChannel)this.base.getsockoptx(14);
        }

        public final int getEvents() {
            return this.base.getsockopt(15);
        }

        public final void subscribe(byte[] topic) {
            this.setsockopt(6, topic);
        }

        public final void unsubscribe(byte[] topic) {
            this.setsockopt(7, topic);
        }

        public final void setEncoder(Class<? extends EncoderBase> cls) {
            this.base.setsockopt(1001, cls);
        }

        public final void setDecoder(Class<? extends DecoderBase> cls) {
            this.base.setsockopt(1002, cls);
        }

        public final void setRouterMandatory(boolean mandatory) {
            this.setsockopt(33, mandatory ? 1 : 0);
        }

        public final void setXpubVerbose(boolean verbose) {
            this.setsockopt(40, verbose ? 1 : 0);
        }

        public final boolean getIPv4Only() {
            return this.base.getsockopt(31) == 1;
        }

        public void setIPv4Only(boolean v4only) {
            this.setsockopt(31, v4only ? 1 : 0);
        }

        public int getTCPKeepAlive() {
            return this.base.getsockopt(34);
        }

        public void setTCPKeepAlive(int optVal) {
            this.setsockopt(34, optVal);
        }

        public final int bind(String addr) {
            return this.bind(addr, 49152, 65535);
        }

        private final int bind(String addr, int min, int max) {
            if (addr.endsWith(":*")) {
                String prefix = addr.substring(0, addr.lastIndexOf(58) + 1);
                for (int port = min; port <= max; ++port) {
                    addr = prefix + port;
                    if (!this.base.bind(addr)) continue;
                    return port;
                }
            } else if (this.base.bind(addr)) {
                int port = 0;
                try {
                    port = Integer.parseInt(addr.substring(addr.lastIndexOf(58) + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                return port;
            }
            return -1;
        }

        public int bindToRandomPort(String addr) {
            return this.bind(addr + ":*", 49152, 65535);
        }

        public int bindToRandomPort(String addr, int min, int max) {
            return this.bind(addr + ":*", min, max);
        }

        public final void connect(String addr) {
            this.base.connect(addr);
        }

        public final boolean disconnect(String addr) {
            boolean ret = this.base.term_endpoint(addr);
            return ret;
        }

        public final boolean send(String data) {
            return this.send(data.getBytes(), 0);
        }

        public final boolean sendMore(String data) {
            return this.send(data.getBytes(), 2);
        }

        public final boolean send(String data, int flags) {
            return this.send(data.getBytes(), flags);
        }

        public final boolean send(byte[] data) {
            return this.send(data, 0);
        }

        public final boolean sendMore(byte[] data) {
            return this.send(data, 2);
        }

        public final boolean send(byte[] data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public final boolean sendByteBuffer(ByteBuffer data, int flags) {
            Msg msg = new Msg(data);
            if (this.base.send(msg, flags)) {
                return true;
            }
            this.mayRaise();
            return false;
        }

        public final byte[] recv() {
            return this.recv(0);
        }

        public final byte[] recv(int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                return msg.data();
            }
            this.mayRaise();
            return null;
        }

        public final int recv(byte[] buffer, int offset, int len, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                int size = Math.min(msg.size(), len);
                System.arraycopy(msg.data(), 0, buffer, offset, size);
                return size;
            }
            return -1;
        }

        public final int recvByteBuffer(ByteBuffer buffer, int flags) {
            Msg msg = this.base.recv(flags);
            if (msg != null) {
                buffer.put(msg.data());
                return msg.size();
            }
            this.mayRaise();
            return -1;
        }

        public final String recvStr() {
            return this.recvStr(0);
        }

        public final String recvStr(int flags) {
            byte[] msg = this.recv(flags);
            if (msg != null) {
                return new String(msg);
            }
            return null;
        }

        public boolean monitor(String addr, int events) {
            return this.base.monitor(addr, events);
        }

        private void mayRaise() {
            int errno = this.base.errno();
            if (errno != 0 && errno != 35) {
                throw new ZMQException(errno);
            }
        }
    }

    public static class Context {
        private final Ctx ctx;

        protected Context(int ioThreads) {
            this.ctx = zmq.ZMQ.zmq_init(ioThreads);
        }

        public void term() {
            this.ctx.terminate();
        }

        public Socket socket(int type) {
            return new Socket(this, type);
        }

        public Poller poller() {
            return new Poller(this);
        }

        public Poller poller(int size) {
            return new Poller(this, size);
        }
    }
}

