/*
 * Decompiled with CFR 0.152.
 */
package org.jeromq.codec;

import java.nio.ByteBuffer;
import zmq.DecoderBase;
import zmq.EncoderBase;
import zmq.IMsgSink;
import zmq.IMsgSource;
import zmq.Msg;

public class Proxy {

    public static abstract class ProxyEncoder
    extends EncoderBase {
        public static final boolean RAW_ENCODER = true;
        private static final int write_header = 0;
        private static final int write_body = 1;
        private ByteBuffer header;
        private Msg msg;
        private boolean message_ready;
        private boolean identity_received;
        private IMsgSource msg_source;

        public ProxyEncoder(int bufsize_) {
            super(bufsize_);
            this.next_step(null, 0, true);
            this.message_ready = false;
            this.identity_received = false;
            this.header = ByteBuffer.allocate(this.headerSize());
        }

        protected abstract byte[] getHeader(byte[] var1);

        protected abstract int headerSize();

        @Override
        public void set_msg_source(IMsgSource msg_source_) {
            this.msg_source = msg_source_;
        }

        @Override
        protected boolean next() {
            switch (this.state()) {
                case 0: {
                    return this.write_header();
                }
                case 1: {
                    return this.write_body();
                }
            }
            return false;
        }

        private boolean write_body() {
            this.next_step(this.msg, 0, !this.msg.has_more());
            return true;
        }

        private boolean write_header() {
            if (this.msg_source == null) {
                return false;
            }
            this.msg = this.msg_source.pull_msg();
            if (this.msg == null) {
                return false;
            }
            if (!this.identity_received) {
                this.identity_received = true;
                this.msg = this.msg_source.pull_msg();
                if (this.msg == null) {
                    return false;
                }
            }
            if (!this.message_ready) {
                this.message_ready = true;
                this.msg = this.msg_source.pull_msg();
                if (this.msg == null) {
                    return false;
                }
            }
            this.message_ready = false;
            byte[] hbuf = this.getHeader(this.msg.data());
            if (hbuf != null) {
                this.header.clear();
                this.header.put(hbuf);
                this.header.flip();
                this.next_step(this.header.array(), this.header.remaining(), 1, false);
            } else {
                this.next_step(hbuf, 0, 1, false);
            }
            return true;
        }
    }

    public static abstract class ProxyDecoder
    extends DecoderBase {
        private static final int read_header = 0;
        private static final int read_body = 1;
        private byte[] header = new byte[this.headerSize()];
        private Msg msg;
        private int size = -1;
        private boolean identity_sent = false;
        private Msg bottom;
        private IMsgSink msg_sink;

        public ProxyDecoder(int bufsize_, long maxmsgsize_) {
            super(bufsize_);
            this.next_step(this.header, this.header.length, 0);
            this.bottom = new Msg();
            this.bottom.set_flags(1);
        }

        @Override
        public void set_msg_sink(IMsgSink msg_sink_) {
            this.msg_sink = msg_sink_;
        }

        protected abstract int parseHeader(byte[] var1);

        protected abstract boolean parseBody(byte[] var1);

        protected abstract int headerSize();

        protected byte[] getIdentity() {
            return null;
        }

        protected boolean preserveHeader() {
            return false;
        }

        @Override
        protected boolean next() {
            switch (this.state()) {
                case 0: {
                    return this.readHeader();
                }
                case 1: {
                    return this.readBody();
                }
            }
            return false;
        }

        private boolean readHeader() {
            this.size = this.parseHeader(this.header);
            if (this.size < 0) {
                this.decoding_error();
                return false;
            }
            this.msg = new Msg(this.size);
            this.next_step(this.msg, 1);
            return true;
        }

        private boolean readBody() {
            if (this.msg_sink == null) {
                return false;
            }
            if (!this.parseBody(this.msg.data())) {
                this.decoding_error();
                return false;
            }
            if (!this.identity_sent) {
                Msg identity = new Msg(this.getIdentity());
                this.msg_sink.push_msg(identity);
                this.identity_sent = true;
            }
            this.msg_sink.push_msg(this.bottom);
            if (this.preserveHeader()) {
                Msg hmsg = new Msg(this.header, true);
                hmsg.set_flags(1);
                this.msg_sink.push_msg(hmsg);
            }
            this.msg_sink.push_msg(this.msg);
            this.next_step(this.header, this.headerSize(), 0);
            return true;
        }

        @Override
        public boolean stalled() {
            return this.state() == 1;
        }
    }
}

