/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.util;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.orb.miop.MIOPProfile;
import org.omg.CORBA.Object;
import org.omg.ETF.Factories;
import org.omg.ETF.Profile;
import org.omg.GIOP.Version;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.PortableGroup.TagGroupTaggedComponent;

public class CorbaLoc {
    private final ORB orb;
    private String keyString;
    private byte[] key;
    private String bodyString;
    private boolean is_rir;
    public Profile[] profileList;

    public CorbaLoc(ORB orb, String addr) {
        this.orb = orb;
        this.is_rir = false;
        this.parse(addr);
    }

    public boolean rir() {
        return this.is_rir;
    }

    public String toString() {
        return "corbaloc:" + this.body();
    }

    private String body() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.bodyString);
        if (this.keyString != null) {
            buffer.append('/');
            buffer.append(this.keyString);
        }
        return buffer.toString();
    }

    public String getKeyString() {
        return this.keyString;
    }

    public byte[] getKey() {
        return this.key;
    }

    private void defaultKeyString(String defaultKey) {
        if (this.keyString != null) {
            throw new IllegalStateException("KeyString not empty, cannot default to " + defaultKey);
        }
        this.keyString = defaultKey;
    }

    public String toCorbaName(String str_name) {
        if (this.getKeyString() == null) {
            this.defaultKeyString("NameService");
        }
        if (str_name != null && str_name.length() > 0) {
            try {
                return "corbaname:" + this.body() + "#" + str_name;
            }
            catch (Exception e) {
                return null;
            }
        }
        return "corbaname:" + this.body();
    }

    private void parse(String addr) {
        String sb;
        boolean isMIOP;
        if (addr == null || !addr.startsWith("corbaloc:")) {
            throw new IllegalArgumentException("URL must start with 'corbaloc:'");
        }
        boolean bl = isMIOP = addr.indexOf("miop") != -1;
        if (isMIOP && addr.indexOf(",iiop") != -1) {
            throw new IllegalArgumentException("MIOP Profile does not support Gateway Profiles.");
        }
        if (!isMIOP && addr.indexOf(47) == -1) {
            sb = addr.substring(addr.indexOf(58) + 1);
            if (addr.startsWith("corbaloc:rir:")) {
                this.is_rir = true;
                this.keyString = "NameService";
            } else {
                this.keyString = null;
            }
            this.key = new byte[0];
        } else {
            sb = addr.substring(addr.indexOf(58) + 1, isMIOP ? addr.length() : addr.indexOf(47));
            this.keyString = addr.substring(addr.indexOf(47) + 1);
            this.key = CorbaLoc.parseKey(this.keyString);
        }
        if (!isMIOP && sb.indexOf(44) > 0) {
            StringTokenizer tokenizer = new StringTokenizer(sb, ",");
            this.profileList = new Profile[tokenizer.countTokens()];
            int pIndex = 0;
            for (int i = 0; i < this.profileList.length; ++i) {
                Profile p = this.parseAddress(tokenizer.nextToken());
                if (p == null) continue;
                this.profileList[pIndex] = p;
                ++pIndex;
            }
            while (pIndex < this.profileList.length) {
                this.profileList[pIndex] = null;
                ++pIndex;
            }
        } else {
            this.profileList = new Profile[]{this.parseAddress(sb)};
        }
        this.bodyString = sb;
    }

    private Profile parseAddress(String addr) {
        int colon = addr.indexOf(58);
        if (colon == -1) {
            throw new IllegalArgumentException("Illegal object address format: " + addr);
        }
        if ("rir:".equals(addr)) {
            this.is_rir = true;
            return null;
        }
        Profile result = null;
        if (this.orb == null && (colon == 0 || addr.startsWith("iiop:") || addr.startsWith("ssliop:"))) {
            result = new IIOPProfile(addr);
        } else if (this.orb != null) {
            List<Factories> factories = this.orb.getTransportManager().getFactoriesList();
            Iterator<Factories> i = factories.iterator();
            while (result == null && i.hasNext()) {
                Factories f = i.next();
                result = f.decode_corbaloc(addr);
            }
        }
        if (result == null) {
            throw new IllegalArgumentException("Unknown protocol in object address format: " + addr);
        }
        return result;
    }

    private static boolean legalChar(char c) {
        if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            return true;
        }
        return c == ';' || c == '/' || c == ':' || c == '?' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ',' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == '\'' || c == '-' || c == '(' || c == ')';
    }

    private static byte hexValue(char c) {
        return (byte)(c >= 'a' ? 10 + c - 97 : (c >= 'A' ? 10 + c - 65 : c - 48));
    }

    private static char hexDigit(byte b) {
        if ((b & 0xF0) != 0) {
            throw new IllegalArgumentException("Hex digit out of range " + b);
        }
        return (char)(b < 10 ? 48 + (char)b : 65 + (char)b - 10);
    }

    private static boolean isHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static byte[] parseKey(String s) {
        char[] tmp = s.toCharArray();
        int count = tmp.length;
        for (int i = 0; i < tmp.length; ++i) {
            if (CorbaLoc.legalChar(tmp[i])) continue;
            if (tmp[i] == '%') {
                if (CorbaLoc.isHex(tmp[i + 1]) && CorbaLoc.isHex(tmp[i + 2])) {
                    count -= 2;
                    i += 2;
                    continue;
                }
                throw new IllegalArgumentException("Illegal escape in URL character");
            }
            throw new IllegalArgumentException("URL character out of range: " + tmp[i]);
        }
        byte[] result = new byte[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            if (CorbaLoc.legalChar(tmp[idx])) {
                result[i] = (byte)tmp[idx++];
                continue;
            }
            result[i] = (byte)(CorbaLoc.hexValue(tmp[idx + 1]) << 4 | CorbaLoc.hexValue(tmp[idx + 2]));
            idx += 3;
        }
        return result;
    }

    public static String parseKey(byte[] key) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            if (!CorbaLoc.legalChar((char)key[i])) {
                buffer.append('%');
                buffer.append(CorbaLoc.hexDigit((byte)((key[i] & 0xFF) >> 4)));
                buffer.append(CorbaLoc.hexDigit((byte)(key[i] & 0xF)));
                continue;
            }
            buffer.append((char)key[i]);
        }
        return buffer.toString();
    }

    public static String generateCorbaloc(org.omg.CORBA.ORB orb, Object ref) {
        ParsedIOR pior = new ParsedIOR((ORB)orb, orb.object_to_string(ref));
        Profile profile = pior.getEffectiveProfile();
        if (profile instanceof IIOPProfile) {
            return CorbaLoc.createCorbalocForIIOPProfile((IIOPProfile)profile);
        }
        if (profile instanceof MIOPProfile) {
            return CorbaLoc.createCorbalocForMIOPProfile((MIOPProfile)profile);
        }
        throw new IllegalArgumentException("Profile type not suported: tag number=" + profile.tag());
    }

    private static String createCorbalocForMIOPProfile(MIOPProfile profile) {
        StringBuffer sb = new StringBuffer("miop:");
        sb.append(CorbaLoc.createString(profile.version()));
        sb.append("@");
        sb.append(CorbaLoc.createString(profile.getTagGroup()));
        sb.append("/");
        sb.append(CorbaLoc.createString(profile.getUIPMCProfile()));
        sb.append(";");
        sb.append(CorbaLoc.createCorbalocForIIOPProfile(profile.getGroupIIOPProfile()));
        return sb.toString();
    }

    private static String createString(TagGroupTaggedComponent groupInfo) {
        StringBuffer sb = new StringBuffer();
        sb.append(CorbaLoc.createString(groupInfo.group_version));
        sb.append("-");
        sb.append(groupInfo.group_domain_id);
        sb.append("-");
        sb.append(groupInfo.object_group_id);
        if (groupInfo.object_group_ref_version != 0) {
            sb.append("-");
            sb.append(groupInfo.object_group_ref_version);
        }
        return sb.toString();
    }

    private static String createString(UIPMC_ProfileBody uipmc) {
        StringBuffer sb = new StringBuffer();
        sb.append(uipmc.the_address);
        sb.append(":");
        sb.append(uipmc.the_port);
        return sb.toString();
    }

    private static String createString(Version version) {
        StringBuffer sb = new StringBuffer();
        sb.append(version.major);
        sb.append(".");
        sb.append(version.minor);
        return sb.toString();
    }

    public static String generateCorbalocForMultiIIOPProfiles(org.omg.CORBA.ORB orb, Object ref) {
        return CorbaLoc.generateCorbalocForMultiIIOPProfiles(orb, orb.object_to_string(ref));
    }

    public static String generateCorbalocForMultiIIOPProfiles(org.omg.CORBA.ORB orb, String ref) {
        ParsedIOR pior = new ParsedIOR((ORB)orb, ref);
        String result = null;
        String object_key = null;
        for (Profile profile : pior.getProfiles()) {
            if (!(profile instanceof IIOPProfile)) continue;
            String s = CorbaLoc.createCorbalocForIIOPProfile((IIOPProfile)profile, true);
            if (result != null) {
                result = result + "," + s;
                continue;
            }
            result = "corbaloc:" + s;
            object_key = CorbaLoc.parseKey(profile.get_object_key());
        }
        if (result != null) {
            result = result + "/" + object_key;
        }
        return result;
    }

    public static String createCorbalocForIIOPProfile(IIOPProfile profile) {
        return CorbaLoc.createCorbalocForIIOPProfile(profile, false).concat('/' + CorbaLoc.parseKey(profile.get_object_key()));
    }

    private static String createCorbalocForIIOPProfile(IIOPProfile profile, boolean addAlternates) {
        StringBuffer sb = new StringBuffer("iiop:");
        sb.append(CorbaLoc.createString(profile.version()));
        sb.append("@");
        sb.append(((IIOPAddress)profile.getAddress()).getOriginalHost());
        sb.append(":");
        sb.append(((IIOPAddress)profile.getAddress()).getPort());
        Iterator<IIOPAddress> iter = profile.getAlternateAddresses().iterator();
        while (addAlternates && iter.hasNext()) {
            IIOPAddress address = iter.next();
            sb.append(",iiop:");
            sb.append(CorbaLoc.createString(profile.version()));
            sb.append("@");
            sb.append(CorbaLoc.wrapIPv6(address.getOriginalHost()));
            sb.append(":");
            sb.append(address.getPort());
        }
        return sb.toString();
    }

    private static String wrapIPv6(String addr) {
        String result = addr;
        try {
            InetAddress address = InetAddress.getByName(addr);
            if (address instanceof Inet6Address) {
                result = '[' + result + ']';
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return result;
    }

    public static void main(String[] args) {
        String[] noarg = new String[]{};
        ORB orb = (ORB)ORB.init(noarg, null);
        for (int i = 0; i < args.length; ++i) {
            System.out.println(new CorbaLoc(orb, args[i]).toString());
        }
    }
}

