/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbServer;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;

public class DbServerStructure {
    private String serverName;
    private String tgHost = null;
    private String tgPort = null;
    private ArrayList<TangoClass> classes = new ArrayList();

    public DbServerStructure(String serverName) throws DevFailed {
        this.serverName = serverName;
        this.buildStructure();
    }

    public DbServerStructure(String serverName, String tangoHost) throws DevFailed {
        this.serverName = serverName;
        int pos = tangoHost.indexOf(58);
        if (pos < 0 || pos == tangoHost.length()) {
            Except.throw_exception("BAD_SYNTAX", "TANGO_HOST name is not valid", "DbServerStructure.DbServerStructure()");
        }
        this.tgHost = tangoHost.substring(0, pos);
        this.tgPort = tangoHost.substring(pos + 1);
        this.buildStructure();
    }

    public DbServerStructure(String serverName, String host, String port) throws DevFailed {
        this.serverName = serverName;
        this.tgHost = host;
        this.tgPort = port;
        this.buildStructure();
    }

    private void buildStructure() throws DevFailed {
        DbServer server = this.tgHost == null || this.tgPort == null ? new DbServer(this.serverName) : new DbServer(this.serverName, this.tgHost, this.tgPort);
        String adminName = this.tgHost == null ? "" : "tango://" + this.tgHost + ":" + this.tgPort + "/";
        adminName = adminName + "dserver/" + this.serverName.toLowerCase();
        new DeviceProxy(adminName);
        String[] classNames = server.get_class_list();
        this.classes.add(new TangoClass("DServer"));
        for (String className : classNames) {
            this.classes.add(new TangoClass(className));
        }
    }

    public String getName() {
        return this.serverName;
    }

    public ArrayList<TangoClass> getClasses() {
        return this.classes;
    }

    public void putInDatabase(String tangoHost) throws DevFailed {
        Database database = ApiUtil.get_db_obj(tangoHost);
        this.createTheServer(database);
        this.putProperties(database);
    }

    public boolean alreadyExists(String tangoHost) throws DevFailed {
        String header = "tango://" + tangoHost + "/";
        try {
            new DeviceProxy(header + "dserver/" + this.serverName.toLowerCase());
            return true;
        }
        catch (DevFailed e) {
            for (TangoClass clazz : this.classes) {
                for (TangoDevice device : clazz) {
                    try {
                        new DeviceProxy(header + device.name);
                        return true;
                    }
                    catch (DevFailed e2) {
                        if (e2.errors[0].desc.contains("not defined in the database")) continue;
                        Except.re_throw_exception(e2, "FailedToCheck", "Failed to check " + device.name + "in " + tangoHost, "DbServerStructure.alreadyExists()");
                    }
                }
            }
            return false;
        }
    }

    private void createTheServer(Database database) throws DevFailed {
        ArrayList<DbDevInfo> deviceInfoList = new ArrayList<DbDevInfo>();
        for (TangoClass clazz : this.classes) {
            for (TangoDevice device : clazz) {
                deviceInfoList.add(new DbDevInfo(device.name, clazz.name, this.serverName));
            }
        }
        DbDevInfo[] deviceInfoArray = new DbDevInfo[deviceInfoList.size()];
        for (int i = 0; i < deviceInfoList.size(); ++i) {
            deviceInfoArray[i] = (DbDevInfo)deviceInfoList.get(i);
        }
        database.add_server(this.serverName, deviceInfoArray);
    }

    private void putProperties(Database database) throws DevFailed {
        for (TangoClass clazz : this.classes) {
            clazz.putProperties(database);
            clazz.putAttributeProperties(database);
            for (TangoDevice device : clazz) {
                device.putProperties(database);
                device.putAttributeProperties(database);
            }
        }
    }

    public void remove() throws DevFailed {
        Database database = this.tgHost == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(this.tgHost, this.tgPort);
        this.remove(database.get_tango_host());
    }

    public void remove(String tangoHost) throws DevFailed {
        Database database = ApiUtil.get_db_obj(tangoHost);
        for (int i = this.classes.size() - 1; i >= 0; --i) {
            for (TangoDevice device : this.classes.get(i)) {
                database.delete_device(device.name);
            }
        }
        for (TangoClass clazz : this.classes) {
            String[] deviceNames;
            if (clazz.name.toLowerCase().equals("dserver") || (deviceNames = database.get_device_name("*", clazz.name)).length != 0) continue;
            clazz.removeProperties(database);
        }
    }

    public String toString() {
        return this.serverName;
    }

    public class TangoProperty {
        String name;
        String[] values;

        TangoProperty(String name, String[] values) {
            this.name = name;
            this.values = values;
        }

        public String toString() {
            String str = this.name;
            if (this.values.length > 0) {
                str = str + ": " + this.values[0];
                if (this.values.length > 1) {
                    str = str + "...";
                }
            }
            return str;
        }
    }

    public class TangoAttribute
    extends ArrayList<TangoProperty> {
        String name;

        TangoAttribute(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public class TangoDevice {
        String name;
        DeviceProxy deviceProxy;
        ArrayList<TangoProperty> properties = new ArrayList();
        ArrayList<TangoAttribute> attributes = new ArrayList();

        TangoDevice(String name) throws DevFailed {
            String[] attributeNames;
            this.name = name;
            String fullName = DbServerStructure.this.tgHost == null ? name : "tango://" + DbServerStructure.this.tgHost + ":" + DbServerStructure.this.tgPort + "/" + name;
            this.deviceProxy = new DeviceProxy(fullName);
            String[] propertyNames = this.deviceProxy.get_property_list("*");
            if (propertyNames.length > 0) {
                DbDatum[] propertyValues = this.deviceProxy.get_property(propertyNames);
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (propertyValues[i].is_empty()) continue;
                    this.properties.add(new TangoProperty(propertyNames[i], propertyValues[i].extractStringArray()));
                }
            }
            Database database = DbServerStructure.this.tgHost == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(DbServerStructure.this.tgHost, DbServerStructure.this.tgPort);
            for (String attributeName : attributeNames = database.get_device_attribute_list(name)) {
                DbAttribute dbAttribute = database.get_device_attribute_property(name, attributeName);
                for (DbDatum datum : dbAttribute) {
                    if (datum.is_empty()) continue;
                    TangoAttribute attribute = new TangoAttribute(attributeName);
                    attribute.add(new TangoProperty(datum.name, datum.extractStringArray()));
                    this.attributes.add(attribute);
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<TangoProperty> getProperties() {
            return this.properties;
        }

        public ArrayList<TangoAttribute> getAttributes() {
            return this.attributes;
        }

        private void putProperties(Database database) throws DevFailed {
            if (this.properties.size() > 0) {
                DbDatum[] data = new DbDatum[this.properties.size()];
                int i = 0;
                for (TangoProperty property : this.properties) {
                    data[i++] = new DbDatum(property.name, property.values);
                }
                database.put_device_property(this.name, data);
            }
        }

        private void putAttributeProperties(Database database) throws DevFailed {
            ArrayList<DbAttribute> dbAttributeList = new ArrayList<DbAttribute>();
            if (this.attributes.size() > 0) {
                for (TangoAttribute attribute : this.attributes) {
                    if (attribute.size() <= 0) continue;
                    DbAttribute dbAttribute = new DbAttribute(attribute.name);
                    for (TangoProperty property : attribute) {
                        dbAttribute.add(new DbDatum(property.name, property.values));
                    }
                    dbAttributeList.add(dbAttribute);
                }
                DbAttribute[] dbAttributes = new DbAttribute[dbAttributeList.size()];
                for (int i = 0; i < dbAttributeList.size(); ++i) {
                    dbAttributes[i] = (DbAttribute)dbAttributeList.get(i);
                }
                database.put_device_attribute_property(this.name, dbAttributes);
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public class TangoClass
    extends ArrayList<TangoDevice> {
        String name;
        ArrayList<TangoProperty> properties = new ArrayList();
        ArrayList<TangoAttribute> attributes = new ArrayList();

        private TangoClass(String name) throws DevFailed {
            String[] deviceNames;
            String[] attributeNames;
            this.name = name;
            Database database = DbServerStructure.this.tgHost == null ? ApiUtil.get_db_obj() : ApiUtil.get_db_obj(DbServerStructure.this.tgHost, DbServerStructure.this.tgPort);
            String[] propertyNames = database.get_class_property_list(name, "*");
            if (propertyNames.length > 0) {
                DbDatum[] propertyValues = database.get_class_property(name, propertyNames);
                for (int i = 0; i < propertyNames.length; ++i) {
                    if (propertyValues[i].is_empty()) continue;
                    this.properties.add(new TangoProperty(propertyNames[i], propertyValues[i].extractStringArray()));
                }
            }
            for (String attributeName : attributeNames = database.get_class_attribute_list(name, "*")) {
                DbAttribute dbAttribute = database.get_class_attribute_property(name, attributeName);
                for (DbDatum object : dbAttribute) {
                    DbDatum datum = object;
                    if (datum.is_empty()) continue;
                    TangoAttribute attribute = new TangoAttribute(attributeName);
                    attribute.add(new TangoProperty(datum.name, datum.extractStringArray()));
                    this.attributes.add(attribute);
                }
            }
            for (String deviceName : deviceNames = DbServerStructure.this.tgHost == null ? new DbServer(DbServerStructure.this.serverName).get_device_name(name) : new DbServer(DbServerStructure.this.serverName, DbServerStructure.this.tgHost, DbServerStructure.this.tgPort).get_device_name(name)) {
                this.add(new TangoDevice(deviceName));
            }
        }

        public String getName() {
            return this.name;
        }

        public ArrayList<TangoProperty> getProperties() {
            return this.properties;
        }

        public ArrayList<TangoAttribute> getAttributes() {
            return this.attributes;
        }

        private void putProperties(Database database) throws DevFailed {
            if (this.properties.size() > 0) {
                DbDatum[] data = new DbDatum[this.properties.size()];
                int i = 0;
                for (TangoProperty property : this.properties) {
                    data[i++] = new DbDatum(property.name, property.values);
                }
                database.put_class_property(this.name, data);
            }
        }

        private void putAttributeProperties(Database database) throws DevFailed {
            ArrayList<DbAttribute> dbAttributeList = new ArrayList<DbAttribute>();
            if (this.attributes.size() > 0) {
                for (TangoAttribute attribute : this.attributes) {
                    if (attribute.size() <= 0) continue;
                    DbAttribute dbAttribute = new DbAttribute(this.name);
                    for (TangoProperty property : attribute) {
                        dbAttribute.add(new DbDatum(property.name, property.values));
                    }
                    dbAttributeList.add(dbAttribute);
                }
                DbAttribute[] dbAttributes = new DbAttribute[dbAttributeList.size()];
                for (int i = 0; i < dbAttributeList.size(); ++i) {
                    dbAttributes[i] = (DbAttribute)dbAttributeList.get(i);
                }
                database.put_class_attribute_property(this.name, dbAttributes);
            }
        }

        private void removeProperties(Database database) throws DevFailed {
            if (this.properties.size() > 0) {
                String[] propertyNames = new String[this.properties.size()];
                for (int i = 0; i < this.properties.size(); ++i) {
                    propertyNames[i] = this.properties.get((int)i).name;
                }
                database.delete_class_property(this.name, propertyNames);
            }
            if (this.attributes.size() > 0) {
                for (TangoAttribute attribute : this.attributes) {
                    if (attribute.size() <= 0) continue;
                    String[] propertyNames = new String[attribute.size()];
                    for (int i = 0; i < attribute.size(); ++i) {
                        propertyNames[i] = ((TangoProperty)attribute.get((int)i)).name;
                    }
                    database.delete_class_attribute_property(this.name, attribute.name, propertyNames);
                }
            }
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

