/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsyncCallObject;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbRedundancy;
import fr.esrf.TangoApi.DevLockManager;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IApiUtilDAO;
import fr.esrf.TangoApi.events.EventConsumerUtil;
import fr.esrf.TangoApi.events.ZMQutils;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jacorb.orb.Delegate;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Request;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;

public class ApiUtilDAODefaultImpl
implements IApiUtilDAO {
    private static ArrayList<Database> db_list = null;
    private static Database defaultDatabase = null;
    private static Hashtable<Integer, AsyncCallObject> async_request_table = new Hashtable();
    private static int async_request_cnt = 0;
    private static int async_cb_sub_model = 1;
    private static boolean in_server_code = false;
    private static int reconnection_delay = -1;

    @Override
    public Database get_db_obj(String tango_host) throws DevFailed {
        int i = tango_host.indexOf(":");
        if (i <= 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "ApiUtil.get_db_obj()");
        }
        return this.get_db_obj(tango_host.substring(0, i), tango_host.substring(i + 1));
    }

    @Override
    public Database get_default_db_obj() throws DevFailed {
        if (defaultDatabase == null) {
            return this.get_db_obj();
        }
        return defaultDatabase;
    }

    @Override
    public boolean default_db_obj_exists() throws DevFailed {
        return defaultDatabase != null;
    }

    @Override
    public synchronized Database get_db_obj() throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        if (db_list == null) {
            db_list = new ArrayList();
        }
        if (defaultDatabase == null) {
            defaultDatabase = new Database();
            db_list.add(defaultDatabase);
        }
        return db_list.get(0);
    }

    @Override
    public Database get_db_obj(String host, String port) throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        if (db_list == null) {
            db_list = new ArrayList();
        }
        String tango_host = host + ":" + port;
        if (defaultDatabase != null && defaultDatabase.get_tango_host().equals(tango_host)) {
            return defaultDatabase;
        }
        for (Database dbase : db_list) {
            if (!dbase.get_tango_host().equals(tango_host)) continue;
            return dbase;
        }
        Database dbase = new Database(host, port);
        db_list.add(dbase);
        return dbase;
    }

    @Override
    public Database change_db_obj(String host, String port) throws DevFailed {
        Database dbase = this.get_db_obj(host, port);
        db_list.remove(dbase);
        db_list.add(0, dbase);
        defaultDatabase = dbase;
        return dbase;
    }

    @Override
    public Database set_db_obj(String host, String port) throws DevFailed {
        return this.change_db_obj(host, port);
    }

    @Override
    public Database set_db_obj(String tango_host) throws DevFailed {
        int i = tango_host.indexOf(":");
        if (i <= 0) {
            Except.throw_connection_failed("TangoApi_TANGO_HOST_NOT_SET", "Cannot parse port number", "ApiUtil.set_db_obj()");
        }
        return this.change_db_obj(tango_host.substring(0, i), tango_host.substring(i + 1));
    }

    private static synchronized void create_orb() throws DevFailed {
        try {
            Properties props = System.getProperties();
            props.put("org.omg.CORBA.ORBClass", "org.jacorb.orb.ORB");
            props.put("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
            props.put("jacorb.retries", "0");
            props.put("jacorb.retry_interval", "100");
            props.put("jacorb.connection.client.connect_timeout", "300");
            String str = ApiUtilDAODefaultImpl.checkORBgiopMaxMsgSize();
            props.put("jacorb.maxManagedBufSize", str);
            String nbThreads = System.getProperty("max_receptor_threads");
            if (nbThreads != null) {
                props.put("jacorb.connection.client.max_receptor_threads", nbThreads);
            }
            props.put("jacorb.config.log.verbosity", "0");
            props.put("jacorb.disableClientOrbPolicies", "off");
            props.put("jacorb.codeset", "true");
            props.put("jacorb.config.dir", "fr/esrf/TangoApi/etc");
            System.setProperties(props);
            String[] argv = null;
            ApiUtil.setOrb(ORB.init(argv, null));
            DevLockManager.getInstance();
        }
        catch (SystemException ex) {
            ApiUtil.setOrb(null);
            ex.printStackTrace();
            Except.throw_connection_failed(ex.toString(), "Initializing ORB failed !", "ApiUtil.create_orb()");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String checkORBgiopMaxMsgSize() {
        String str = "20";
        String tmp = ApiUtil.getORBgiopMaxMsgSize();
        if (tmp != null && (tmp = ApiUtilDAODefaultImpl.checkBufferSize(tmp)) != null) {
            str = tmp;
        }
        return str;
    }

    private static String checkBufferSize(String str) {
        long size;
        int nb_mega;
        try {
            nb_mega = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
        long l = size = (long)nb_mega * 1024L * 1024L;
        int cnt = 0;
        while (l > 0L) {
            l >>= 1;
            ++cnt;
        }
        if (Math.pow(2.0, --cnt) < (double)size) {
            ++cnt;
        }
        System.out.println(nb_mega + " Mbytes  (2^" + cnt + ")");
        int jacorb_size = cnt - 4;
        return Integer.toString(jacorb_size);
    }

    @Override
    public ORB get_orb() throws DevFailed {
        if (ApiUtil.getOrb() == null) {
            ApiUtilDAODefaultImpl.create_orb();
        }
        return ApiUtil.getOrb();
    }

    @Override
    public void set_in_server(boolean val) {
        in_server_code = val;
    }

    @Override
    public boolean in_server() {
        return in_server_code;
    }

    @Override
    public int getReconnectionDelay() {
        if (reconnection_delay < 0) {
            try {
                DbDatum data = this.get_db_obj().get_property("CtrlSystem", "ReconnectionDelay");
                if (!data.is_empty()) {
                    reconnection_delay = data.extractLong();
                }
            }
            catch (DevFailed devFailed) {
                // empty catch block
            }
            if (reconnection_delay < 0) {
                reconnection_delay = 1000;
            }
        }
        return reconnection_delay;
    }

    public static String getUser() {
        return System.getProperty("user.name");
    }

    @Override
    public synchronized int put_async_request(AsyncCallObject aco) {
        aco.id = ++async_request_cnt;
        async_request_table.put(async_request_cnt, aco);
        return async_request_cnt;
    }

    @Override
    public Request get_async_request(int id) throws DevFailed {
        if (!async_request_table.containsKey(id)) {
            Except.throw_exception("ASYNC_API_ERROR", "request for id " + id + " does not exist", this.getClass().getCanonicalName() + ".get_async_request");
        }
        AsyncCallObject aco = async_request_table.get(id);
        return aco.request;
    }

    @Override
    public AsyncCallObject get_async_object(int id) {
        return async_request_table.get(id);
    }

    @Override
    public synchronized void remove_async_request(int id) {
        AsyncCallObject aco = async_request_table.get(id);
        if (aco != null) {
            ApiUtilDAODefaultImpl.removePendingRepliesOfRequest(aco.request);
            ((org.jacorb.orb.ORB)ApiUtil.getOrb()).removeRequest(aco.request);
            async_request_table.remove(id);
        }
    }

    private static void removePendingReplies(Delegate delegate) {
    }

    public static void removePendingRepliesOfRequest(Request request) {
        Delegate delegate = (Delegate)((ObjectImpl)request.target())._get_delegate();
        ApiUtilDAODefaultImpl.removePendingReplies(delegate);
    }

    public static void removePendingRepliesOfDevice(Connection connection) {
        Delegate delegate;
        if (connection.device_4 != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device_4))._get_delegate();
        } else if (connection.device_3 != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device_3))._get_delegate();
        } else if (connection.device_2 != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device_2))._get_delegate();
        } else if (connection.device != null) {
            delegate = (Delegate)((ObjectImpl)((Object)connection.device))._get_delegate();
        } else {
            return;
        }
        ApiUtilDAODefaultImpl.removePendingReplies(delegate);
    }

    @Override
    public void set_async_reply_model(int id, int reply_model) {
        AsyncCallObject aco = async_request_table.get(id);
        if (aco != null) {
            aco.reply_model = reply_model;
        }
    }

    @Override
    public void set_async_reply_cb(int id, CallBack cb) {
        AsyncCallObject aco = async_request_table.get(id);
        if (aco != null) {
            aco.cb = cb;
        }
    }

    @Override
    public int pending_asynch_call(DeviceProxy dev, int reply_model) {
        int cnt = 0;
        Enumeration<Integer> _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            int n = _enum.nextElement();
            AsyncCallObject aco = async_request_table.get(n);
            if (aco.dev != dev || reply_model != 0 && aco.reply_model != reply_model) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int pending_asynch_call(int reply_model) {
        int cnt = 0;
        Enumeration<Integer> _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            int n = _enum.nextElement();
            AsyncCallObject aco = async_request_table.get(n);
            if (reply_model != 0 && aco.reply_model != reply_model) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public void set_asynch_cb_sub_model(int model) {
        async_cb_sub_model = model;
    }

    @Override
    public int get_asynch_cb_sub_model() {
        return async_cb_sub_model;
    }

    @Override
    public void get_asynch_replies() {
        Enumeration<Integer> _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            int n = _enum.nextElement();
            AsyncCallObject aco = async_request_table.get(n);
            aco.manage_reply(-1);
        }
    }

    @Override
    public void get_asynch_replies(int timeout) {
        Enumeration<Integer> _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            int n = _enum.nextElement();
            AsyncCallObject aco = async_request_table.get(n);
            aco.manage_reply(timeout);
        }
    }

    @Override
    public void get_asynch_replies(DeviceProxy dev) {
        Enumeration<Integer> _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            int n = _enum.nextElement();
            AsyncCallObject aco = async_request_table.get(n);
            if (aco.dev != dev) continue;
            aco.manage_reply(-1);
        }
    }

    @Override
    public void get_asynch_replies(DeviceProxy dev, int timeout) {
        Enumeration<Integer> _enum = async_request_table.keys();
        while (_enum.hasMoreElements()) {
            int n = _enum.nextElement();
            AsyncCallObject aco = async_request_table.get(n);
            if (aco.dev != dev) continue;
            aco.manage_reply(timeout);
        }
    }

    @Override
    public String[] toStringArray(String objname, String[] argin) {
        String[] array = new String[1 + argin.length];
        array[0] = objname;
        System.arraycopy(argin, 0, array, 1, argin.length);
        return array;
    }

    @Override
    public String[] toStringArray(String objname, String argin) {
        String[] array = new String[]{objname, argin};
        return array;
    }

    @Override
    public String[] toStringArray(String argin) {
        String[] array = new String[]{argin};
        return array;
    }

    @Override
    public String[] toStringArray(String objname, DbAttribute[] attributes, int mode) {
        int nb_attr = attributes.length;
        ArrayList<String> list = new ArrayList<String>();
        list.add(objname);
        list.add(Integer.toString(nb_attr));
        for (DbAttribute attribute : attributes) {
            list.add(attribute.name);
            list.add("" + attribute.size());
            for (int j = 0; j < attribute.size(); ++j) {
                list.add(attribute.get_property_name(j));
                String[] values = attribute.get_value(j);
                if (mode != 1) {
                    list.add("" + values.length);
                }
                list.addAll(Arrays.asList(values));
            }
        }
        String[] array = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array[i] = (String)list.get(i);
        }
        return array;
    }

    @Override
    public DbAttribute[] toDbAttributeArray(String[] array, int mode) throws DevFailed {
        if (mode < 1 && mode > 2) {
            Except.throw_non_supported_exception("API_NotSupportedMode", "Mode " + mode + " to decode attribute properties is not supported", "ApiUtil.toDbAttributeArray()");
        }
        int idx = 1;
        int nb_attr = Integer.parseInt(array[idx++]);
        DbAttribute[] attr = new DbAttribute[nb_attr];
        for (int i = 0; i < nb_attr; ++i) {
            attr[i] = new DbAttribute(array[idx++]);
            int nb_prop = Integer.parseInt(array[idx++]);
            block5: for (int j = 0; j < nb_prop; ++j) {
                String p_name = array[idx++];
                switch (mode) {
                    case 1: {
                        attr[i].add(p_name, array[idx++]);
                        continue block5;
                    }
                    case 2: {
                        int p_length = Integer.parseInt(array[idx++]);
                        String[] val = new String[p_length];
                        for (int p = 0; p < p_length; ++p) {
                            val[p] = array[idx++];
                        }
                        attr[i].add(p_name, val);
                    }
                }
            }
        }
        return attr;
    }

    @Override
    public String stateName(DevState state) {
        return TangoConst.Tango_DevStateName[state.value()];
    }

    @Override
    public String stateName(short state_val) {
        return TangoConst.Tango_DevStateName[state_val];
    }

    @Override
    public String qualityName(AttrQuality att_q) {
        return TangoConst.Tango_QualityName[att_q.value()];
    }

    @Override
    public String qualityName(short att_q_val) {
        return TangoConst.Tango_QualityName[att_q_val];
    }

    @Override
    public String[] parseTangoHost(String tgh) throws DevFailed {
        String host = null;
        String strport = null;
        try {
            StringTokenizer stk = tgh.indexOf(",") > 0 ? new StringTokenizer(tgh, ",") : new StringTokenizer(tgh);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                String th = stk.nextToken();
                StringTokenizer stk2 = new StringTokenizer(th, ":");
                arrayList.add(stk2.nextToken());
                arrayList.add(stk2.nextToken());
            }
            host = (String)arrayList.get(0);
            strport = (String)arrayList.get(1);
            Integer.parseInt(strport);
            String def_tango_host = host + ":" + strport;
            DbRedundancy dbr = DbRedundancy.get_instance();
            if (arrayList.size() > 3) {
                String redun = (String)arrayList.get(2) + ":" + (String)arrayList.get(3);
                dbr.put(def_tango_host, redun);
            }
        }
        catch (Exception e) {
            Except.throw_exception("TangoApi_TANGO_HOST_NOT_SET", e.toString() + " occurs when parsing " + "\"TANGO_HOST\" property " + tgh, "TangoApi.ApiUtil.parseTangoHost()");
        }
        return new String[]{host, strport};
    }

    @Override
    public double getZmqVersion() {
        if (EventConsumerUtil.isZmqLoadable()) {
            return ZMQutils.getZmqVersion();
        }
        return -1.0;
    }
}

