/*
 * Decompiled with CFR 0.152.
 */
package pogo.gene;

import java.io.File;

public class DeviceID {
    public boolean failed = false;
    public String classname = "";
    public String contact = "";
    public String family = "Miscellaneous";
    public String site = "";
    public String platform = "";
    public String bus = "";
    public String manufacturer = "none";
    public String reference = "";
    private static final String CLASS_NAME = "Class Name";
    private static final String CONTACT = "Contact";
    private static final String CLASS_FAMILY = "Class Family";
    private static final String SPECIFIC = "Specific";
    private static final String PLATFORM = "Platform";
    private static final String BUS = "Bus";
    private static final String MANUFACTURER = "Manufacturer";
    private static final String REFERENCE = "Reference";
    private static final String TITLE = "Device Class Identification:";
    private static final String filename = "TangoClassID.txt";

    public DeviceID() {
        this.failed = true;
    }

    public DeviceID(String classname, String contact, String family, String site, String platform, String bus, String manufacturer, String reference) {
        this.classname = classname;
        this.family = family;
        this.site = site;
        this.contact = contact;
        this.platform = platform;
        this.bus = bus;
        this.manufacturer = manufacturer;
        this.reference = reference;
    }

    public DeviceID(String code) {
        int end;
        int start = code.indexOf(TITLE);
        if (start > 0 && (end = code.indexOf("*/", start)) > 0) {
            code = code.substring(start, end);
            this.classname = this.getValue(code, CLASS_NAME);
            this.contact = this.getValue(code, CONTACT);
            String tmp = this.getValue(code, CLASS_FAMILY);
            if (tmp.trim().length() > 0) {
                this.family = tmp;
            }
            if ((tmp = this.getValue(code, SPECIFIC)).trim().length() > 0) {
                this.site = tmp;
            }
            this.platform = this.getValue(code, PLATFORM);
            this.bus = this.getValue(code, BUS);
            this.manufacturer = this.getValue(code, MANUFACTURER);
            this.reference = this.getValue(code, REFERENCE);
            return;
        }
        this.failed = true;
    }

    private String getValue(String code, String name) {
        int start = code.indexOf(name);
        if (start > 0 && (start = code.indexOf(58, start)) > 0) {
            int end;
            if ((end = code.indexOf(10, ++start)) > 0) {
                return code.substring(start, end).trim();
            }
            return code.substring(start).trim();
        }
        if (!name.equals(SPECIFIC)) {
            this.failed = true;
        }
        return "";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("/**\n");
        sb.append(" * ").append(TITLE).append("\n");
        sb.append(" * ").append("\n");
        sb.append(" * ").append(CLASS_NAME).append("   :\t").append(this.classname).append("\n");
        sb.append(" * ").append(CONTACT).append("      :\t").append(this.contact).append("\n");
        sb.append(" * ").append(CLASS_FAMILY).append(" :\t").append(this.family).append("\n");
        if (this.site != null && this.site.length() > 0) {
            sb.append(" * ").append(SPECIFIC).append("     :\t").append(SPECIFIC).append("\n");
        }
        sb.append(" * ").append(PLATFORM).append("     :\t").append(this.platform).append("\n");
        sb.append(" * ").append(BUS).append("          :\t").append(this.bus).append("\n");
        sb.append(" * ").append(MANUFACTURER).append(" :\t").append(this.manufacturer).append("\n");
        sb.append(" * ").append(REFERENCE).append("    :\t").append(this.reference).append("\n");
        sb.append(" */\n");
        return sb.toString();
    }

    public String getAuthorFromContact() {
        int idx = this.contact.indexOf(64);
        if (idx > 0) {
            return this.contact.substring(0, idx);
        }
        return this.contact;
    }

    private String getHidenContact() {
        int idx = this.contact.indexOf(64);
        if (idx < 0) {
            return "";
        }
        String name = this.contact.substring(0, idx);
        String domain = this.contact.substring(idx + 1);
        return " at " + domain + " - " + name;
    }

    public String toHtmlString() {
        if (this.failed) {
            return null;
        }
        StringBuffer sb = new StringBuffer("<Br><h2>Class Identification:</h2>\n<ul>\n");
        sb.append("\t<li><b>Contact      :</b>\t" + this.getHidenContact() + "\n");
        sb.append("\t<li><b>Class Family :</b>\t" + this.family + "\n");
        if (this.site != null && this.site.length() > 0) {
            sb.append("\t   (" + this.site + "     " + SPECIFIC + ")\n");
        }
        sb.append("\t<li><b>Platform     :</b>\t" + this.platform + "\n");
        sb.append("\t<li><b>Bus          :</b>\t" + this.bus + "\n");
        if (this.manufacturer.length() > 0 && !this.manufacturer.equals("none")) {
            sb.append("\t<li><b>Manufacturer :</b>\t" + this.manufacturer + "\n");
            if (this.reference.length() > 0 && this.reference.length() > 0) {
                sb.append("\t<li><b>Reference    :</b>\t" + this.reference + "\n");
            }
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public static boolean useRepository(String class_filename) {
        String dir;
        int idx = class_filename.lastIndexOf(47);
        if (idx < 0) {
            idx = class_filename.lastIndexOf(92);
        }
        if (new File((dir = class_filename.substring(0, ++idx)) + "CVS").exists()) {
            return true;
        }
        return new File(dir + ".svn").exists();
    }

    public static String getFilename(String class_filename) {
        int idx = class_filename.lastIndexOf(47);
        if (idx < 0) {
            idx = class_filename.lastIndexOf(92);
        }
        return class_filename.substring(0, ++idx) + filename;
    }
}

