/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.util.ArrayList;
import java.util.List;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ProtectedAreaManager {
    private List<ProtectedArea> protectedAreas = new ArrayList<ProtectedArea>();

    public ProtectedAreaManager(String fileName) throws PogoException {
        int start;
        String code = ParserTool.readFile(fileName);
        int end = 0;
        while ((start = code.indexOf("PROTECTED REGION ID(", end)) > 0) {
            start = code.lastIndexOf("\n", start);
            end = code.indexOf("PROTECTED REGION END", ++start);
            end = code.lastIndexOf("\n", end);
            String paCode = code.substring(start, end);
            this.protectedAreas.add(new ProtectedArea(paCode));
        }
    }

    public void setClassName(String newClassName, String fileName) throws PogoException {
        String code = ParserTool.readFile(fileName);
        for (ProtectedArea pa : this.protectedAreas) {
            pa.setClass(newClassName);
            code = this.replaceProtectedAreaCode(code, pa);
        }
        ParserTool.writeFile(fileName, code);
    }

    private String replaceProtectedAreaCode(String code, ProtectedArea pa) {
        int start = code.indexOf(pa.id_start);
        if (start >= 0) {
            start = code.indexOf(10, start) + 1;
            int end = code.indexOf("PROTECTED REGION END", start);
            end = code.lastIndexOf("\n", end);
            code = String.valueOf(code.substring(0, start)) + pa.code + code.substring(end);
        }
        return code;
    }

    private class ProtectedArea {
        String id_start;
        String className;
        String code;

        private ProtectedArea(String str) {
            int end = str.indexOf(10);
            if (end > 0) {
                this.id_start = str.substring(0, end).trim();
                this.code = str.substring(end + 1);
            } else {
                this.id_start = str;
                this.code = "";
            }
            int start = this.id_start.indexOf("ID(") + "ID(".length();
            end = this.id_start.indexOf("::", start);
            if (end < 0) {
                end = this.id_start.indexOf(")", start);
            }
            this.className = this.id_start.substring(start, end);
        }

        private void setClass(String newClassName) {
            if (this.id_start.indexOf("::") > 0) {
                int pos = this.id_start.indexOf(this.className);
                this.id_start = String.valueOf(this.id_start.substring(0, pos)) + newClassName + this.id_start.substring(pos + this.className.length());
            } else {
                String tmpClassName = this.className;
                int pos = tmpClassName.indexOf(".");
                if (pos > 0) {
                    tmpClassName = tmpClassName.substring(0, pos);
                }
                this.id_start = Utils.strReplace(this.id_start, tmpClassName, newClassName);
                this.code = Utils.strReplace(this.code, tmpClassName, newClassName);
                this.code = Utils.strReplace(this.code, tmpClassName.toUpperCase(), newClassName.toUpperCase());
                this.code = Utils.strReplace(this.code, tmpClassName.toLowerCase(), newClassName.toLowerCase());
            }
            this.className = newClassName;
        }

        public String toString() {
            return String.valueOf(this.className) + "\n" + this.id_start + "\n" + this.code + "\n------------------------";
        }
    }
}

