/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class PopupTable
extends JDialog {
    private static String[] col_names;
    private List<List<String>> data;
    private JLabel titleLabel;
    private JTable my_table;
    private JScrollPane scrollPane;

    public PopupTable(JDialog parent, String title, String[] col, List<List<String>> v) {
        super((Dialog)parent, false);
        this.buildObject(title, col, v);
    }

    public PopupTable(JFrame parent, String title, String[] col, List<List<String>> v) {
        super((Frame)parent, false);
        this.buildObject(title, col, v);
    }

    private void buildObject(String title, String[] col, List<List<String>> v) {
        col_names = col;
        this.initComponents();
        this.data = v;
        this.initMyComponents();
        this.titleLabel.setText(title);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void initComponents() {
        JPanel bottomPanel = new JPanel();
        JButton cancelBtn = new JButton();
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupTable.this.closeDialog(evt);
            }
        });
        cancelBtn.setText("Dismiss");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupTable.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.pack();
    }

    private void initMyComponents() {
        DataTableModel model = new DataTableModel();
        JTable table = new JTable(model);
        table.setRowSelectionAllowed(true);
        table.setColumnSelectionAllowed(true);
        table.setDragEnabled(false);
        table.setSelectionMode(0);
        table.getTableHeader().setFont(new Font("Dialog", 1, 14));
        this.scrollPane = new JScrollPane(table);
        this.scrollPane.setPreferredSize(new Dimension(650, 450));
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.my_table = table;
        model.fireTableDataChanged();
    }

    @Override
    public void setPreferredSize(Dimension d) {
        this.scrollPane.setPreferredSize(d);
    }

    public void setPreferredSize(int[] width, int nb_lines) {
        Enumeration<TableColumn> enumeration = this.my_table.getColumnModel().getColumns();
        int sp_width = 0;
        int i = 0;
        while (enumeration.hasMoreElements()) {
            TableColumn tc = enumeration.nextElement();
            tc.setPreferredWidth(width[i]);
            sp_width += width[i];
            ++i;
        }
        int height = (nb_lines + 2) * 16;
        this.scrollPane.setPreferredSize(new Dimension(sp_width, height));
        this.pack();
    }

    public void setColumnWidth(int[] width) {
        Enumeration<TableColumn> cenum = this.my_table.getColumnModel().getColumns();
        int sp_width = 0;
        int i = 0;
        while (cenum.hasMoreElements()) {
            TableColumn tc = cenum.nextElement();
            tc.setPreferredWidth(width[i]);
            sp_width += width[i];
            ++i;
        }
        Dimension d = this.scrollPane.getPreferredSize();
        d.width = sp_width;
        System.out.println(String.valueOf(d.width) + ", " + d.height);
        this.scrollPane.setPreferredSize(d);
        this.pack();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public class DataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -8416336946761607744L;

        @Override
        public int getColumnCount() {
            return col_names.length;
        }

        @Override
        public int getRowCount() {
            return PopupTable.this.data.size();
        }

        @Override
        public String getColumnName(int aCol) {
            if (aCol >= this.getColumnCount()) {
                return col_names[this.getColumnCount() - 1];
            }
            return col_names[aCol];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < PopupTable.this.data.size()) {
                if (col < ((List)PopupTable.this.data.get(row)).size()) {
                    return ((List)PopupTable.this.data.get(row)).get(col);
                }
                return "";
            }
            return "";
        }
    }
}

