/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ParserTool {
    public static String readFile(String filename) throws PogoException {
        String str = "";
        try {
            FileInputStream fid = new FileInputStream(filename);
            int nb = fid.available();
            byte[] inStr = new byte[nb];
            nb = fid.read(inStr);
            fid.close();
            if (nb > 0) {
                str = ParserTool.takeOffWindowsChar(inStr);
            }
        }
        catch (Exception e) {
            throw new PogoException(e.toString());
        }
        return str;
    }

    public static List<String> readFileLines(String filename, boolean withComments) throws PogoException {
        String code = ParserTool.readFile(filename);
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer stk = new StringTokenizer(code, "\n");
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken().trim();
            if (line.startsWith("#") && !withComments) continue;
            lines.add(line);
        }
        return lines;
    }

    public static String takeOffWindowsChar(byte[] b_in) {
        int nb = 0;
        byte[] byArray = b_in;
        int n = b_in.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != 13) {
                ++nb;
            }
            ++n2;
        }
        byte[] b_out = new byte[nb];
        int i = 0;
        int j = 0;
        while (i < b_in.length) {
            if (b_in[i] != 13) {
                b_out[j++] = b_in[i];
            }
            ++i;
        }
        return new String(b_out);
    }

    private static String checkOsFormat(String code) {
        if (!Utils.osIsUnix()) {
            return ParserTool.setWindowsFileFormat(code);
        }
        return code;
    }

    public static String setWindowsFileFormat(String code) {
        byte[] b = new byte[]{13, 10};
        String lsp = new String(b);
        code = code.replaceAll("\n", lsp);
        return code;
    }

    public static void writeFile(String filename, String code) throws PogoException {
        try {
            String s = System.getenv("LINUX");
            if (s == null || !s.equals("true")) {
                code = ParserTool.checkOsFormat(code);
            }
            FileOutputStream fidout = new FileOutputStream(filename);
            fidout.write(code.getBytes());
            fidout.close();
        }
        catch (Exception e) {
            throw new PogoException(e.toString());
        }
    }

    public static void modifyProtectedAreaID(String path, String fileName, String oldID, String newID) throws PogoException {
        String code;
        oldID = "PROTECTED REGION ID(" + oldID + ") ENABLED START";
        newID = "PROTECTED REGION ID(" + newID + ") ENABLED START";
        try {
            code = ParserTool.readFile(String.valueOf(path) + '/' + fileName);
        }
        catch (PogoException e) {
            return;
        }
        int start = code.indexOf(oldID);
        if (start < 0) {
            return;
        }
        int end = start + oldID.length();
        String newCode = String.valueOf(code.substring(0, start)) + newID + code.substring(end);
        ParserTool.writeFile(String.valueOf(path) + '/' + fileName, newCode);
    }

    public static void removeXmiKey(String key, String fileName) throws PogoException {
        boolean modified = false;
        key = " " + key + "=\"";
        String code = ParserTool.readFile(fileName);
        StringTokenizer stk = new StringTokenizer(code, "\n");
        ArrayList<String> v = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            int start = line.indexOf(key);
            if (start > 0) {
                int end = line.indexOf("\"", start + key.length());
                if (end < 0) {
                    System.err.println("XMI syntax error !!!");
                    return;
                }
                line = String.valueOf(line.substring(0, start)) + line.substring(end + 1);
                modified = true;
            }
            v.add(line);
        }
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String s : v) {
                sb.append(s).append("\n");
            }
            code = sb.toString();
            code = code.substring(0, code.length() - 1);
            ParserTool.writeFile(fileName, code);
        }
    }

    public static void renameXmiKey(String srcKey, String newKey, String fileName) throws PogoException {
        boolean modified = false;
        boolean startingLine = srcKey.startsWith("<");
        if (!startingLine) {
            srcKey = " " + srcKey + "=";
        }
        String code = ParserTool.readFile(fileName);
        StringTokenizer stk = new StringTokenizer(code, "\n");
        ArrayList<String> lines = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            String line = stk.nextToken();
            int start = line.indexOf(srcKey);
            if (start >= 0) {
                System.out.println("--------> replace " + srcKey + " by " + newKey);
                int end = start + srcKey.length();
                if (!startingLine) {
                    ++start;
                    --end;
                }
                line = String.valueOf(line.substring(0, start)) + newKey + line.substring(end);
                modified = true;
            }
            lines.add(line);
        }
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String s : lines) {
                sb.append(s).append("\n");
            }
            code = sb.toString();
            code = code.substring(0, code.length() - 1);
            ParserTool.writeFile(fileName, code);
        }
    }

    public static void convertProtectedAreaKey(String srcKey, String newKey, String fileName) throws PogoException {
        int endLine;
        boolean modified = false;
        String code = ParserTool.readFile(fileName);
        ArrayList<String> lines = new ArrayList<String>();
        int startLine = 0;
        while ((endLine = code.indexOf(10, startLine)) > 0) {
            int start;
            String line = code.substring(startLine, endLine);
            if (line.contains(" PROTECTED REGION ") && (start = line.indexOf(srcKey)) > 0) {
                int end = start + srcKey.length();
                line = String.valueOf(line.substring(0, start)) + newKey + line.substring(end);
                modified = true;
            }
            lines.add(line);
            startLine = endLine + 1;
        }
        lines.add(code.substring(startLine));
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            ParserTool.writeFile(fileName, sb.toString().trim());
            System.out.println("Replaced \"" + srcKey + "\"  by  \"" + newKey + "\" \t in " + fileName);
        }
    }

    public static void convertProtectedAreaKeyForStateMachine(List<String> attributeNames, String fileName, boolean toXtend) throws PogoException {
        int endLine;
        boolean modified = false;
        String code = ParserTool.readFile(fileName);
        ArrayList<String> lines = new ArrayList<String>();
        int startLine = 0;
        while ((endLine = code.indexOf(10, startLine)) > 0) {
            String line = code.substring(startLine, endLine);
            if (line.contains(" PROTECTED REGION ")) {
                for (String attributeName : attributeNames) {
                    int start;
                    String srcKey = "read_" + attributeName + "StateAllowed_READ";
                    String newKey = String.valueOf(attributeName) + "StateAllowed";
                    if (!toXtend) {
                        String tmp = newKey;
                        newKey = srcKey;
                        srcKey = tmp;
                    }
                    if ((start = line.indexOf(srcKey)) <= 0) continue;
                    int end = start + srcKey.length();
                    line = String.valueOf(line.substring(0, start)) + newKey + line.substring(end);
                    modified = true;
                }
            }
            lines.add(line);
            startLine = endLine + 1;
        }
        lines.add(code.substring(startLine));
        if (modified) {
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line).append('\n');
            }
            ParserTool.writeFile(fileName, sb.toString().trim());
            System.out.println("Replaced protected region keys in " + fileName);
        }
    }

    void convertForXTendCompatibility(PogoDeviceClass cls, boolean toXTend) {
        try {
            if (toXTend) {
                String fileHeader = String.valueOf(cls.getDescription().getSourcePath()) + "/" + cls.getName();
                String fileName = String.valueOf(fileHeader) + "Class.cpp";
                String srcKey = String.valueOf(cls.getName()) + "::Class::";
                String newKey = String.valueOf(cls.getName()) + "Class::";
                ParserTool.convertProtectedAreaKey(srcKey, newKey, fileName);
                fileName = String.valueOf(fileHeader) + "Class.h";
                srcKey = String.valueOf(cls.getName()) + "::";
                newKey = String.valueOf(cls.getName()) + "Class::";
                ParserTool.convertProtectedAreaKey(srcKey, newKey, fileName);
                fileName = String.valueOf(fileHeader) + "StateMachine.cpp";
                ArrayList<String> attributeNames = new ArrayList<String>();
                for (Attribute attribute : cls.getAttributes()) {
                    attributeNames.add(attribute.getName());
                }
                ParserTool.convertProtectedAreaKeyForStateMachine(attributeNames, fileName, true);
            } else {
                new Back2Height(cls);
            }
        }
        catch (PogoException e) {
            System.err.println(e.getMessage());
        }
    }

    static void manageWindowsProjects(PogoDeviceClass pogoClass) {
        byte[] sequence = new byte[]{-17, -69, -65};
        try {
            String[] fileNames;
            String path = String.valueOf(pogoClass.getDescription().getSourcePath()) + "/vc12_proj";
            File dir = new File(path);
            String[] stringArray = fileNames = dir.list();
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String absoluteFileName;
                String code;
                String fileName = stringArray[n2];
                if (fileName.contains(".vcxproj") && (code = ParserTool.readFile(absoluteFileName = String.valueOf(path) + "/" + fileName)).startsWith("<?xml ")) {
                    code = String.valueOf(new String(sequence)) + code;
                    ParserTool.writeFile(absoluteFileName, code);
                }
                ++n2;
            }
        }
        catch (PogoException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
    }

    private class Back2Height {
        private PogoDeviceClass cls = null;
        private String className;
        private String path = ".";
        private String xmiFileName;

        private Back2Height(PogoDeviceClass cls) throws PogoException {
            this.className = cls.getName();
            this.path = cls.getDescription().getSourcePath();
            this.xmiFileName = String.valueOf(this.path) + "/" + this.className + ".xmi";
            this.convert();
        }

        private Back2Height(String xmiFileName) throws PogoException {
            this.xmiFileName = xmiFileName;
            int pos = xmiFileName.lastIndexOf(47);
            if (pos < 0) {
                pos = xmiFileName.lastIndexOf(92);
            }
            int end = xmiFileName.lastIndexOf(46);
            if (pos > 0) {
                this.path = xmiFileName.substring(0, pos);
                this.className = xmiFileName.substring(pos + 1, end);
            } else {
                this.className = xmiFileName.substring(0, end);
            }
            this.convert();
        }

        private void convert() throws PogoException {
            System.out.println("Path = " + this.path);
            System.out.println("ClassName = " + this.className);
            System.out.println("cleaning " + this.xmiFileName);
            ParserTool.removeXmiKey("pogoRevision", this.xmiFileName);
            if (this.cls == null) {
                this.cls = OAWutils.getInstance().loadDeviceClassModel(this.xmiFileName, false);
            }
            String fileName = String.valueOf(this.path) + "/" + this.className + "Class.cpp";
            this.manageDevClassCpp(fileName);
            fileName = String.valueOf(this.path) + "/" + this.className + "Class.h";
            this.manageDevClassH(fileName);
            fileName = String.valueOf(this.path) + '/' + this.className + "StateMachine.cpp";
            ArrayList<String> attributeNames = new ArrayList<String>();
            for (Attribute attribute : this.cls.getAttributes()) {
                attributeNames.add(attribute.getName());
            }
            ParserTool.convertProtectedAreaKeyForStateMachine(attributeNames, fileName, true);
        }

        private void manageDevClassCpp(String fileName) throws PogoException {
            System.out.println("cleaning protected regions in " + fileName);
            String srcKey = String.valueOf(this.className) + "Class::";
            String newKey = String.valueOf(this.className) + "::Class::";
            ParserTool.convertProtectedAreaKey(srcKey, newKey, fileName);
        }

        private void manageDevClassH(String fileName) throws PogoException {
            int endLine;
            System.out.println("cleaning protected regions in " + fileName);
            boolean modified = false;
            String code = ParserTool.readFile(fileName);
            ArrayList<String> lines = new ArrayList<String>();
            int startLine = 0;
            int cnt = 0;
            String srcKey = String.valueOf(this.className) + "Class";
            while ((endLine = code.indexOf(10, startLine)) > 0) {
                int start;
                String line = code.substring(startLine, endLine);
                if (line.contains(" PROTECTED REGION ") && (start = line.indexOf(srcKey)) > 0 && ++cnt >= 3) {
                    System.out.println("Replace " + srcKey + " by " + this.className);
                    int end = start + srcKey.length();
                    line = String.valueOf(line.substring(0, start)) + this.className + line.substring(end);
                    modified = true;
                }
                lines.add(line);
                startLine = endLine + 1;
            }
            lines.add(code.substring(startLine));
            if (modified) {
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line).append('\n');
                }
                ParserTool.writeFile(fileName, sb.toString().trim());
                System.out.println("Replaced \"" + srcKey + "\"  by  \"" + this.className + "\" \t in " + fileName);
            }
        }
    }
}

