/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.packaging;

import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tango.pogo.pogo_gui.packaging.PackUtils;
import org.tango.pogo.pogo_gui.packaging.Packaging;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class ConfigurePackagingDialog
extends JDialog {
    private PogoDeviceClass deviceClass = null;
    private PogoMultiClasses multiClasses = null;
    private List<String> headers = new ArrayList<String>();
    private List<String> functions = new ArrayList<String>();
    private static final String[] defaultHeaders = new String[]{"string.h", "sys/time.h", "sys/timeb.h", "unistd.h"};
    private static final Cursor defaultCursor = new Cursor(0);
    private static final Cursor waitCursor = new Cursor(3);
    private JTextField authorText;
    private JList<String> functionList;
    private JList<String> headerList;
    private JButton removeFunctionButton;
    private JButton removeHeaderButton;
    private JTextField versionText;

    public ConfigurePackagingDialog(JFrame parent, PogoDeviceClass deviceClass) {
        super((Frame)parent, true);
        this.deviceClass = deviceClass;
        this.initOwnComponent(PackUtils.buildMailAddress(deviceClass.getDescription()), deviceClass.getDescription().getSourcePath());
    }

    public ConfigurePackagingDialog(JFrame parent, PogoMultiClasses multiClasses, String author) {
        super((Frame)parent, true);
        this.multiClasses = multiClasses;
        this.initOwnComponent(author, multiClasses.getSourcePath());
    }

    private void initOwnComponent(String author, String path) {
        this.initComponents();
        Collections.addAll(this.headers, defaultHeaders);
        this.headerList.setListData((String[])this.toArray(this.headers));
        this.authorText.setText(author);
        boolean b = !PackUtils.authorFileExists(path);
        this.authorText.setEnabled(b);
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private String[] toArray(List<String> list) {
        String[] array = new String[list.size()];
        int i = 0;
        while (i < list.size()) {
            array[i] = list.get(i);
            ++i;
        }
        return array;
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        JLabel titleLabel = new JLabel();
        JPanel centerPanel = new JPanel();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.headerList = new JList();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.functionList = new JList();
        JPanel btnPanel1 = new JPanel();
        JButton addHeaderButton = new JButton();
        this.removeHeaderButton = new JButton();
        JPanel btnPanel2 = new JPanel();
        JButton addFunctionButton = new JButton();
        this.removeFunctionButton = new JButton();
        JLabel versionLabel = new JLabel();
        this.versionText = new JTextField();
        JLabel authorLabel = new JLabel();
        this.authorText = new JTextField();
        JPanel bottomPanel = new JPanel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ConfigurePackagingDialog.this.closeDialog(evt);
            }
        });
        titleLabel.setFont(new Font("Dialog", 1, 18));
        titleLabel.setText("Packaging Check Configuration");
        topPanel.add(titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        centerPanel.setLayout(new GridBagLayout());
        jLabel1.setFont(new Font("Tahoma", 1, 14));
        jLabel1.setText("Headers to be checked");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        centerPanel.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setFont(new Font("Tahoma", 1, 14));
        jLabel2.setText("Functions to be checked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        centerPanel.add((Component)jLabel2, gridBagConstraints);
        jScrollPane1.setPreferredSize(new Dimension(35, 250));
        this.headerList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConfigurePackagingDialog.this.headerListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(this.headerList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        centerPanel.add((Component)jScrollPane1, gridBagConstraints);
        jScrollPane2.setPreferredSize(new Dimension(35, 250));
        this.functionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConfigurePackagingDialog.this.functionListValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(this.functionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        centerPanel.add((Component)jScrollPane2, gridBagConstraints);
        btnPanel1.setLayout(new GridBagLayout());
        addHeaderButton.setText("Add Header");
        addHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePackagingDialog.this.addHeaderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        btnPanel1.add((Component)addHeaderButton, gridBagConstraints);
        this.removeHeaderButton.setText("Remove");
        this.removeHeaderButton.setEnabled(false);
        this.removeHeaderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePackagingDialog.this.removeHeaderButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        btnPanel1.add((Component)this.removeHeaderButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 40);
        centerPanel.add((Component)btnPanel1, gridBagConstraints);
        btnPanel2.setLayout(new GridBagLayout());
        addFunctionButton.setText("Add Function");
        addFunctionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePackagingDialog.this.addFunctionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        btnPanel2.add((Component)addFunctionButton, gridBagConstraints);
        this.removeFunctionButton.setText("Remove");
        this.removeFunctionButton.setEnabled(false);
        this.removeFunctionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePackagingDialog.this.removeFunctionButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        btnPanel2.add((Component)this.removeFunctionButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        centerPanel.add((Component)btnPanel2, gridBagConstraints);
        versionLabel.setFont(new Font("Tahoma", 1, 14));
        versionLabel.setText("Version number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 20, 0);
        centerPanel.add((Component)versionLabel, gridBagConstraints);
        this.versionText.setColumns(8);
        this.versionText.setFont(new Font("Tahoma", 1, 14));
        this.versionText.setText("1.0");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 20, 0);
        centerPanel.add((Component)this.versionText, gridBagConstraints);
        authorLabel.setFont(new Font("Tahoma", 1, 14));
        authorLabel.setText("Author");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        centerPanel.add((Component)authorLabel, gridBagConstraints);
        this.authorText.setColumns(8);
        this.authorText.setFont(new Font("Tahoma", 1, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        centerPanel.add((Component)this.authorText, gridBagConstraints);
        this.getContentPane().add((Component)centerPanel, "Center");
        okBtn.setText("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePackagingDialog.this.okBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(okBtn);
        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigurePackagingDialog.this.cancelBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(cancelBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(waitCursor);
            String author = this.authorText.getText();
            String version = this.versionText.getText();
            Packaging packaging = this.multiClasses != null ? new Packaging(this.multiClasses, version, author) : new Packaging(this.deviceClass, version, author);
            packaging.generate(this.headers, this.functions);
            StringBuilder message = new StringBuilder("Packaging for " + packaging.getPackageName() + " has been created in:\n" + packaging.getPackagePath());
            message.append("\n\n\n");
            message.append("After configure command the following file will be generated.\n").append(packaging.getPackagePath()).append("/build/config.h\n");
            message.append("\n").append("You will be able to include it in your source files\n").append("to check headers/functions availability with:\n");
            for (String header : this.headers) {
                message.append("  #ifdef HAVE_").append(PackUtils.buildConfigureDefine(header)).append("\n");
            }
            message.append("\n");
            for (String function : this.functions) {
                message.append("  #ifdef HAVE_").append(PackUtils.buildConfigureDefine(function)).append("\n");
            }
            this.setCursor(defaultCursor);
            JOptionPane.showMessageDialog(this, message, "Packaging", 1);
        }
        catch (PogoException e) {
            this.setCursor(defaultCursor);
            e.popup(this);
        }
        this.doClose();
    }

    private void cancelBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void addHeaderButtonActionPerformed(ActionEvent evt) {
        String header = (String)JOptionPane.showInputDialog(this, "Header name ?", "Input Dialog", 1, null, null, null);
        if (header != null && header.length() > 0) {
            this.headers.add(header);
            this.headerList.setListData((String[])this.toArray(this.headers));
        }
    }

    private void removeHeaderButtonActionPerformed(ActionEvent evt) {
        String header = this.headerList.getSelectedValue();
        this.headers.remove(header);
        this.headerList.setListData((String[])this.toArray(this.headers));
    }

    private void addFunctionButtonActionPerformed(ActionEvent evt) {
        String function = (String)JOptionPane.showInputDialog(this, "Function name ?", "Input Dialog", 1, null, null, null);
        if (function != null && function.length() > 0) {
            this.functions.add(function);
            this.functionList.setListData((String[])this.toArray(this.functions));
        }
    }

    private void removeFunctionButtonActionPerformed(ActionEvent evt) {
        String function = this.functionList.getSelectedValue();
        this.functions.remove(function);
        this.functionList.setListData((String[])this.toArray(this.functions));
    }

    private void headerListValueChanged(ListSelectionEvent evt) {
        this.removeHeaderButton.setEnabled(true);
    }

    private void functionListValueChanged(ListSelectionEvent evt) {
        this.removeFunctionButton.setEnabled(true);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }
}

