/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.AbstractValidationDiagnostic;
import org.eclipse.xtext.validation.CheckType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureBasedDiagnostic
extends AbstractValidationDiagnostic {
    private final EStructuralFeature feature;
    private final int index;

    public FeatureBasedDiagnostic(int severity, String message, EObject source, EStructuralFeature feature, int index, CheckType checkType, String issueCode, String ... issueData) {
        super(severity, message, source, checkType, issueCode, issueData);
        if (feature != null && source != null && source.eClass().getEStructuralFeature(feature.getName()) != feature) {
            throw new IllegalArgumentException("The sources EClass '" + source.eClass().getName() + "' does not expose the feature '" + feature.getEContainingClass().getName() + "." + feature.getName() + "'");
        }
        this.feature = feature;
        this.index = index;
    }

    @Override
    public List<?> getData() {
        ArrayList<Object> result = Lists.newArrayListWithExpectedSize(3);
        result.add(this.getSourceEObject());
        if (this.feature != null) {
            result.add(this.feature);
            result.add(this.index);
        }
        if (this.getIssueData() != null) {
            result.add(this.getIssueData());
        }
        return result;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        if (this.getSourceEObject() != null && this.feature != null) {
            result.append(".");
            result.append(this.feature.getName());
            if (!this.feature.isMany()) {
                if (this.feature instanceof EAttribute) {
                    result.append("==\"");
                    result.append(this.getSourceEObject().eGet(this.feature));
                    result.append("\"");
                } else {
                    EObject value = (EObject)this.getSourceEObject().eGet(this.feature);
                    result.append("==(");
                    if (value == null) {
                        result.append("null");
                    } else {
                        result.append("(instanceof ");
                        result.append(value.eClass().getName());
                        result.append(": ").append(value);
                    }
                    result.append(")");
                }
            } else if (this.index != -1) {
                result.append("#").append(this.index);
                List list = (List)this.getSourceEObject().eGet(this.feature);
                Object value = list.get(this.index);
                if (this.feature instanceof EAttribute) {
                    result.append("==\"");
                    result.append(value);
                    result.append("\"");
                } else {
                    EObject eObject = (EObject)value;
                    result.append("==(");
                    if (value == null) {
                        result.append("null");
                    } else {
                        result.append("(instanceof ");
                        result.append(eObject.eClass().getName());
                        result.append(": ").append(eObject);
                    }
                    result.append(")");
                }
            }
        }
        return result.toString();
    }
}

