/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator.cpp.projects;

import fr.esrf.tango.pogo.generator.common.StringUtils;
import fr.esrf.tango.pogo.generator.cpp.utils.InheritanceUtils;
import fr.esrf.tango.pogo.pogoDsl.AdditionalFile;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.OneClassSimpleDef;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.PogoMultiClasses;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;

public class MakefileUtils
extends StringUtils {
    InheritanceUtils inheritanceUtils = new InheritanceUtils();
    private static ArrayList<String> inheritedObjectFiles;
    private static ArrayList<String> inheritedDependanciesFiles;

    static {
        inheritedDependanciesFiles = new ArrayList();
    }

    String makefileIncludesHeader() {
        return "#=============================================================================\n# INC_DIR_USER is the list of all include path needed by your sources\n#   - for a device server, tango dependencies are automatically appended\n#   - '-I ../include' and '-I .' are automatically appended in all cases\n#\nINC_DIR_USER= -I . ";
    }

    String makefileIncludes(PogoDeviceClass cls) {
        return String.valueOf(this.makefileIncludesHeader()) + this.addInheritanceIncludeHome(cls.getDescription().getInheritances());
    }

    String makefileIncludes(PogoMultiClasses multi) {
        String code = this.makefileIncludesHeader();
        for (OneClassSimpleDef cls : multi.getClasses()) {
            code = String.valueOf(code) + this.addClassIncludeHome(cls.getClassname());
            code = String.valueOf(code) + this.addInheritanceIncludeHome(cls.getInheritances());
        }
        return code;
    }

    String addInheritanceIncludeHome(EList<Inheritance> inheritances) {
        StringBuilder sb = new StringBuilder();
        for (Inheritance inheritance : inheritances) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            sb.append(this.addClassIncludeHome(inheritance.getClassname()));
        }
        return sb.toString();
    }

    String addClassIncludeHome(String className) {
        String code = "\\\n";
        code = String.valueOf(code) + "              -I $(" + this.classHomeDir(className) + ")";
        return code;
    }

    String addInheritancIncludeReference(PogoDeviceClass cls) {
        String code = "";
        for (Inheritance inheritance : cls.getDescription().getInheritances()) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            code = "$(SVC_INHERITANCE_INCL)";
        }
        return code;
    }

    String addClassesDefinitions(PogoMultiClasses multi) {
        inheritedObjectFiles = new ArrayList();
        String code = "#=============================================================================\n# Tango Class list used by project\n#\n";
        for (OneClassSimpleDef cls : multi.getClasses()) {
            code = String.valueOf(code) + this.addClassDefinition(cls.getClassname(), cls.getSourcePath());
            for (Inheritance inheritance : cls.getInheritances()) {
                if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
                code = String.valueOf(code) + "#------------ Inheritance from " + cls.getClassname() + " class ------------\n";
                code = String.valueOf(code) + this.addClassDefinition(inheritance.getClassname(), inheritance.getSourcePath());
            }
        }
        return code;
    }

    String addInheritanceDefinitions(PogoDeviceClass cls) {
        String code = "";
        if (this.inheritanceUtils.hasInheritanceClass(cls)) {
            code = "#=============================================================================\n# Following are names, pathes and files of the inherited classes used by project\n#\n";
            for (Inheritance inheritance : cls.getDescription().getInheritances()) {
                if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
                code = String.valueOf(code) + "#------------ Inheritance from " + cls.getName() + " class ------------\n";
                code = String.valueOf(code) + this.addClassDefinition(inheritance.getClassname(), inheritance.getSourcePath());
            }
        }
        return code;
    }

    String addClassDefinition(String classname, String sourcePath) {
        return String.valueOf(classname.toUpperCase()) + "_CLASS = " + classname + "\n" + this.classHomeDir(classname) + "  = " + sourcePath + "\n\n";
    }

    String addObjectFiles(PogoMultiClasses multi) {
        String code = "#=============================================================================\n# SVC_OBJS is the list of all objects needed to make the output\n#\nSVC_OBJS =  ";
        int i = 0;
        for (OneClassSimpleDef cls : multi.getClasses()) {
            if (i++ > 0) {
                code = String.valueOf(code) + "            ";
            }
            code = String.valueOf(code) + "$(SVC_" + cls.getClassname().toUpperCase() + "_OBJS) \\\n";
        }
        code = String.valueOf(code) + "            $(OBJDIR)/MultiClassesFactory.o \\\n            $(OBJDIR)/main.o";
        code = String.valueOf(code) + "\n\n";
        for (OneClassSimpleDef cls : multi.getClasses()) {
            code = String.valueOf(code) + this.addObjectFileList(cls);
        }
        return code;
    }

    private String addObjectFileList(OneClassSimpleDef cls) {
        String code = "#------------  Object files for " + cls.getClassname() + " class  ------------\n";
        code = String.valueOf(code) + "SVC_" + cls.getClassname().toUpperCase() + "_OBJS = \\\n";
        code = String.valueOf(code) + this.addObjectFileList(cls.getClassname());
        if (MakefileUtils.isTrue(cls.getHasDynamic())) {
            code = String.valueOf(code) + " \\\n";
            code = String.valueOf(code) + "\t\t$(OBJDIR)/" + cls.getClassname() + "DynAttrUtils.o";
        }
        for (AdditionalFile file : cls.getAdditionalFiles()) {
            code = String.valueOf(code) + " \\\n";
            code = String.valueOf(code) + "\t\t$(OBJDIR)/" + file.getName() + ".o";
        }
        for (Inheritance inheritance : cls.getInheritances()) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            code = String.valueOf(code) + " \\\n" + this.addObjectFileList(inheritance.getClassname());
        }
        code = String.valueOf(code) + "\n\n";
        return code;
    }

    private String addObjectFileList(String classname) {
        String classObjectFile = String.valueOf(classname) + ".o";
        String code = "";
        if (this.alreadyDeclared(classObjectFile, inheritedObjectFiles)) {
            return "";
        }
        code = String.valueOf(code) + "\t\t$(OBJDIR)/" + classname + ".o \\\n";
        code = String.valueOf(code) + "\t\t$(OBJDIR)/" + classname + "Class.o \\\n";
        code = String.valueOf(code) + "\t\t$(OBJDIR)/" + classname + "StateMachine.o";
        inheritedObjectFiles.add(classObjectFile);
        return code;
    }

    private boolean alreadyDeclared(String str, ArrayList<String> list) {
        for (String s : list) {
            if (!s.equals(str)) continue;
            return true;
        }
        return false;
    }

    String dependancies(PogoMultiClasses multi) {
        String code = "";
        for (OneClassSimpleDef cls : multi.getClasses()) {
            code = String.valueOf(code) + "#------------  Object files dependancies for " + cls.getClassname() + " class  ------------\n";
            code = String.valueOf(code) + this.dependanciesIncludes(cls.getClassname(), cls.getInheritances());
            code = String.valueOf(code) + this.dependanciesObject(cls.getClassname(), "");
            code = String.valueOf(code) + this.dependanciesObject(cls.getClassname(), "Class");
            code = String.valueOf(code) + this.dependanciesObject(cls.getClassname(), "StateMachine");
            if (MakefileUtils.isTrue(cls.getHasDynamic())) {
                code = String.valueOf(code) + this.dependanciesObject(cls.getClassname(), "DynAttrUtils");
            }
            for (AdditionalFile file : cls.getAdditionalFiles()) {
                code = String.valueOf(code) + this.dependanciesObjectAddFile(cls.getClassname(), file.getName(), false);
            }
            for (Inheritance inheritance : cls.getInheritances()) {
                if (!this.inheritanceUtils.isInheritanceClass(inheritance) || this.alreadyDeclared(inheritance.getClassname(), inheritedDependanciesFiles)) continue;
                code = String.valueOf(code) + this.dependanciesObject(inheritance.getClassname(), "");
                code = String.valueOf(code) + this.dependanciesObject(inheritance.getClassname(), "Class");
                code = String.valueOf(code) + this.dependanciesObject(inheritance.getClassname(), "StateMachine");
                inheritedDependanciesFiles.add(inheritance.getClassname());
            }
            code = String.valueOf(code) + "\n";
        }
        return code;
    }

    String dependanciesIncludes(String classname, EList<Inheritance> inheritances) {
        String code = "";
        if (inheritances != null) {
            code = String.valueOf(code) + this.classIncludeDir(classname) + " = \\\n";
            for (Inheritance inheritance : inheritances) {
                if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
                code = String.valueOf(code) + this.dependanciesIncludes(inheritance.getClassname(), null);
                code = String.valueOf(code) + " \\\n";
            }
        }
        code = String.valueOf(code) + "\t\t$(" + this.classHomeDir(classname) + ")/" + classname + ".h \\\n";
        code = String.valueOf(code) + "\t\t$(" + this.classHomeDir(classname) + ")/" + classname + "Class.h";
        if (inheritances != null) {
            code = String.valueOf(code) + "\n\n";
        }
        return code;
    }

    private String dependanciesObject(String classname, String sufix) {
        String code = "$(OBJDIR)/" + classname + sufix + ".o:" + "  $(" + this.classHomeDir(classname) + ")/" + classname + sufix + ".cpp $(" + this.classIncludeDir(classname) + ")\n";
        code = String.valueOf(code) + "\t$(CXX) $(CXXFLAGS) -c $< -o $(OBJDIR)/" + classname + sufix + ".o\n";
        return code;
    }

    private String dependanciesObjectAddFile(String classname, String filename, boolean mainClass) {
        String code = "$(OBJDIR)/" + filename + ".o:";
        code = mainClass ? String.valueOf(code) + "  " + filename + ".cpp $(SVC_INCL)\n" : String.valueOf(code) + "  $(" + this.classHomeDir(classname) + ")/" + filename + ".cpp $(" + this.classIncludeDir(classname) + ")\n";
        code = String.valueOf(code) + "\t$(CXX) $(CXXFLAGS) -c $< -o $(OBJDIR)/" + filename + ".o\n";
        return code;
    }

    private String classIncludeDir(String classname) {
        return String.valueOf(classname.toUpperCase()) + "_INCLUDES";
    }

    private String classHomeDir(String classname) {
        return String.valueOf(classname.toUpperCase()) + "_HOME";
    }

    String makeEnv(PogoMultiClasses multi, boolean cmake) {
        String dbg = System.getProperty("DEBUG_MAKE");
        String code = "# MAKE_ENV is the path to find common environment to buil project\n#\n";
        code = cmake ? String.valueOf(code) + "set(MAKE_ENV " : String.valueOf(code) + "MAKE_ENV = ";
        code = dbg != null ? String.valueOf(code) + dbg : (MakefileUtils.isSet(multi.getPreferences().getMakefileHome()) ? String.valueOf(code) + multi.getPreferences().getMakefileHome() : String.valueOf(code) + "$(TANGO_HOME)");
        if (cmake) {
            code = String.valueOf(code) + ")";
        }
        return code;
    }

    String makeEnv(PogoDeviceClass cls, boolean cmake) {
        String dbg = System.getProperty("DEBUG_MAKE");
        String code = "# MAKE_ENV is the path to find common environment to buil project\n#\n";
        code = cmake ? String.valueOf(code) + "set(MAKE_ENV " : String.valueOf(code) + "MAKE_ENV = ";
        code = dbg != null ? String.valueOf(code) + dbg : (MakefileUtils.isSet(cls.getPreferences().getMakefileHome()) ? String.valueOf(code) + cls.getPreferences().getMakefileHome() : String.valueOf(code) + "$(TANGO_HOME)");
        if (cmake) {
            code = String.valueOf(code) + ")";
        }
        return code;
    }

    String inheritanceDependancies(PogoDeviceClass cls) {
        String code = "#=============================================================================\n# Following are dependancies of the inherited classes used by project\n#\n";
        for (Inheritance inher : cls.getDescription().getInheritances()) {
            if (!this.inheritanceUtils.isInheritanceClass(inher)) continue;
            code = String.valueOf(code) + "\n#------------  Object files dependancies for " + inher.getClassname() + " class  ------------\n";
            code = String.valueOf(code) + this.classIncludeDir(inher.getClassname()) + " = \\\n";
            code = String.valueOf(code) + "\t\t$(" + this.classHomeDir(inher.getClassname()) + ")/" + inher.getClassname() + ".h \\\n";
            code = String.valueOf(code) + "\t\t$(" + this.classHomeDir(inher.getClassname()) + ")/" + inher.getClassname() + "Class.h\n";
            code = String.valueOf(code) + this.dependanciesObject(inher.getClassname(), "");
            code = String.valueOf(code) + this.dependanciesObject(inher.getClassname(), "Class");
            code = String.valueOf(code) + this.dependanciesObject(inher.getClassname(), "StateMachine");
        }
        code = String.valueOf(code) + "\nSVC_INHERITANCE_INCL = ";
        for (Inheritance inheritance : cls.getDescription().getInheritances()) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            code = String.valueOf(code) + " $(" + this.classIncludeDir(inheritance.getClassname()) + ")";
        }
        code = String.valueOf(code) + "\n";
        return code;
    }

    String dynamicAttrObjects(PogoDeviceClass cls) {
        String code = "";
        if (cls.getDynamicAttributes().size() > 0 || cls.getDynamicCommands().size() > 0) {
            code = "$(OBJDIR)/$(PACKAGE_NAME)DynAttrUtils.o \\\n";
        }
        return code;
    }

    String inheritanceObjects(PogoDeviceClass cls) {
        String code = "";
        if (this.inheritanceUtils.hasInheritanceClass(cls)) {
            code = "$(SVC_INHERITANCE_OBJ) \\\n";
        }
        return code;
    }

    String addAdditionalObjectFiles(PogoDeviceClass cls) {
        String code = "";
        if (cls.getAdditionalFiles().size() > 0) {
            code = "#------------ Object files for additional files ------------\nADDITIONAL_OBJS = \\\n" + this.buildAdditionalFileListForMakefile(cls.getAdditionalFiles(), "\t\t$(OBJDIR)/", ".o");
        }
        return code;
    }

    public String additionalDependencies(PogoDeviceClass cls) {
        String code = "";
        for (AdditionalFile file : cls.getAdditionalFiles()) {
            code = String.valueOf(code) + this.dependanciesObjectAddFile(cls.getName(), file.getName(), true);
        }
        return code;
    }

    public String buildAdditionalFileListForMakefile(EList<AdditionalFile> list, String startTag, String endTag) {
        ArrayList<String> files = new ArrayList<String>();
        for (AdditionalFile file : list) {
            files.add(file.getName());
        }
        return this.buildFileListForMakefile(files, startTag, endTag);
    }

    public String buildInheritanceFileListForMakefile(EList<Inheritance> list, String startTag, String endTag) {
        ArrayList<String> files = new ArrayList<String>();
        for (Inheritance inheritance : list) {
            files.add(inheritance.getClassname());
        }
        return this.buildFileListForMakefile(files, startTag, endTag);
    }

    private String buildFileListForMakefile(ArrayList<String> list, String startTag, String endTag) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append(startTag).append(list.get(i)).append(endTag);
            if (i < list.size() - 1) {
                sb.append(" \\").append('\n');
            }
            ++i;
        }
        return sb.toString();
    }

    public String upperClassName(PogoDeviceClass cls) {
        return cls.getName().toUpperCase();
    }

    public String cmakeSourcefileList(PogoDeviceClass cls) {
        String code = "set(" + this.upperClassName(cls) + "_SRC ${" + this.upperClassName(cls) + "}.cpp" + " ${" + this.upperClassName(cls) + "}Class.cpp" + " ${" + this.upperClassName(cls) + "}StateMachine.cpp";
        if (cls.getDynamicAttributes().size() > 0 || cls.getDynamicCommands().size() > 0) {
            code = String.valueOf(code) + " ${" + this.upperClassName(cls) + "}DynAttrUtils.cpp";
        }
        code = String.valueOf(code) + this.cmakeAdditionnalFiles(cls);
        return String.valueOf(code) + ")";
    }

    public String cmakeSourcefileList(String path, String upperClassName, boolean hasDynamic) {
        String code = "set(" + upperClassName + "_SRC " + path + "${" + upperClassName + "}.cpp" + " " + path + "${" + upperClassName + "}Class.cpp" + " " + path + "${" + upperClassName + "}StateMachine.cpp";
        if (hasDynamic) {
            code = String.valueOf(code) + " ${" + upperClassName + "}DynAttrUtils.cpp";
        }
        return String.valueOf(code) + ")";
    }

    public String cmakeAdditionnalFiles(PogoDeviceClass cls) {
        EList<AdditionalFile> additionalFiles = cls.getAdditionalFiles();
        String str = "";
        for (AdditionalFile additionalFile : additionalFiles) {
            str = String.valueOf(str) + " " + additionalFile.getName() + ".cpp";
        }
        return str;
    }

    public String cmakeClassParameters(PogoDeviceClass cls) {
        return "#\n# Files for " + cls.getName() + " TANGO class\n" + "#\n" + "set(" + this.upperClassName(cls) + " " + cls.getName() + ")\n" + "set(" + this.upperClassName(cls) + "_INCLUDE ${CMAKE_SOURCE_DIR})\n" + this.cmakeSourcefileList(cls);
    }

    public String cmakeInheritanceClassParameters(PogoDeviceClass cls) {
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        StringBuilder sb = new StringBuilder();
        for (Inheritance inheritance : inheritances) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            String path = inheritance.getSourcePath();
            String upperClassName = inheritance.getClassname().toUpperCase();
            String str = "#\n# Files for " + inheritance.getClassname() + " TANGO class\n" + "#\n";
            str = String.valueOf(str) + "set(" + upperClassName + "_PATH " + path + ")\n";
            str = String.valueOf(str) + "set(" + upperClassName + " " + inheritance.getClassname() + ")\n";
            str = String.valueOf(str) + "set(" + upperClassName + "_INCLUDE " + path + ")\n";
            str = String.valueOf(str) + this.cmakeSourcefileList("${" + upperClassName + "_PATH}/", upperClassName, false) + "\n";
            sb.append(str);
        }
        return sb.toString();
    }

    public String cmakeInheritanceFileList(PogoDeviceClass cls, String fileType) {
        EList<Inheritance> inheritances = cls.getDescription().getInheritances();
        StringBuilder sb = new StringBuilder();
        for (Inheritance inheritance : inheritances) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            sb.append("${").append(inheritance.getClassname().toUpperCase()).append(fileType).append("} ");
        }
        return sb.toString();
    }

    String cmakeAddClassesDefinitions(PogoMultiClasses multi) {
        inheritedObjectFiles = new ArrayList();
        String code = "#\n# Tango Class list used by project\n#\n";
        for (OneClassSimpleDef simple : multi.getClasses()) {
            code = String.valueOf(code) + "\n#\n# Files for " + simple.getClassname() + " TANGO class\n" + "#\n";
            for (Inheritance inheritance : simple.getInheritances()) {
                if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
                code = String.valueOf(code) + "#------------ Inheritance from " + inheritance.getClassname() + " class ------------\n";
                code = String.valueOf(code) + this.cmakeAddClassDefinition(inheritance.getClassname(), inheritance.getSourcePath());
            }
            code = String.valueOf(code) + "set(" + this.upperClassName(simple) + "  " + simple.getClassname() + ")\n";
            code = String.valueOf(code) + "set(" + this.upperClassName(simple) + "_PATH  " + simple.getSourcePath() + ")\n";
            code = String.valueOf(code) + "set(" + this.upperClassName(simple) + "_INCLUDE  ";
            for (Inheritance inheritance : simple.getInheritances()) {
                if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
                code = String.valueOf(code) + "${" + inheritance.getClassname().toUpperCase() + "_INCLUDE} ";
            }
            code = String.valueOf(code) + simple.getSourcePath() + ")\n";
            code = String.valueOf(code) + this.cmakeSourcefileList(simple);
        }
        return code;
    }

    public String upperClassName(OneClassSimpleDef simple) {
        return simple.getClassname().toUpperCase();
    }

    public String cmakeFileList(PogoMultiClasses multi, String fileType) {
        StringBuilder sb = new StringBuilder();
        for (OneClassSimpleDef simple : multi.getClasses()) {
            sb.append("${").append(simple.getClassname().toUpperCase()).append(fileType).append("} ");
        }
        return sb.toString();
    }

    public String cmakeSourcefileList(OneClassSimpleDef simple) {
        String path = "${" + this.upperClassName(simple) + "_PATH}/";
        String code = "set(" + this.upperClassName(simple) + "_SRC  " + this.cmakeInheritanceFileList(simple) + path + "${" + this.upperClassName(simple) + "}.cpp " + path + "${" + this.upperClassName(simple) + "}Class.cpp " + path + "${" + this.upperClassName(simple) + "}StateMachine.cpp ";
        if (MakefileUtils.isTrue(simple.getHasDynamic())) {
            code = String.valueOf(code) + path + "${" + this.upperClassName(simple) + "}DynAttrUtils.cpp ";
        }
        code = String.valueOf(code) + this.cmakeAdditionnalFiles(simple);
        return String.valueOf(code.trim()) + ")";
    }

    public String cmakeAdditionnalFiles(OneClassSimpleDef simple) {
        String path = "${" + this.upperClassName(simple) + "_PATH}/";
        EList<AdditionalFile> additionalFiles = simple.getAdditionalFiles();
        String str = "";
        for (AdditionalFile additionalFile : additionalFiles) {
            str = String.valueOf(str) + path + additionalFile.getName() + ".cpp ";
        }
        return str;
    }

    public String cmakeAddClassDefinition(String classname, String sourcePath) {
        String path = "${" + classname.toUpperCase() + "_PATH}/";
        return "set(" + classname.toUpperCase() + "_CLASS " + classname + ")\n" + "set(" + classname.toUpperCase() + "_PATH " + sourcePath + ")\n" + "set(" + classname.toUpperCase() + "_INCLUDE " + sourcePath + ")\n" + "set(" + classname.toUpperCase() + "_SRC " + path + classname + ".cpp " + path + classname + "Class.cpp " + path + classname + "StateMachine.cpp)\n";
    }

    public String cmakeInheritanceFileList(OneClassSimpleDef simple) {
        String code = "";
        for (Inheritance inheritance : simple.getInheritances()) {
            if (!this.inheritanceUtils.isInheritanceClass(inheritance)) continue;
            code = String.valueOf(code) + "${" + inheritance.getClassname().toUpperCase() + "_SRC} ";
        }
        return code;
    }
}

