/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tango.pogo.generator;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import fr.esrf.tango.pogo.generator.PogoGeneratorModule;
import fr.esrf.tango.pogo.pogoDsl.PogoSystem;
import java.util.Map;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtext.generator.GeneratorComponent;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;

public class PogoDslGeneratorComponent
extends AbstractWorkflowComponent2 {
    private String modelSlot;
    private Injector injector;
    private Map<String, String> outlets = Maps.newHashMap();
    @Inject
    private IGenerator generator;

    public PogoDslGeneratorComponent() {
        this.injector = Guice.createInjector(new PogoGeneratorModule());
        this.injector.injectMembers(this);
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        this.checkRequiredConfigProperty("modelSlot", this.modelSlot, issues);
        super.checkConfigurationInternal(issues);
    }

    @Override
    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        Object slotContent = ctx.get(this.modelSlot);
        if (slotContent == null) {
            throw new IllegalStateException("slot " + this.modelSlot + " is empty");
        }
        if (!(slotContent instanceof PogoSystem)) {
            throw new IllegalStateException("illegal object of type " + slotContent.getClass().getName() + " in slot " + this.modelSlot);
        }
        PogoSystem system = (PogoSystem)slotContent;
        this.generator.doGenerate(system.eResource(), this.getConfiguredFileSystemAccess());
    }

    public void setModelSlot(String modelSlot) {
        this.modelSlot = modelSlot;
    }

    public void addOutlet(GeneratorComponent.Outlet out) {
        this.outlets.put(out.getOutletName(), out.getPath());
    }

    protected IFileSystemAccess getConfiguredFileSystemAccess() {
        JavaIoFileSystemAccess configuredFileSystemAccess = this.injector.getInstance(JavaIoFileSystemAccess.class);
        for (Map.Entry<String, String> outs : this.outlets.entrySet()) {
            configuredFileSystemAccess.setOutputPath(outs.getKey(), outs.getValue());
        }
        return configuredFileSystemAccess;
    }
}

