/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PopupColorCode
extends JDialog {
    private final InherStatus[] inherSatus;
    private JPanel centerPanel;
    private JLabel titleLabel;

    public PopupColorCode(JFrame parent) {
        super((Frame)parent, true);
        this.inherSatus = new InherStatus[]{new InherStatus(Utils.getInstance().abstractIcon, "Abstract item inherited from parent class"), new InherStatus(Utils.getInstance().inheritedIcon, "Concrete item inherited from parent class"), new InherStatus(Utils.getInstance().overloadedIcon, "Concrete item defined in this class")};
        this.initComponents();
        this.buildColorPanel();
        this.titleLabel.setText("Pogo color code");
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
    }

    private void buildColorPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.centerPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        for (InherStatus is : this.inherSatus) {
            gbc.fill = 0;
            gbc.gridx = 0;
            this.centerPanel.add((Component)new JLabel(is.icon), gbc);
            gbc.fill = 2;
            gbc.gridx = 1;
            this.centerPanel.add((Component)new JLabel(is.description), gbc);
            ++gbc.gridy;
        }
        gbc.gridx = 1;
        this.centerPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.centerPanel.add((Component)new JLabel("Value"), gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        this.centerPanel.add((Component)new JLabel("Item can be controlled by expert and operator level."), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        JLabel lbl = new JLabel("Value");
        lbl.setForeground(Color.blue);
        this.centerPanel.add((Component)lbl, gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        this.centerPanel.add((Component)new JLabel("Item can be controlled by expert only."), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        lbl = new JLabel("Value");
        lbl.setForeground(Color.red);
        this.centerPanel.add((Component)lbl, gbc);
        gbc.fill = 2;
        gbc.gridx = 1;
        this.centerPanel.add((Component)new JLabel("Inheritance item type has changed."), gbc);
        ++gbc.gridy;
        this.centerPanel.add((Component)new JSeparator(), gbc);
    }

    private void initComponents() {
        JPanel topPanel = new JPanel();
        this.titleLabel = new JLabel();
        this.centerPanel = new JPanel();
        JPanel bottomPanel = new JPanel();
        JButton dismisslBtn = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PopupColorCode.this.closeDialog(evt);
            }
        });
        this.titleLabel.setFont(new Font("Dialog", 1, 18));
        this.titleLabel.setText("Dialog Title");
        topPanel.add(this.titleLabel);
        this.getContentPane().add((Component)topPanel, "North");
        this.centerPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.centerPanel, "Center");
        dismisslBtn.setText("Dismiss");
        dismisslBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PopupColorCode.this.dismisslBtnActionPerformed(evt);
            }
        });
        bottomPanel.add(dismisslBtn);
        this.getContentPane().add((Component)bottomPanel, "South");
        this.pack();
    }

    private void dismisslBtnActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new PopupColorCode(new JFrame()).setVisible(true);
    }

    private class InherStatus {
        private ImageIcon icon;
        private String description;

        private InherStatus(ImageIcon icon, String desc) {
            this.icon = icon;
            this.description = desc;
        }
    }
}

