/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoProperty {
    private static final String packname = "org.tango.pogo";
    private static final String defPropFilename = "/Pogo.default_properties";
    private static final String sitePropFilename = "/Pogo.site_properties";
    private static PogoProperty instance = null;
    public static List<String> classFamilies = new ArrayList<String>();
    public static List<String> platformNames = new ArrayList<String>();
    public static List<String> busNames = new ArrayList<String>();
    private static final String copyrightProp = "copyright";
    private static final String docHomeProp = "doc_home";
    private static final String makefileHomeProp = "makefile_home";
    private static final String installHomeProp = "install_home";
    private static final String classFamiliesProp = "class_families";
    private static final String platformNamesProp = "platform_names";
    private static final String busNamesProp = "bus_names";
    private static final String siteNameProp = "site.name";
    private static final String siteClassFamiliesProp = "site.class_families";
    public static String siteName = null;
    public static String copyright = "";
    public static String docHome = "./doc_html";
    public static String makefileHome = "$(TANGO_HOME)";
    public static String installHome = "$(TANGO_HOME)";
    public static List<String> siteClassFamilies = new ArrayList<String>();
    private static final int ownHistoSize = 20;
    private static final String ownInheritanceHome = "hinerit_home";
    private static final String ownContactAddress = "contact_address";
    private static final String ownLoadPrevious = "load_previous";
    private static final String ownProjectHistory = "project_history";
    private static final String multiProjectHistory = "multi_class_project_history";
    public static String inheritHome = null;
    public static String contactAddress = "";
    public static boolean loadPrevious = true;
    public static List<String> projectHistory = new ArrayList<String>();
    public static List<String> multiClassProjectHistory = new ArrayList<String>();
    public static final Object monitor = new Object();

    public static PogoProperty getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PogoProperty init() throws PogoException {
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                instance = new PogoProperty();
            }
        }
        return instance;
    }

    private PogoProperty() throws PogoException {
        this.checkEnvironment();
        this.loadDefaultProperties();
        this.loadSiteProperties();
        this.loadPogoRcProperties();
        this.displayProperties();
    }

    private void checkEnvironment() {
        String classpath = System.getProperty("java.class.path");
        if (Utils.osIsUnix()) {
            StringTokenizer stk = new StringTokenizer(classpath, ":");
            classpath = "";
            while (stk.hasMoreTokens()) {
                String s = stk.nextToken();
                File f = new File(s);
                if (f.exists()) {
                    classpath = classpath + s + ":";
                    continue;
                }
                System.err.println(s + " found in classpath,  does not exist !!!");
            }
            if (classpath.endsWith(":")) {
                classpath = classpath.substring(0, classpath.length() - 1);
            }
        }
        System.setProperty("java.class.path", classpath);
    }

    private void loadDefaultProperties() throws PogoException {
        try {
            List<String> vs = this.loadProperties(defPropFilename);
            classFamilies = this.getStringListProperty(classFamiliesProp, vs);
            platformNames = this.getStringListProperty(platformNamesProp, vs);
            busNames = this.getStringListProperty(busNamesProp, vs);
            installHome = this.checkOverwritingPropertyString(installHomeProp, installHome, vs);
            classFamilies.add(0, "");
            busNames.add(0, "");
        }
        catch (Exception e) {
            if (e instanceof PogoException) {
                throw (PogoException)e;
            }
            throw new PogoException(e.toString());
        }
    }

    private void loadSiteProperties() {
        try {
            List<String> codeList = this.loadSiteProperties(sitePropFilename);
            siteName = this.getStringProperty(siteNameProp, codeList);
            copyright = this.checkOverwritingLinesProperty(copyrightProp, codeList);
            docHome = this.checkOverwritingPropertyString(docHomeProp, docHome, codeList);
            makefileHome = this.checkOverwritingPropertyString(makefileHomeProp, makefileHome, codeList);
            siteClassFamilies = this.getStringListProperty(siteClassFamiliesProp, codeList);
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\tNo site specific properties file found !\n");
        }
    }

    private String checkOverwritingLinesProperty(String propertyName, List<String> codeLines) {
        ArrayList<String> lines = new ArrayList<String>();
        boolean in = false;
        String header = "org.tango.pogo." + propertyName + ":";
        for (String codeLine : codeLines) {
            if (codeLine.startsWith(header)) {
                in = true;
            } else if (codeLine.startsWith(packname)) {
                in = false;
            }
            if (!in) continue;
            if (codeLine.startsWith(header)) {
                lines.add(codeLine.substring(header.length()).trim());
                continue;
            }
            lines.add(codeLine);
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line).append("\n");
        }
        return sb.toString().trim();
    }

    private void loadPogoRcProperties() {
        try {
            String rc_file = PogoProperty.getPogoRCname();
            if (rc_file != null) {
                System.out.println(rc_file);
                List<String> propertyList = this.loadPropertiesRC(rc_file);
                projectHistory = this.getStringListProperty(ownProjectHistory, propertyList);
                multiClassProjectHistory = this.getStringListProperty(multiProjectHistory, propertyList);
                inheritHome = this.getStringProperty(ownInheritanceHome, propertyList);
                contactAddress = this.getStringProperty(ownContactAddress, propertyList);
                String tmp = this.getStringProperty(ownLoadPrevious, propertyList);
                loadPrevious = Utils.isTrue(tmp);
                if (projectHistory.size() > 0 && projectHistory.get(0).length() == 0) {
                    projectHistory.remove(0);
                }
                if (multiClassProjectHistory.size() > 0 && multiClassProjectHistory.get(0).length() == 0) {
                    multiClassProjectHistory.remove(0);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\t" + e);
        }
    }

    private String checkOverwritingPropertyString(String propertyName, String propertyValue, List<String> propertyList) {
        String tmp = this.getStringProperty(propertyName, propertyList);
        if (tmp != null) {
            propertyValue = tmp;
        }
        return propertyValue;
    }

    private static String getPogoRCname() {
        String env = System.getenv("HOME");
        if (env == null) {
            env = System.getenv("TANGO_ROOT");
        }
        if (env == null) {
            return null;
        }
        return env + "/.pogorc";
    }

    private List<String> loadSiteProperties(String filename) throws PogoException, IOException {
        String str;
        URL url = this.getClass().getResource(filename);
        System.out.println("Reading properties from " + url.getFile());
        InputStream is = url.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((str = br.readLine()) != null) {
            if (str.startsWith("#") || str.length() <= 0) continue;
            lines.add(str);
        }
        br.close();
        return lines;
    }

    private List<String> loadProperties(String filename) throws PogoException, IOException {
        String str;
        URL url = this.getClass().getResource(filename);
        System.out.println("Reading properties from " + url.getFile());
        InputStream is = url.openStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> lines = new ArrayList<String>();
        while ((str = br.readLine()) != null) {
            if ((str = str.trim()).startsWith("#") || str.length() <= 0) continue;
            lines.add(str);
        }
        br.close();
        return lines;
    }

    private List<String> loadPropertiesRC(String filename) throws PogoException, IOException {
        ArrayList<String> vs = new ArrayList<String>();
        String code = ParserTool.readFile(filename);
        StringTokenizer stk = new StringTokenizer(code, "\n");
        while (stk.hasMoreTokens()) {
            vs.add(stk.nextToken());
        }
        return vs;
    }

    private List<String> getStringListProperty(String propertyName, List<String> vs) {
        ArrayList<String> result = new ArrayList<String>();
        boolean found = false;
        for (String line : vs) {
            if (line.trim().startsWith("#")) continue;
            if (!found) {
                int pos;
                if (!line.startsWith("org.tango.pogo." + propertyName) || (pos = line.indexOf(58)) <= 0) continue;
                found = true;
                result.add(line.substring(pos + 1).trim());
                continue;
            }
            if (line.trim().indexOf(58) > 2) {
                found = false;
                continue;
            }
            result.add(line.trim());
        }
        return result;
    }

    private String getStringProperty(String propertyName, List<String> propertyList) {
        for (String s : propertyList) {
            int pos;
            if (!s.startsWith("org.tango.pogo." + propertyName) || (pos = s.indexOf(58)) <= 0) continue;
            String str = s.substring(pos + 1).trim();
            if (str.length() > 0) {
                return str;
            }
            return null;
        }
        return null;
    }

    public void displayProperties() {
        String debug = System.getProperty("DEBUG_PROP");
        if (debug != null && debug.equals("true")) {
            this.displayProperty(classFamiliesProp, classFamilies);
            this.displayProperty(platformNamesProp, platformNames);
            this.displayProperty(busNamesProp, busNames);
        }
        this.displayProperty(docHomeProp, docHome);
        this.displayProperty(makefileHomeProp, makefileHome);
        this.displayProperty(installHomeProp, installHome);
        this.displayProperty(siteNameProp, siteName);
        this.displayProperty(copyrightProp, copyright);
        if (debug != null && debug.equals("true")) {
            this.displayProperty(siteClassFamiliesProp, siteClassFamilies);
        }
    }

    private void displayProperty(String name, String value) {
        System.out.println(name + ":\t" + value);
    }

    private void displayProperty(String name, List<String> values) {
        System.out.print(name + ":");
        for (String s : values) {
            System.out.println("\t" + s);
        }
        System.out.println();
    }

    public static void addProject(String projectName, int type) {
        if (type == 0) {
            for (int i = 0; i < projectHistory.size(); ++i) {
                if (!projectHistory.get(i).equals(projectName)) continue;
                projectHistory.remove(i);
            }
            projectHistory.add(0, projectName);
            while (projectHistory.size() > 20) {
                projectHistory.remove(19);
            }
        } else {
            for (int i = 0; i < multiClassProjectHistory.size(); ++i) {
                if (!multiClassProjectHistory.get(i).equals(projectName)) continue;
                multiClassProjectHistory.remove(i);
            }
            multiClassProjectHistory.add(0, projectName);
            while (multiClassProjectHistory.size() > 20) {
                multiClassProjectHistory.remove(19);
            }
        }
        PogoProperty.updatePogoRC();
    }

    private static String buildPropertyLine(String propertyName) {
        return "org.tango.pogo." + propertyName + ":\t";
    }

    public static void updatePogoRC() {
        StringBuilder sb = new StringBuilder();
        sb.append("#\n");
        sb.append("#       This is the Pogo user preferences file\n");
        sb.append("#\n\n");
        sb.append(PogoProperty.buildPropertyLine(ownInheritanceHome)).append(inheritHome);
        sb.append("\n");
        sb.append(PogoProperty.buildPropertyLine(ownContactAddress)).append(contactAddress);
        sb.append("\n");
        sb.append(PogoProperty.buildPropertyLine(ownLoadPrevious)).append(loadPrevious);
        sb.append("\n\n");
        sb.append(PogoProperty.buildPropertyLine(ownProjectHistory)).append('\n');
        for (String project : projectHistory) {
            sb.append('\t').append(project).append('\n');
        }
        sb.append("\n\n");
        sb.append(PogoProperty.buildPropertyLine(multiProjectHistory)).append('\n');
        for (String project : multiClassProjectHistory) {
            sb.append('\t').append(project).append('\n');
        }
        String rc_file = PogoProperty.getPogoRCname();
        String code = "";
        try {
            code = ParserTool.readFile(rc_file);
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\t" + e);
        }
        try {
            if (!code.equals(sb.toString())) {
                ParserTool.writeFile(rc_file, sb.toString());
                System.out.println(rc_file + " updated");
            }
        }
        catch (Exception e) {
            System.err.println("\nWARNING:\t" + e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateSitePropertyFile(Component parent) throws PogoException {
        int end;
        URL url = this.getClass().getResource(sitePropFilename);
        String fileName = null;
        boolean alreadyExists = true;
        if (url == null) {
            alreadyExists = false;
            Utils.popupError(new JFrame(), "URL for property file (/Pogo.site_properties) is unknown !\n\nSelect a directory to write property file.\nIt will have to be added in  your CLASSPATH environment.");
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showDialog(parent, "Target Dir.") != 0) return false;
            File file = fileChooser.getSelectedFile();
            if (file != null && file.isDirectory()) {
                fileName = file.getAbsolutePath() + sitePropFilename;
            }
        } else {
            fileName = url.toString();
            if (fileName.startsWith("file:")) {
                fileName = fileName.substring("file:".length());
            }
        }
        String code = ParserTool.readFile(fileName);
        boolean writeIt = false;
        int start = code.indexOf(siteNameProp);
        if (start > 0) {
            start = code.indexOf(58, start) + 1;
            end = code.indexOf(10, start);
            code = code.substring(0, start) + "  " + (siteName == null ? "" : siteName) + code.substring(end);
            writeIt = true;
        }
        if (copyright != null && !copyright.isEmpty()) {
            start = code.indexOf(copyrightProp);
            if (start > 0) {
                end = code.indexOf("#", start);
                if (end < 0) {
                    end = code.indexOf(packname, start);
                }
                code = end > 0 ? code.substring(0, start) + copyrightProp + ":\n" + copyright + "\n\n" + code.substring(end) : code.substring(0, start) + copyrightProp + ":\n" + copyright + "\n";
            } else {
                code = code + "#\n#\tCopyright for generated Tango classes\n#\norg.tango.pogo.copyright:\n" + copyright + "\n";
            }
            writeIt = true;
        }
        if ((start = code.indexOf(siteClassFamiliesProp)) > 0) {
            StringBuilder indent = new StringBuilder();
            for (int i = 0; i < siteClassFamiliesProp.length() + packname.length() + 3; ++i) {
                indent.append(' ');
            }
            StringBuilder sb = new StringBuilder("  ");
            for (String family : siteClassFamilies) {
                sb.append(family).append('\n').append((CharSequence)indent);
            }
            String property = "  " + sb.toString().trim() + '\n';
            start = code.indexOf(58, start) + 1;
            int end2 = code.indexOf(35, start);
            code = code.substring(0, start) + property + code.substring(end2);
            writeIt = true;
        }
        if (!writeIt) return true;
        System.out.println("writing  " + fileName);
        ParserTool.writeFile(fileName, code);
        if (alreadyExists) return true;
        JOptionPane.showMessageDialog(parent, "File " + fileName + "has been written\n\n" + "Add the directory to your CLASSPATH environment to be re-loaded by Pogo !", "Help Window", 1);
        return true;
    }

    public static void main(String[] args) {
        try {
            PogoProperty.init().displayProperties();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

