/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.tango.pogo.pogo_gui.tools.Utils;

public class PogoException
extends Exception {
    private String description;
    private StackTraceElement[] stackTraceElements;
    private String origin;

    public PogoException(String desc) {
        this.description = desc;
        this.origin = this.getCurrentCodeLine();
    }

    private String getCurrentCodeLine() {
        this.stackTraceElements = Thread.currentThread().getStackTrace();
        return this.stackTraceElements[3].toString();
    }

    public void popup(Component component) {
        ErrorPane errorPane = component instanceof JFrame ? new ErrorPane((JFrame)component) : (component instanceof JDialog ? new ErrorPane((JDialog)component) : new ErrorPane((JFrame)null));
        ATKGraphicsUtils.centerDialog(errorPane);
        errorPane.setVisible(true);
    }

    public void print_exception() {
        System.err.println("PogoException:");
        System.err.println("    Description: " + this.description);
        System.err.println("    Origin:      " + this.origin);
    }

    @Override
    public void printStackTrace() {
        StringBuilder sb = new StringBuilder(this.description + "\n");
        int i = 0;
        for (StackTraceElement stackTraceElement : this.stackTraceElements) {
            if (i++ <= 0 || stackTraceElement.toString().contains("PogoException")) continue;
            sb.append(stackTraceElement).append("\n");
        }
        System.err.println(sb);
    }

    public static void popup(Component component, Exception exception) {
        PogoException.popup(component, exception.getMessage());
    }

    public static void popup(Component component, String message) {
        PogoException pogoException = new PogoException(message);
        pogoException.popup(component);
    }

    @Override
    public String getMessage() {
        return "PogoException: " + this.description;
    }

    @Override
    public String toString() {
        return "PogoException: " + this.description;
    }

    private class ErrorPane
    extends JDialog {
        private JTextArea descriptionText;
        private JScrollPane stackScrollPane;
        private JTextArea stackText;

        private ErrorPane(JFrame frame) {
            super((Frame)frame, true);
            this.initComponents();
            this.displayError();
        }

        private ErrorPane(JDialog dialog) {
            super((Dialog)dialog, true);
            this.initComponents();
            this.displayError();
        }

        private void displayError() {
            StringBuilder sb = new StringBuilder("\n");
            StringTokenizer stk = new StringTokenizer(PogoException.this.description, "\n");
            while (stk.hasMoreTokens()) {
                String line = stk.nextToken();
                sb.append(line).append(" \n");
            }
            this.descriptionText.setText(sb.toString());
            this.descriptionText.setRows(2 + stk.countTokens());
            sb = new StringBuilder(PogoException.this.description + "\n");
            int i = 0;
            for (StackTraceElement stackTraceElement : PogoException.this.stackTraceElements) {
                if (i++ <= 0 || stackTraceElement.toString().contains("PogoException")) continue;
                sb.append(stackTraceElement).append("\n");
            }
            this.stackText.setText(sb.toString());
            int rows = PogoException.this.stackTraceElements.length;
            if (rows > 25) {
                rows = 25;
            }
            this.stackText.setRows(rows);
            this.pack();
        }

        private void initComponents() {
            this.setTitle("PogoException");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ErrorPane.this.closeDialog();
                }
            });
            this.descriptionText = new JTextArea();
            this.descriptionText.setEditable(false);
            this.descriptionText.setFont(new Font("Dialog", 1, 14));
            this.descriptionText.setBackground(this.getContentPane().getBackground());
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BorderLayout());
            topPanel.add((Component)new JLabel(Utils.getInstance().errorIcon), "West");
            topPanel.add((Component)this.descriptionText, "Center");
            this.getContentPane().add((Component)topPanel, "North");
            this.stackText = new JTextArea();
            this.stackText.setEditable(false);
            this.stackScrollPane = new JScrollPane();
            this.stackScrollPane.setViewportView(this.stackText);
            this.stackScrollPane.setVisible(false);
            this.getContentPane().add((Component)this.stackScrollPane, "Center");
            JPanel bottomPanel = new JPanel();
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ErrorPane.this.cancelBtnActionPerformed();
                }
            });
            bottomPanel.add(okButton);
            JButton detailsBtn = new JButton("Details...");
            detailsBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ErrorPane.this.detailsBtnActionPerformed();
                }
            });
            bottomPanel.add(detailsBtn);
            this.getContentPane().add((Component)bottomPanel, "South");
        }

        private void detailsBtnActionPerformed() {
            this.stackScrollPane.setVisible(!this.stackScrollPane.isVisible());
            this.pack();
        }

        private void cancelBtnActionPerformed() {
            this.setVisible(false);
            this.dispose();
        }

        private void closeDialog() {
            this.setVisible(false);
            this.dispose();
        }
    }
}

