/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui.tools;

import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;

public class CompatUtils {
    private String fileCode;
    private String filename;
    private static final String startAttributeTag = "<attributes";
    private static final String endAttributeTag = "</attributes>";
    private static final boolean test = false;

    public CompatUtils(String filename) throws PogoException {
        this.filename = filename;
        this.fileCode = ParserTool.readFile(filename);
    }

    public void write() throws PogoException {
        ParserTool.writeFile(this.filename, this.fileCode);
    }

    private void replaceAttributeTags(String find, String with) {
        int start;
        int end = 0;
        String[] data = new String[]{find, with};
        while ((start = this.fileCode.indexOf(startAttributeTag, end)) > 0) {
            end = this.fileCode.indexOf(endAttributeTag, start);
            String str = this.fileCode.substring(start, end);
            str = this.replaceString(str, data);
            this.fileCode = this.fileCode.substring(0, start) + str + this.fileCode.substring(end);
            end = start + str.length();
        }
    }

    private String replaceString(String str, String[] data) {
        int start;
        int end = 0;
        while ((start = str.indexOf(data[0], end)) > 0) {
            end = start + data[0].length();
            str = str.substring(0, start) + data[1] + str.substring(end);
            end = start + data[1].length();
        }
        return str;
    }

    public String toString() {
        return this.fileCode;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("xmi file  ?");
            System.exit(0);
        }
        String filename = args[0];
        try {
            CompatUtils util = new CompatUtils(filename);
            util.replaceAttributeTags("excludedStates", "readExcludedStates");
            util.write();
        }
        catch (PogoException e) {
            System.err.println(e);
        }
    }
}

