/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.Argument;
import fr.esrf.tango.pogo.pogoDsl.AttrProperties;
import fr.esrf.tango.pogo.pogoDsl.Attribute;
import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tango.pogo.pogoDsl.Command;
import fr.esrf.tango.pogo.pogoDsl.FireEvents;
import fr.esrf.tango.pogo.pogoDsl.Inheritance;
import fr.esrf.tango.pogo.pogoDsl.InheritanceStatus;
import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tango.pogo.pogoDsl.Property;
import fr.esrf.tango.pogo.pogoDsl.State;
import fr.esrf.tango.pogo.pogoDsl.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.DeviceIdDialog;
import org.tango.pogo.pogo_gui.InheritanceUtils;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PropertyDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.OldModelParser;
import org.tango.pogo.pogo_gui.tools.ParserTool;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoParser;
import org.tango.pogo.pogo_gui.tools.Utils;
import pogo.gene.Attrib;
import pogo.gene.AttribTable;
import pogo.gene.Cmd;
import pogo.gene.CmdTable;
import pogo.gene.DevState;
import pogo.gene.DevStateTable;
import pogo.gene.PogoClass;
import pogo.gene.PropertyTable;

public class OldPogoModel {
    private PogoDeviceClass new_model = OAWutils.factory.createPogoDeviceClass();
    private PogoClass old_model = null;
    public static final String[] cppFilenames = new String[]{"Makefile", "main.cpp", "ClassFactory.cpp", "ClassName.h", "ClassName.cpp", "ClassNameClass.h", "ClassNameClass.cpp", "ClassNameStateMachine.cpp"};

    public OldPogoModel(String string) throws PogoException {
        this.new_model.setDescription(OAWutils.factory.createClassDescription());
        try {
            Object object;
            String string2;
            System.out.println("Trying to load " + string);
            if (System.getProperty("TEMPL_HOME") == null) {
                System.setProperty("TEMPL_HOME", "");
            }
            this.old_model = new PogoClass(string);
            this.new_model.setName(this.old_model.class_name);
            this.new_model.getDescription().setDescription(this.old_model.class_desc);
            this.new_model.getDescription().setLanguage(PogoConst.strLang[this.old_model.language]);
            this.new_model.getDescription().setSourcePath(Utils.getPath(string));
            this.new_model.getDescription().setTitle(this.old_model.title);
            Inheritance inheritance = OAWutils.factory.createInheritance();
            String string3 = System.getProperty("SUPER_HOME");
            if (string3 == null) {
                string3 = "";
            }
            if (this.old_model.inherited_from != null) {
                string2 = this.old_model.inherited_from;
                int n = string2.lastIndexOf(47);
                if (n < 0) {
                    n = string2.lastIndexOf(92);
                }
                if (n > 0) {
                    string3 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                }
            } else {
                string2 = "Device_Impl";
                this.old_model.inherited_from = "Device_Impl";
            }
            inheritance.setClassname(string2);
            inheritance.setSourcePath(string3);
            EList<Inheritance> eList = this.new_model.getDescription().getInheritances();
            eList.add(inheritance);
            if (this.old_model.device_id != null) {
                if (!this.old_model.device_id.failed) {
                    object = OAWutils.factory.createClassIdentification();
                    DeviceIdDialog.buildIdContact((ClassIdentification)object, this.old_model.device_id.contact);
                    object.setPlatform(this.old_model.device_id.platform);
                    object.setBus(this.old_model.device_id.bus);
                    object.setManufacturer(this.old_model.device_id.manufacturer);
                    object.setReference(this.old_model.device_id.reference);
                    object.setClassFamily(this.old_model.device_id.family);
                    object.setSiteSpecific(this.old_model.device_id.site);
                    this.new_model.getDescription().setIdentification((ClassIdentification)object);
                } else {
                    System.err.println("old_model.device_id Failed !");
                }
            }
            object = this.new_model.getClassProperties();
            EList<Property> eList2 = this.new_model.getDeviceProperties();
            EList<Command> eList3 = this.new_model.getCommands();
            EList<Attribute> eList4 = this.new_model.getAttributes();
            EList<State> eList5 = this.new_model.getStates();
            this.manageOldProperties((EList<Property>)object, this.old_model.class_properties);
            this.manageOldProperties(eList2, this.old_model.dev_properties);
            this.manageOldCommands(eList3, this.old_model.commands);
            this.manageOldAttributes(eList4, this.old_model.attributes);
            this.manageOldStates(eList5, this.old_model.states);
            System.out.println(string + "  Loaded !!!");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PogoException(exception.toString() + "\n\n" + "Loading OLD Pogo Class Failed\n");
        }
    }

    public PogoDeviceClass getPogoDeviceClass() {
        return this.new_model;
    }

    public boolean isAbsAbstract() {
        return this.old_model.is_abstractclass;
    }

    public void recoverCppCodeFromOldPogoModel(PogoDeviceClass pogoDeviceClass) throws Exception {
        String string = pogoDeviceClass.getName();
        String string2 = pogoDeviceClass.getDescription().getSourcePath() + "/" + pogoDeviceClass.getName();
        PogoParser pogoParser = new PogoParser(string2 + ".h");
        OldModelParser oldModelParser = new OldModelParser(this.old_model.projectFiles.getServer_h(), this.old_model);
        String string3 = this.getIncludeFiles(".h");
        if ((string3 = string3 + this.getDefinitions()).length() > 0) {
            pogoParser.insertIncludeFiles(string3);
        }
        string3 = "public:\n" + oldModelParser.getDataMembers();
        pogoParser.insertInProtectedZone(string, "Data Members", string3);
        string3 = oldModelParser.getAdditionalMethodPrototypes();
        pogoParser.insertAdditionalMethodPrototypes(string, string3);
        string3 = oldModelParser.getAdditionalClassDeclarations();
        pogoParser.insertAdditionalClassDefs(string, string3);
        string3 = oldModelParser.getAdditionalClasses();
        pogoParser.insertAdditionalClasses(string, string3);
        pogoParser.write();
        System.out.println(string2 + ".h  updated");
        pogoParser = new PogoParser(string2 + ".cpp");
        oldModelParser = new OldModelParser(this.old_model.projectFiles.getServer(), this.old_model);
        string3 = this.getIncludeFiles(".cpp");
        pogoParser.insertIncludeFiles(string3);
        string3 = this.getStaticInit(oldModelParser);
        pogoParser.insertInProtectedZone(string, "namespace_starting", string3);
        string3 = this.getInitDeviceCodeBefore(oldModelParser);
        pogoParser.insertInProtectedZone(string, "init_device_before", string3);
        string3 = this.getInitDeviceCodeAfter(oldModelParser);
        pogoParser.insertInProtectedZone(string, "init_device", string3);
        string3 = this.getDeleteDeviceCode(oldModelParser);
        pogoParser.insertInProtectedZone(string, "delete_device", string3);
        string3 = this.getInitPropertyCode(oldModelParser, true);
        pogoParser.insertInProtectedZone(string, "get_device_property_before", string3);
        string3 = this.getEndPropertyCode(oldModelParser, true);
        pogoParser.insertInProtectedZone(string, "get_device_property_after", string3);
        string3 = this.getAlwaysExecutedHookCode(oldModelParser);
        pogoParser.insertInProtectedZone(string, "always_executed_hook", string3);
        EList<Command> eList = pogoDeviceClass.getCommands();
        for (Command object2 : eList) {
            string3 = this.getCommandCode(oldModelParser, object2);
            if (string3 != null && string3.length() > 0) {
                System.out.println("inserting code for command" + object2.getName());
            }
            pogoParser.insertInProtectedZone(string, object2.getExecMethod(), string3);
        }
        string3 = this.getReadAttrHardwareCode(oldModelParser);
        pogoParser.insertInProtectedZone(string, "read_attr_hardware", string3);
        EList<Attribute> eList2 = pogoDeviceClass.getAttributes();
        Iterator pogoException = eList2.iterator();
        while (pogoException.hasNext()) {
            Attribute attribute = (Attribute)pogoException.next();
            string3 = this.getReadAttributeCode(oldModelParser, attribute);
            if (string3 != null && string3.length() > 0) {
                System.out.println("inserting code for attribute " + attribute.getName());
            }
            pogoParser.removeProtectedZone(string, "read_" + attribute.getName());
            pogoParser.insertInProtectedZone(string, "read_" + attribute.getName(), string3);
            string3 = this.getWriteAttributeCode(oldModelParser, attribute);
            pogoParser.removeProtectedZone(string, "write_" + attribute.getName());
            pogoParser.insertInProtectedZone(string, "write_" + attribute.getName(), string3);
        }
        string3 = oldModelParser.getUnexpectedMethods();
        pogoParser.insertInProtectedZone(string, "namespace_ending", string3);
        pogoParser.write();
        System.out.println(string2 + ".cpp  updated");
        pogoParser = new PogoParser(string2 + "Class.cpp");
        oldModelParser = new OldModelParser(this.old_model.projectFiles.getServerClass(), this.old_model);
        string3 = this.getIncludeFiles("Class.cpp");
        pogoParser.insertIncludeFiles(string3);
        string3 = this.getConstructorCode(oldModelParser);
        pogoParser.insertInProtectedZone(string, "Class::constructor", string3);
        string3 = this.getInitPropertyCode(oldModelParser, false);
        pogoParser.insertInProtectedZone(string, "Class::get_class_property_before", string3);
        string3 = this.getEndPropertyCode(oldModelParser, false);
        pogoParser.insertInProtectedZone(string, "Class::get_class_property_after", string3);
        string3 = this.getDserverAdditionnalMethods(oldModelParser);
        pogoParser.insertInProtectedZone(string, "Class::Additional Methods", string3);
        string3 = this.getDeviceFactoryCode(oldModelParser, true);
        pogoParser.insertInProtectedZone(string, "Class::device_factory_before", string3);
        string3 = this.getDeviceFactoryCode(oldModelParser, false);
        pogoParser.insertInProtectedZone(string, "Class::device_factory_after", string3);
        pogoParser.write();
        System.out.println(string2 + "Class.cpp  updated");
        pogoParser = new PogoParser(string2 + "Class.h");
        oldModelParser = new OldModelParser(this.old_model.projectFiles.getServerClass_h(), this.old_model);
        string3 = this.getIncludeFiles("Class.h");
        pogoParser.insertIncludeFiles(string3);
        string3 = this.getDserverDataMembers(oldModelParser);
        pogoParser.insertInProtectedZone(string, "Additionnal DServer data members", string3);
        string3 = this.getDserverDynamicClasses(oldModelParser);
        pogoParser.insertInProtectedZone(string, "classes for dynamic creation", string3);
        pogoParser.write();
        System.out.println(string2 + "Class.h  updated");
        pogoParser = new PogoParser(string2 + "StateMachine.cpp");
        oldModelParser = new OldModelParser(this.old_model.projectFiles.getAllowed(), this.old_model);
        for (Command command : eList) {
            string3 = this.getIsAllowedCode(oldModelParser, command.getName());
            pogoParser.insertInProtectedZone(string, command.getName() + "StateAllowed", string3);
        }
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            string3 = this.getIsAllowedCode(oldModelParser, attribute.getName());
            pogoParser.insertInProtectedZone(string, "read_" + attribute.getName() + "StateAllowed_READ", string3);
        }
        pogoParser.write();
        System.out.println(string2 + "StateMachine.cpp  updated");
        try {
            pogoParser = new PogoParser(pogoDeviceClass.getDescription().getSourcePath() + "/main.cpp");
            oldModelParser = new OldModelParser(this.old_model.projectFiles.getPath() + "/main.cpp", this.old_model);
            string3 = this.getMainCode(oldModelParser);
            pogoParser.removeProtectedZoneAtEnd(string, "main.cpp", "#i");
            pogoParser.insertInProtectedZoneAtEnd(string, "main.cpp", string3);
            pogoParser.write();
            System.out.println("main.cpp  updated");
        }
        catch (PogoException pogoException2) {
            System.err.println("================================================================");
            System.err.println("\t" + pogoException2);
            System.err.println("================================================================");
        }
    }

    private String getMainCode(OldModelParser oldModelParser) {
        String string = oldModelParser.getCode();
        int n = string.indexOf("Program Obviously used to Generate tango Object");
        if (n > 0) {
            n = string.indexOf("\n", n) + 1;
            n = string.indexOf("\n", n) + 1;
            n = string.indexOf("\n", n) + 1;
            n = string.indexOf("\n", n) + 1;
            string = string.substring(n);
        }
        return string;
    }

    public void manageCppAdditionalFiles(PogoDeviceClass pogoDeviceClass) throws Exception {
        Object object;
        File file;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : cppFilenames) {
            arrayList.add(Utils.strReplace(string, "ClassName", this.old_model.class_name));
        }
        String string = pogoDeviceClass.getDescription().getSourcePath();
        String string2 = this.old_model.projectFiles.getPath();
        List<String> list = Utils.getInstance().getFileList(string2);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string3 : list) {
            boolean bl = false;
            for (String string4 : arrayList) {
                if (!string3.equals(string4)) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList2.add(string3);
        }
        for (String string5 : arrayList2) {
            System.out.println("Copiing " + string5);
            ParserTool.writeFile(string + "/" + string5, ParserTool.readFile(string2 + "/" + string5));
        }
        String string6 = string2 + "/ClassFactory.cpp";
        if (new File(string6).exists()) {
            String string7 = pogoDeviceClass.getDescription().getSourcePath() + "/ClassFactory.cpp";
            ParserTool.writeFile(string7, "/*----- PROTECTED REGION ID(ClassFactory.cpp) ENABLED START -----*/\n" + ParserTool.readFile(string6) + "/*----- PROTECTED REGION END -----*/\n");
            System.out.println("ClassFactory.cpp  updated");
        }
        if ((file = new File(string2 + "/Makefile")).exists()) {
            String string8 = string + "/Makefile";
            object = "#PROTECTED REGION ID(" + pogoDeviceClass.getName() + "Makefile) ENABLED START#\n" + ParserTool.readFile(file.toString()) + "#PROTECTED REGION END#\n";
            ParserTool.writeFile(string8, (String)object);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string4 : arrayList2) {
                if (!string4.endsWith(".cpp")) continue;
                stringBuilder.append("\t\\\n\t\t$(OBJS_DIR)/");
                stringBuilder.append(string4.substring(0, string4.length() - 3));
                stringBuilder.append("o");
            }
            if (stringBuilder.length() > 0) {
                try {
                    object = new PogoParser(string + "/Makefile");
                    ((PogoParser)object).addObjFiles(stringBuilder.toString());
                }
                catch (Exception exception) {
                    System.err.println(exception.toString());
                }
            }
        }
    }

    public void swapDirectories(PogoDeviceClass pogoDeviceClass) throws Exception {
        String string = System.getenv("TEST_MODE");
        if (string != null && string.toLowerCase().equals("true")) {
            return;
        }
        String string2 = this.old_model.projectFiles.getPath();
        File file = new File(string2 + "/old_src");
        file.mkdir();
        List<String> list = Utils.getInstance().getFileList(string2);
        for (String object : list) {
            new File(string2 + "/" + object).renameTo(new File(string2 + "/old_src/" + object));
        }
        String string3 = pogoDeviceClass.getDescription().getSourcePath();
        list = Utils.getInstance().getFileList(string3);
        for (String string4 : list) {
            new File((String)string3 + "/" + string4).renameTo(new File(string2 + "/" + string4));
        }
        new File(string3).delete();
    }

    private void manageOldProperties(EList<Property> eList, PropertyTable propertyTable) {
        for (int i = 0; i < propertyTable.size(); ++i) {
            Object object;
            pogo.gene.Property property = propertyTable.propertyAt(i);
            Property property2 = OAWutils.factory.createProperty();
            property2.setName(property.name);
            property2.setDescription(Utils.strReplaceSpecialCharToCode(property.description));
            EList<String> eList2 = property2.getDefaultPropValue();
            if (property.default_value != null) {
                object = new StringTokenizer(property.default_value, "\n");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    eList2.add(((StringTokenizer)object).nextToken());
                }
            }
            property2.setType(PropertyDialog.tango2pogoType(property.type.cpp));
            object = OAWutils.factory.createInheritanceStatus();
            object.setAbstract("false");
            object.setInherited("false");
            object.setConcrete("true");
            object.setConcreteHere("true");
            property2.setStatus((InheritanceStatus)object);
            eList.add(property2);
        }
    }

    private void manageOldStates(EList<State> eList, DevStateTable devStateTable) {
        for (int i = 0; i < devStateTable.size(); ++i) {
            DevState devState = devStateTable.stateAt(i);
            State state = OAWutils.factory.createState();
            String string = devState.name;
            String string2 = "Tango::";
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            }
            state.setName(string);
            state.setDescription(devState.description);
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            inheritanceStatus.setAbstract("false");
            inheritanceStatus.setInherited("false");
            inheritanceStatus.setConcrete("true");
            inheritanceStatus.setConcreteHere("true");
            state.setStatus(inheritanceStatus);
            eList.add(state);
        }
    }

    private void manageOldCommands(EList<Command> eList, CmdTable cmdTable) {
        for (int i = 0; i < cmdTable.size(); ++i) {
            Cmd cmd = cmdTable.cmdAt(i);
            Command command = OAWutils.factory.createCommand();
            command.setName(cmd.name);
            command.setDescription(cmd.description);
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            if (this.old_model.is_abstractclass) {
                inheritanceStatus.setAbstract("true");
            } else {
                inheritanceStatus.setAbstract("false");
                if (this.old_model.inherited_from.startsWith("Device_") && this.old_model.inherited_from.endsWith("Impl")) {
                    inheritanceStatus.setInherited("false");
                } else {
                    inheritanceStatus.setInherited("true");
                }
                inheritanceStatus.setConcrete("true");
                inheritanceStatus.setConcreteHere("true");
            }
            if (cmd.virtual_method) {
                inheritanceStatus.setAbstract("true");
                inheritanceStatus.setInherited("true");
                if (cmd.override_method == 0) {
                    if (cmd.name.equals("State") || cmd.name.equals("Status")) {
                        inheritanceStatus.setConcrete("true");
                    } else {
                        inheritanceStatus.setConcrete("false");
                    }
                    inheritanceStatus.setConcreteHere("false");
                }
            }
            command.setStatus(inheritanceStatus);
            Argument argument = OAWutils.factory.createArgument();
            Argument argument2 = OAWutils.factory.createArgument();
            argument.setType(OAWutils.tango2pogoType(cmd.argin.cpp));
            argument.setDescription(cmd.argin.description);
            argument2.setType(OAWutils.tango2pogoType(cmd.argout.cpp));
            argument2.setDescription(cmd.argout.description);
            command.setArgin(argument);
            command.setArgout(argument2);
            command.setDisplayLevel(PogoConst.strLevel[cmd.level.value()]);
            if (cmd.polled_period > 0) {
                command.setPolledPeriod(Integer.toString(cmd.polled_period));
            }
            EList<String> eList2 = command.getExcludedStates();
            DevStateTable devStateTable = cmd.notAllowedFor;
            for (int j = 0; j < devStateTable.size(); ++j) {
                String string = devStateTable.stateAt((int)j).name;
                if (string.startsWith("Tango::")) {
                    string = string.substring("Tango::".length());
                }
                eList2.add(string);
            }
            command.setExecMethod(Utils.buildCppExecuteMethodName(command.getName()));
            eList.add(command);
        }
    }

    private void manageOldAttributes(EList<Attribute> eList, AttribTable attribTable) {
        for (int i = 0; i < attribTable.size(); ++i) {
            Attrib attrib = attribTable.attributeAt(i);
            Attribute attribute = OAWutils.factory.createAttribute();
            attribute.setName(attrib.name);
            attribute.setAttType(PogoConst.AttrTypeArray[attrib.attrType]);
            attribute.setRwType(PogoConst.AttrRWtypeArray[attrib.rwType]);
            Type type = OAWutils.tango2pogoType(attrib.dataType.cpp);
            attribute.setDataType(type);
            attribute.setMaxX(Integer.toString(attrib.xSize));
            attribute.setMaxY(Integer.toString(attrib.ySize));
            int n = 0;
            AttrProperties attrProperties = OAWutils.factory.createAttrProperties();
            attrProperties.setLabel(attrib.getPropValue(n++));
            attrProperties.setUnit(attrib.getPropValue(n++));
            attrProperties.setStandardUnit(attrib.getPropValue(n++));
            attrProperties.setDisplayUnit(attrib.getPropValue(n++));
            attrProperties.setFormat(attrib.getPropValue(n++));
            attrProperties.setMaxValue(attrib.getPropValue(n++));
            attrProperties.setMinValue(attrib.getPropValue(n++));
            attrProperties.setMaxAlarm(attrib.getPropValue(n++));
            attrProperties.setMinAlarm(attrib.getPropValue(n++));
            attrProperties.setMaxWarning(attrib.getPropValue(n++));
            attrProperties.setMinWarning(attrib.getPropValue(n++));
            attrProperties.setDeltaTime(attrib.getPropValue(n++));
            attrProperties.setDeltaValue(attrib.getPropValue(n));
            attrProperties.setDescription(attrib.getDescription());
            attribute.setProperties(attrProperties);
            attribute.setPolledPeriod(Integer.toString(attrib.polled_period));
            attribute.setDisplayLevel(PogoConst.strLevel[attrib.disp_level.value()]);
            if (attrib.memorized) {
                attribute.setMemorized("true");
                if (attrib.memorized_init) {
                    attribute.setMemorizedAtInit("true");
                }
            }
            FireEvents fireEvents = OAWutils.factory.createFireEvents();
            boolean[] blArray = attrib.getFireEvent(0);
            fireEvents.setFire("" + blArray[0]);
            fireEvents.setLibCheckCriteria("" + blArray[1]);
            attribute.setChangeEvent(fireEvents);
            FireEvents fireEvents2 = OAWutils.factory.createFireEvents();
            boolean[] blArray2 = attrib.getFireEvent(1);
            fireEvents2.setFire("" + blArray2[0]);
            fireEvents2.setLibCheckCriteria("" + blArray2[1]);
            attribute.setArchiveEvent(fireEvents2);
            EList<String> eList2 = attribute.getReadExcludedStates();
            DevStateTable devStateTable = attrib.notAllowedFor;
            for (int j = 0; j < devStateTable.size(); ++j) {
                String string = devStateTable.stateAt((int)j).name;
                if (string.startsWith("Tango::")) {
                    string = string.substring("Tango::".length());
                }
                eList2.add(string);
            }
            InheritanceStatus inheritanceStatus = OAWutils.factory.createInheritanceStatus();
            if (this.old_model.is_abstractclass) {
                inheritanceStatus.setAbstract("true");
            } else {
                inheritanceStatus.setAbstract("false");
                if (this.old_model.inherited_from.startsWith("Device_") && this.old_model.inherited_from.endsWith("Impl")) {
                    inheritanceStatus.setInherited("false");
                } else {
                    inheritanceStatus.setInherited("true");
                }
                inheritanceStatus.setConcrete("true");
                inheritanceStatus.setConcreteHere("true");
                attribute.setStatus(inheritanceStatus);
            }
            attribute.setStatus(inheritanceStatus);
            eList.add(attribute);
        }
    }

    private String getIncludeFiles(String string) throws Exception {
        String string2;
        switch (string) {
            case ".h": {
                string2 = this.old_model.projectFiles.getServer_h();
                break;
            }
            case ".cpp": {
                string2 = this.old_model.projectFiles.getServer();
                break;
            }
            case "Class.h": {
                string2 = this.old_model.projectFiles.getServerClass_h();
                break;
            }
            case "Class.cpp": {
                string2 = this.old_model.projectFiles.getServerClass();
                break;
            }
            default: {
                return "";
            }
        }
        Object object = new OldModelParser(string2, this.old_model);
        return ((OldModelParser)object).getIncludeFiles();
    }

    private String getDefinitions() throws Exception {
        OldModelParser oldModelParser = new OldModelParser(this.old_model.projectFiles.getServer_h(), this.old_model);
        String string = oldModelParser.getDefinitions();
        if (string != null && string.length() > 0) {
            string = "\n\n" + string;
        }
        return string;
    }

    private String getEndPropertyCode(OldModelParser oldModelParser, boolean bl) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = bl ? "void " + this.old_model.class_name + "::get_device_property()" : "void " + this.old_model.class_name + "Class::get_class_property()";
                string = oldModelParser.getCppMethodCode(string2);
                if (string == null) {
                    System.out.println("Cannot read post code from " + string2);
                    break;
                }
                int n = string.indexOf("End of Automatic code generation");
                if (n < 0) {
                    return null;
                }
                if ((n = string.indexOf(10, n)) < 0) {
                    return null;
                }
                if ((n = string.indexOf(10, n + 1)) < 0) {
                    return null;
                }
                string = "\t" + string.substring(n).trim();
            }
        }
        return string;
    }

    private String getConstructorCode(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = this.old_model.class_name + "Class::" + this.old_model.class_name + "Class(string &s):DeviceClass(s)";
                string = oldModelParser.getCppMethodCode(string2);
                if (string == null) {
                    System.err.println("Cannot read init code from " + string2);
                    break;
                }
                int n = string.indexOf("write_class_property();");
                if (n < 0) {
                    System.err.println("Cannot read code from " + string2);
                    return null;
                }
                n = string.indexOf(10, n);
                n = string.indexOf(10, n + 1);
                int n2 = string.indexOf("Leaving " + this.old_model.class_name + "Class constructor");
                if (n2 > 0) {
                    n2 = string.lastIndexOf(10, n2);
                    string = "\t" + string.substring(n, n2).trim();
                    break;
                }
                string = "\t" + string.substring(n).trim();
            }
        }
        return string;
    }

    private String getInitPropertyCode(OldModelParser oldModelParser, boolean bl) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = bl ? "void " + this.old_model.class_name + "::get_device_property()" : "void " + this.old_model.class_name + "Class::get_class_property()";
                string = oldModelParser.getCppMethodCode(string2);
                if (string == null) {
                    System.err.println("Cannot read init code from " + string2);
                    break;
                }
                int n = string.indexOf("Initialize your default values here");
                if (n < 0) {
                    System.err.println("Cannot read init code from " + string2);
                    return null;
                }
                n = string.indexOf(10, n);
                n = string.indexOf(10, n + 1);
                int n2 = string.indexOf("properties from database.(Automatic code generation)");
                if (n2 < 0) {
                    System.err.println("Cannot read init code from " + string2);
                    return null;
                }
                n2 = string.lastIndexOf(10, n2);
                string = "\t" + string.substring(n, n2).trim();
            }
        }
        return string;
    }

    private String getDserverDataMembers(OldModelParser oldModelParser) throws Exception {
        String string = oldModelParser.getCode();
        switch (this.old_model.language) {
            case 1: {
                int n = string.indexOf("Class : public Tango::DeviceClass");
                if (n < 0) {
                    return null;
                }
                if ((n = string.indexOf("add your own data members here", n)) < 0) {
                    return null;
                }
                n = string.indexOf(10, n);
                n = string.indexOf(10, n + 1);
                int n2 = string.indexOf("public:", n);
                string = "public:\n\t" + string.substring(n, n2).trim();
            }
        }
        return string;
    }

    private String getDserverDynamicClasses(OldModelParser oldModelParser) throws Exception {
        String string = oldModelParser.getCode();
        switch (this.old_model.language) {
            case 1: {
                int n = string.indexOf("namespace " + this.old_model.class_name + "_ns");
                if (n < 0) {
                    return null;
                }
                int n2 = string.indexOf("Define classes for attributes", n = string.indexOf("{\n", n) + 2);
                if (n2 < 0) {
                    return null;
                }
                n2 = string.lastIndexOf("//========", n2);
                string = string.substring(n, n2).trim();
            }
        }
        return string;
    }

    private String getDserverAdditionnalMethods(OldModelParser oldModelParser) throws Exception {
        String string = oldModelParser.getCode();
        switch (this.old_model.language) {
            case 1: {
                int n = string.indexOf("get_db_class()->put_property(data);");
                if (n < 0) {
                    return null;
                }
                n = string.indexOf(125, n);
                int n2 = string.indexOf("}\t// namespace", n += 2);
                string = string.substring(n, n2).trim();
            }
        }
        return string;
    }

    private String getDeviceFactoryCode(OldModelParser oldModelParser, boolean bl) throws Exception {
        String string = oldModelParser.getCode();
        switch (this.old_model.language) {
            case 1: {
                if (bl) {
                    int n = string.indexOf("Create all devices.(Automatic code generation)");
                    if (n < 0) {
                        return null;
                    }
                    n = string.lastIndexOf(10, n) + 1;
                    int n2 = string.lastIndexOf(123, n) + 1;
                    string = "\t" + string.substring(n2, n).trim();
                    break;
                }
                int n = string.indexOf("Create all devices.(Automatic code generation)");
                if (n < 0) {
                    return null;
                }
                if ((n = string.indexOf("End of Automatic code generation", n)) < 0) {
                    return null;
                }
                n = string.indexOf(10, n) + 1;
                n = string.indexOf(10, n) + 1;
                int n3 = string.indexOf("\n}", n);
                string = "\t" + string.substring(n, n3).trim();
            }
        }
        return string;
    }

    private String getStaticInit(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                string = oldModelParser.getCppStaticInit(this.old_model.class_name);
            }
        }
        return string;
    }

    private String getInitDeviceCodeBefore(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = "void " + this.old_model.class_name + "::init_device()";
                string = oldModelParser.getCppMethodCode(string2);
                int n = string.indexOf("get_device_property();");
                if (n > 0) {
                    int n2 = (string = string.substring(0, n = string.lastIndexOf("\n", n) + 1)).indexOf("Initialise variables to default values");
                    if (n2 < 0) break;
                    n = string.indexOf(10, n2);
                    if ((n2 = string.lastIndexOf(10, n2)) < 0) {
                        n2 = 0;
                    }
                    if (!(string = string.substring(0, n2) + string.substring(n + 1)).trim().startsWith("//-----------------------")) break;
                    n2 = string.indexOf("//----------------------");
                    n = string.indexOf(10, n2 + 1);
                    string = string.substring(0, n2) + string.substring(n + 1);
                    break;
                }
                string = "";
            }
        }
        return string;
    }

    private String getInitDeviceCodeAfter(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = "void " + this.old_model.class_name + "::init_device()";
                string = oldModelParser.getCppMethodCode(string2);
                int n = string.indexOf("get_device_property();");
                if (n <= 0) break;
                n = string.indexOf("\n", n) + 1;
                string = string.substring(n);
            }
        }
        return string;
    }

    private String getDeleteDeviceCode(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = "void " + this.old_model.class_name + "::delete_device()";
                string = oldModelParser.getCppMethodCode(string2);
            }
        }
        return string;
    }

    private String getCommandCode(OldModelParser oldModelParser, Command command) throws Exception {
        String string = null;
        CmdTable cmdTable = this.old_model.commands;
        block3: for (int i = 0; i < cmdTable.size(); ++i) {
            Cmd cmd = cmdTable.cmdAt(i);
            if (!cmd.name.equals(command.getName())) continue;
            switch (this.old_model.language) {
                case 1: {
                    String string2 = cmd.buildCppExecCmdMethodSignature(this.old_model.class_name);
                    string = oldModelParser.getCppMethodCode(string2);
                    if (string == null) continue block3;
                    string = this.checkLinesToRemove(cmd, string);
                    String string3 = oldModelParser.getCppMethodArginDef(string2);
                    if (string3 == null || string3.contains("argin")) continue block3;
                    int n = string3.lastIndexOf(42);
                    if (n < 0) {
                        n = string3.lastIndexOf(32);
                    }
                    if (n < 0) {
                        n = string3.lastIndexOf(9);
                    }
                    if (n <= 0) continue block3;
                    String string4 = string3.substring(0, n);
                    String string5 = string3.substring(n);
                    string = "\t" + string4 + " " + string5 + " = argin;\n" + string;
                }
            }
        }
        return string;
    }

    private String checkLinesToRemove(Cmd cmd, String string) {
        int n;
        string = string.trim();
        System.out.println("---------> " + cmd.name + " -- " + cmd.argout.cpp);
        if (!cmd.argout.cpp.equals("void")) {
            n = string.indexOf(cmd.argout.cpp);
            if (n > 0) {
                int n2;
                String string2;
                if ((n = string.lastIndexOf(10, n)) < 0) {
                    n = 0;
                }
                if ((string2 = string.substring(n, n2 = string.indexOf(10, n + 1))).indexOf(" argout;") > 0 || string2.indexOf("\targout;") > 0) {
                    string = string.substring(0, n) + string.substring(n2);
                }
            }
            if (string.endsWith("return argout;")) {
                n = string.lastIndexOf(10);
                string = string.substring(0, n).trim();
            }
        }
        if (string.startsWith("INFO_STREAM") || string.startsWith("DEBUG_STREAM")) {
            n = string.indexOf(10);
            string = string.substring(n).trim();
        }
        if ((string.startsWith("//  Add your own code") || string.startsWith("//\tAdd your own code")) && (n = string.indexOf(10)) > 0) {
            string = string.substring(n).trim();
        }
        return "\t" + string;
    }

    private String getReadAttributeCode(OldModelParser oldModelParser, Attribute attribute) throws Exception {
        String string = null;
        AttribTable attribTable = this.old_model.attributes;
        for (int i = 0; i < attribTable.size(); ++i) {
            Attrib attrib = attribTable.attributeAt(i);
            if (!attrib.name.equals(attribute.getName())) continue;
            switch (this.old_model.language) {
                case 1: {
                    String string2 = "void " + this.old_model.class_name + "::read_" + attrib.name + "(Tango::Attribute &attr)";
                    string = oldModelParser.getCppMethodCode(string2);
                }
            }
        }
        return string;
    }

    private String getReadAttrHardwareCode(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = "void " + this.old_model.class_name + "::read_attr_hardware(vector<long> &attr_list)";
                string = oldModelParser.getCppMethodCode(string2);
            }
        }
        return string;
    }

    private String getAlwaysExecutedHookCode(OldModelParser oldModelParser) throws Exception {
        String string = null;
        switch (this.old_model.language) {
            case 1: {
                String string2 = "void " + this.old_model.class_name + "::always_executed_hook()";
                string = oldModelParser.getCppMethodCode(string2);
            }
        }
        return string;
    }

    private String getWriteAttributeCode(OldModelParser oldModelParser, Attribute attribute) throws Exception {
        String string = null;
        AttribTable attribTable = this.old_model.attributes;
        for (int i = 0; i < attribTable.size(); ++i) {
            Attrib attrib = attribTable.attributeAt(i);
            if (!attrib.name.equals(attribute.getName())) continue;
            switch (this.old_model.language) {
                case 1: {
                    String string2 = "void " + this.old_model.class_name + "::write_" + attrib.name + "(Tango::WAttribute &attr)";
                    string = oldModelParser.getCppMethodCode(string2);
                    string = oldModelParser.manageWriteValue(string, attribute.getName());
                }
            }
        }
        return string;
    }

    private String getIsAllowedCode(OldModelParser oldModelParser, String string) throws Exception {
        String string2 = oldModelParser.getCode();
        switch (this.old_model.language) {
            case 1: {
                String string3 = "bool " + this.old_model.class_name + "::is_" + string + "_allowed(Tango::AttReqType type)";
                int n = string2.indexOf(string3);
                if (n < 0) {
                    return null;
                }
                if ((n = string2.indexOf("End of Generated Code", n)) < 0) {
                    return null;
                }
                int n2 = string2.indexOf("Re-Start of Generated Code", n = string2.indexOf("\n", n));
                if (n2 < 0) {
                    return null;
                }
                if ((string2 = string2.substring(n, n2 = string2.lastIndexOf("\n", n2)).trim()).length() <= 0) break;
                string2 = "\t\t" + string2;
            }
        }
        return string2;
    }

    public void generateDocFromOldModel(String string, String string2) throws PogoException, IOException {
        try {
            String string3 = string2 + "/index.html";
            System.out.println("Trying to add description from " + string + "\n to  " + string3);
            PogoParser pogoParser = new PogoParser(string2 + "/index.html");
            OldModelParser oldModelParser = new OldModelParser(string, this.old_model);
            String string4 = oldModelParser.getHtmlDescripion();
            if (string4 != null && string4.length() > 0) {
                if (!pogoParser.codeExists(string4.trim())) {
                    pogoParser.insertInProtectedZone("", "./doc_html/index.html", string4);
                }
                pogoParser.write();
            }
        }
        catch (PogoException pogoException) {
            if (pogoException.toString().contains("FileNotFoundException")) {
                System.out.println("Cannot add Description.html ! (not found)");
            }
            System.err.println("Cannot add description !" + pogoException);
        }
    }

    public static int checkForInheritance(JFrame jFrame, DeviceClass deviceClass) throws PogoException {
        PogoDeviceClass pogoDeviceClass = deviceClass.getPogoDeviceClass();
        String string = pogoDeviceClass.getName();
        Inheritance inheritance = (Inheritance)pogoDeviceClass.getDescription().getInheritances().get(0);
        if (DeviceClass.isDefaultInheritance(inheritance)) {
            if (deviceClass.getPogoDeviceClass().getDescription().getLanguage().toLowerCase().equals("java")) {
                inheritance.setClassname("Device_2Impl");
            }
            System.out.println(string + " has no inheritance -> " + inheritance.getClassname());
        } else {
            String string2 = inheritance.getClassname();
            String string3 = string + " inherite from " + string2 + "\n" + "The class " + string2 + " needs to be converted before !!!\n\n";
            Object[] objectArray = new Object[]{"Specified path for converted abstract class", "Remove inheritance", "Cancel"};
            int n = JOptionPane.showOptionDialog(jFrame, string3, "Confirmation Window", -1, 2, null, objectArray, objectArray[0]);
            switch (n) {
                case 0: {
                    String string4 = OldPogoModel.getInheritanceDirectory(inheritance);
                    if (string4 == null) {
                        return 2;
                    }
                    inheritance.setSourcePath(string4);
                    break;
                }
                case 1: {
                    deviceClass.removeInheritance();
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        return 0;
    }

    private static String getInheritanceDirectory(Inheritance inheritance) throws PogoException {
        File file;
        String string = inheritance.getClassname();
        String string2 = InheritanceUtils.checkInheritanceFileFromEnv(null);
        if (string2 == null) {
            string2 = inheritance.getSourcePath();
        }
        JFileChooser jFileChooser = new JFileChooser(new File(string2).getAbsolutePath());
        PogoFileFilter pogoFileFilter = new PogoFileFilter("xmi", string + " Class");
        jFileChooser.setFileFilter(pogoFileFilter);
        if (jFileChooser.showOpenDialog(new JFrame()) == 0 && (file = jFileChooser.getSelectedFile()) != null && !file.isDirectory()) {
            String string3 = file.getAbsolutePath();
            if (string3.endsWith(string + ".xmi")) {
                DeviceClass deviceClass = new DeviceClass(string3);
                return deviceClass.getPogoDeviceClass().getDescription().getSourcePath();
            }
            JOptionPane.showMessageDialog(new JFrame(), string3 + "\n     is NOT the file defining " + string + " class", "Error Window", 2);
        }
        return null;
    }
}

