/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.tango.pogo.pogo_gui.ClassPanel;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.PogoGUI;
import org.tango.pogo.pogo_gui.tools.Utils;

class InheritancePanel
extends JPanel {
    private List<JTextPane> textPanes = new ArrayList<JTextPane>();
    private PogoGUI gui = null;
    private long t0 = 0L;
    private static final Color classBtnBG = new Color(255, 230, 200);
    private static final Color selectedClassBtnBG = new Color(255, 150, 100);
    private static final String deviceImpl = "Tango DeviceImpl";

    public InheritancePanel(DeviceClass deviceClass) {
        this.setLayout(new GridBagLayout());
        this.addAncestorPanes(deviceClass);
    }

    public InheritancePanel(DeviceClass deviceClass, PogoGUI pogoGUI) {
        this.gui = pogoGUI;
        this.setLayout(new GridBagLayout());
        this.addAncestorPanes(deviceClass);
    }

    private void addInheritanceIcon(int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        JLabel jLabel = new JLabel("");
        jLabel.setIcon(Utils.getInstance().inheritanceIcon);
        this.add((Component)jLabel, gridBagConstraints);
    }

    private void addClassPane(DeviceClass deviceClass, int n, boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        ClassPane classPane = new ClassPane(deviceClass);
        if (this.gui != null) {
            classPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    InheritancePanel.this.textPaneMouseClicked(mouseEvent);
                }
            });
        }
        this.add((Component)classPane, gridBagConstraints);
        this.textPanes.add(classPane);
        if (bl) {
            this.addInheritanceIcon(n + 1);
        }
    }

    private void addAncestorPanes(DeviceClass deviceClass) {
        List<DeviceClass> list = deviceClass.getAncestors();
        int n = 0;
        this.addClassPane(null, n += 2, true);
        for (DeviceClass deviceClass2 : list) {
            this.addClassPane(deviceClass2, n += 2, true);
        }
        this.addClassPane(deviceClass, n += 2, false);
        this.textPanes.get(this.textPanes.size() - 1).setBackground(selectedClassBtnBG);
    }

    private void textPaneMouseClicked(MouseEvent mouseEvent) {
        JTextPane jTextPane = (JTextPane)mouseEvent.getSource();
        String string = jTextPane.getName();
        if (string.equals(deviceImpl)) {
            long l = mouseEvent.getWhen();
            if (l - this.t0 < 1000L && JOptionPane.showConfirmDialog(this, "Launch a WEB browser on DeviceImpl documentation ?", "Confirmation Window", 0) == 0) {
                Utils.showInHtmBrowser(PogoConst.tangoHTTP[2]);
            }
            this.t0 = l;
            return;
        }
        boolean bl = false;
        for (ClassPanel jComponent : this.gui.getClassPanels()) {
            if (!jComponent.getName().equals(string)) continue;
            bl = true;
            this.gui.setTabbedPaneSelection(jComponent);
        }
        if (bl) {
            for (JTextPane jTextPane2 : this.textPanes) {
                if (jTextPane2 == jTextPane) {
                    jTextPane2.setBackground(selectedClassBtnBG);
                    continue;
                }
                jTextPane2.setBackground(classBtnBG);
            }
        }
    }

    public void setSelected(String string) {
        for (JTextPane jTextPane : this.textPanes) {
            if (jTextPane.getName().equals(string)) {
                jTextPane.setBackground(selectedClassBtnBG);
                continue;
            }
            jTextPane.setBackground(classBtnBG);
        }
    }

    private class ClassPane
    extends JTextPane {
        private DeviceClass devClass;

        private ClassPane(DeviceClass deviceClass) {
            this.devClass = deviceClass;
            String string = deviceClass == null ? InheritancePanel.deviceImpl : this.devClass.getPogoDeviceClass().getName();
            this.setEditable(false);
            this.setName(string);
            this.setFont(new Font("monospaced", 1, 10));
            this.setBackground(classBtnBG);
            this.insertIcon(Utils.getInstance().classIcon);
            this.setBorder(BorderFactory.createBevelBorder(0));
            String string2 = null;
            if (this.devClass == null) {
                this.setToolTipText(Utils.buildToolTip("TANGO DeviceImpl model", "See: " + PogoConst.tangoHTTP[2]));
            } else if (this.devClass.getPogoDeviceClass() != null && this.devClass.getPogoDeviceClass().getDescription() != null) {
                string2 = this.devClass.getPogoDeviceClass().getDescription().getSourcePath();
            }
            if (string2 != null) {
                this.setToolTipText(Utils.buildToolTip(this.devClass.getPogoDeviceClass().getName(), "Read at: " + string2));
            }
            this.showMsg(" " + string + " ", true);
            this.showMsg("\n + State\n + Status\n + ---", false);
        }

        private void showMsg(String string, boolean bl) {
            Document document = this.getDocument();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            int n = StyleConstants.getFontSize(simpleAttributeSet);
            try {
                StyleConstants.setBold(simpleAttributeSet, bl);
                StyleConstants.setUnderline(simpleAttributeSet, bl);
                if (bl) {
                    StyleConstants.setFontSize(simpleAttributeSet, n + 2);
                } else {
                    StyleConstants.setFontSize(simpleAttributeSet, n - 2);
                }
                document.insertString(document.getLength(), string, simpleAttributeSet);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

