/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.ClassIdentification;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.SoftBevelBorder;
import org.eclipse.emf.common.util.EList;
import org.tango.pogo.pogo_gui.tools.KeyWordsDialog;
import org.tango.pogo.pogo_gui.tools.OAWutils;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class DeviceIdDialog
extends JDialog {
    private int retVal = 0;
    private ClassIdentification id = null;
    private List<String> keyWordList = new ArrayList<String>();
    private static final String HelpMessage = "During TANGO meeting in Kobe (Japan)\nIt has been decided to create a\ndevice class identification for all TANGO classes.\n\nThe goal of this device class identification\nis to sort and find class by key words.\n\nDo not be afraid to be spammed,\nthe email for contact will not appear clearly in html pages";
    private JButton addKeyWordsButton;
    private JComboBox<String> busComboBox;
    private JPanel centerPanel;
    private JTextField contactTxt;
    private JComboBox<String> familyComboBox;
    private JTextField manufacturerTxt;
    private JComboBox<String> platformComboBox;
    private JTextField referenceTxt;
    private JRadioButton siteButton;
    private JPanel topPanel;

    private void updateComboBox(JComboBox<String> jComboBox, List<String> list) {
        jComboBox.removeAllItems();
        for (String string : list) {
            jComboBox.addItem(string);
        }
    }

    public DeviceIdDialog(JFrame jFrame) {
        super((Frame)jFrame, true);
        this.initComponents();
        this.updateComboBox(this.familyComboBox, PogoProperty.classFamilies);
        this.updateComboBox(this.platformComboBox, PogoProperty.platformNames);
        this.updateComboBox(this.busComboBox, PogoProperty.busNames);
        if (PogoProperty.siteName != null && PogoProperty.siteName.length() > 0 && PogoProperty.siteClassFamilies != null && PogoProperty.siteClassFamilies.size() > 0) {
            this.siteButton.setText(PogoProperty.siteName + " Specific");
        } else {
            this.siteButton.setVisible(false);
        }
        this.topPanel.add(new JLabel("        "));
        JButton jButton = new JButton("Help");
        jButton.setBorder(new SoftBevelBorder(0));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceIdDialog.this.helpBtnActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(jButton);
        String string = System.getenv("EMAIL");
        if (string == null || string.length() == 0) {
            string = PogoProperty.contactAddress;
        }
        this.contactTxt.setText(string);
        this.manufacturerTxt.setText("none");
        this.buildKeyWordsTooltip();
        this.pack();
        this.setReferenceVisible(false);
        ATKGraphicsUtils.centerDialog(this);
    }

    public DeviceIdDialog(JFrame jFrame, ClassIdentification classIdentification) {
        this(jFrame);
        this.id = classIdentification;
        if (classIdentification != null) {
            Object object;
            if (this.siteButton.isVisible() && PogoProperty.siteName != null && classIdentification.getSiteSpecific() != null && classIdentification.getSiteSpecific().equals(PogoProperty.siteName)) {
                this.siteButton.setSelected(true);
                this.updateComboBox(this.familyComboBox, PogoProperty.siteClassFamilies);
            }
            if (Utils.isSet(classIdentification.getAuthor())) {
                this.contactTxt.setText(classIdentification.getAuthor() + "@" + classIdentification.getEmailDomain());
            } else {
                object = System.getenv("EMAIL");
                if (object == null || ((String)object).length() == 0) {
                    object = PogoProperty.contactAddress;
                }
                this.contactTxt.setText((String)object);
            }
            this.platformComboBox.setSelectedItem(classIdentification.getPlatform());
            this.familyComboBox.setSelectedItem(classIdentification.getClassFamily());
            this.busComboBox.setSelectedItem(classIdentification.getBus());
            this.manufacturerTxt.setText(classIdentification.getManufacturer());
            this.referenceTxt.setText(classIdentification.getReference());
            if (classIdentification.getManufacturer() != null) {
                this.setReferenceVisible(!classIdentification.getManufacturer().isEmpty() && !classIdentification.getManufacturer().equals("none"));
            }
            if ((object = classIdentification.getKeyWords()) != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    this.keyWordList.add(string);
                }
            }
            this.buildKeyWordsTooltip();
        }
    }

    private void buildKeyWordsTooltip() {
        if (this.keyWordList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.keyWordList) {
                stringBuilder.append(string).append("\n");
            }
            Object object = "Key Word";
            if (this.keyWordList.size() > 1) {
                object = (String)object + "s";
            }
            this.addKeyWordsButton.setToolTipText(Utils.buildToolTip((String)object, stringBuilder.toString()));
        } else {
            this.addKeyWordsButton.setToolTipText(Utils.buildToolTip("No key words"));
        }
    }

    public JPanel getCenterPanel() {
        return this.centerPanel;
    }

    private void setReferenceVisible(boolean bl) {
        this.referenceTxt.setEditable(bl);
        if (bl) {
            this.referenceTxt.setBackground(Color.white);
        } else {
            this.referenceTxt.setBackground(Color.lightGray);
        }
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.contactTxt = new JTextField();
        this.manufacturerTxt = new JTextField();
        this.referenceTxt = new JTextField();
        this.platformComboBox = new JComboBox();
        this.busComboBox = new JComboBox();
        this.familyComboBox = new JComboBox();
        JLabel jLabel6 = new JLabel();
        this.siteButton = new JRadioButton();
        this.topPanel = new JPanel();
        JLabel jLabel7 = new JLabel();
        this.addKeyWordsButton = new JButton();
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DeviceIdDialog.this.closeDialog(windowEvent);
            }
        });
        this.centerPanel.setLayout(new GridBagLayout());
        jLabel.setText("Contact email *");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.centerPanel.add((Component)jLabel, gridBagConstraints);
        jLabel2.setText("Platform *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)jLabel2, gridBagConstraints);
        jLabel3.setText("Bus *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("Manufacturer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("Product Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)jLabel5, gridBagConstraints);
        this.contactTxt.setColumns(20);
        this.contactTxt.setFont(new Font("Dialog", 1, 12));
        this.contactTxt.setToolTipText("Programmer or contact email address");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(20, 10, 0, 10);
        this.centerPanel.add((Component)this.contactTxt, gridBagConstraints);
        this.manufacturerTxt.setColumns(20);
        this.manufacturerTxt.setFont(new Font("Dialog", 1, 12));
        this.manufacturerTxt.setToolTipText("manufacturer name");
        this.manufacturerTxt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                DeviceIdDialog.this.manufacturerTxtKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add((Component)this.manufacturerTxt, gridBagConstraints);
        this.referenceTxt.setColumns(20);
        this.referenceTxt.setFont(new Font("Dialog", 1, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add((Component)this.referenceTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add(this.platformComboBox, gridBagConstraints);
        this.busComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add(this.busComboBox, gridBagConstraints);
        this.familyComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.centerPanel.add(this.familyComboBox, gridBagConstraints);
        jLabel6.setText("Class family *");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.centerPanel.add((Component)jLabel6, gridBagConstraints);
        this.siteButton.setText("Site button");
        this.siteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceIdDialog.this.siteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 35, 0);
        this.centerPanel.add((Component)this.siteButton, gridBagConstraints);
        jLabel7.setFont(new Font("Dialog", 1, 18));
        jLabel7.setText("Device Class Identification");
        this.topPanel.add(jLabel7);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.centerPanel.add((Component)this.topPanel, gridBagConstraints);
        this.addKeyWordsButton.setText("Add Key Words For Search Engine");
        this.addKeyWordsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceIdDialog.this.addKeyWordsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 20, 10);
        this.centerPanel.add((Component)this.addKeyWordsButton, gridBagConstraints);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceIdDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeviceIdDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
    }

    private void manufacturerTxtKeyReleased(KeyEvent keyEvent) {
        String string = this.manufacturerTxt.getText();
        this.setReferenceVisible(string.length() > 0 && !string.equals("none"));
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        try {
            this.checkInputs();
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
            return;
        }
        this.retVal = 0;
        this.doClose();
    }

    private void helpBtnActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(new JFrame(), HelpMessage, "Help Window", 1);
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.retVal = 2;
        this.doClose();
    }

    private void siteButtonActionPerformed(ActionEvent actionEvent) {
        this.manageSiteFamilies();
    }

    private void addKeyWordsButtonActionPerformed(ActionEvent actionEvent) {
        KeyWordsDialog keyWordsDialog = new KeyWordsDialog(this, this.keyWordList);
        if (keyWordsDialog.showDialog() == 0) {
            this.keyWordList = keyWordsDialog.getKeyWords();
            this.buildKeyWordsTooltip();
        }
    }

    private void manageSiteFamilies() {
        if (PogoProperty.siteName != null && PogoProperty.siteName.length() > 0 && PogoProperty.siteClassFamilies != null && PogoProperty.siteClassFamilies.size() > 0) {
            this.siteButton.setText(PogoProperty.siteName + " Specific");
            this.siteButton.setVisible(true);
        } else {
            this.siteButton.setVisible(false);
        }
        String string = (String)this.familyComboBox.getSelectedItem();
        if (this.siteButton.getSelectedObjects() == null) {
            this.updateComboBox(this.familyComboBox, PogoProperty.classFamilies);
        } else {
            this.updateComboBox(this.familyComboBox, PogoProperty.siteClassFamilies);
        }
        this.familyComboBox.setSelectedItem(string);
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.retVal;
    }

    public void checkInputs() throws PogoException {
        String string = this.contactTxt.getText().trim();
        int n = string.indexOf(64);
        if (n <= 0) {
            throw new PogoException("email is not available");
        }
        int n2 = string.indexOf(46, n);
        if (n2 <= 0 || string.length() - n2 < 3) {
            throw new PogoException("email is not available");
        }
        String string2 = (String)this.familyComboBox.getSelectedItem();
        if (string2 == null || string2.trim().length() == 0) {
            throw new PogoException("Class family is not available");
        }
        String string3 = (String)this.busComboBox.getSelectedItem();
        if (string3 == null || string3.trim().length() == 0) {
            throw new PogoException("Bus is not available");
        }
    }

    public static void buildIdContact(ClassIdentification classIdentification, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@");
        classIdentification.setAuthor(stringTokenizer.nextToken());
        classIdentification.setEmailDomain(stringTokenizer.nextToken());
        classIdentification.setContact("at " + classIdentification.getEmailDomain() + " - " + classIdentification.getAuthor());
    }

    public ClassIdentification getInputs() {
        if (this.id == null) {
            this.id = OAWutils.factory.createClassIdentification();
        }
        String string = (String)this.platformComboBox.getSelectedItem();
        String string2 = (String)this.familyComboBox.getSelectedItem();
        String string3 = (String)this.busComboBox.getSelectedItem();
        String string4 = "";
        if (this.siteButton.isVisible() && this.siteButton.getSelectedObjects() != null) {
            string4 = PogoProperty.siteName;
        }
        DeviceIdDialog.buildIdContact(this.id, this.contactTxt.getText().trim());
        this.id.setClassFamily(string2);
        this.id.setSiteSpecific(string4);
        this.id.setPlatform(string);
        this.id.setBus(string3);
        this.id.setManufacturer(this.manufacturerTxt.getText().trim());
        this.id.setReference(this.referenceTxt.getText().trim());
        EList<String> eList = this.id.getKeyWords();
        for (String string5 : this.keyWordList) {
            eList.add(string5);
        }
        return this.id;
    }
}

