/*
 * Decompiled with CFR 0.152.
 */
package org.tango.pogo.pogo_gui;

import fr.esrf.tango.pogo.pogoDsl.PogoDeviceClass;
import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.eclipse.emf.ecore.EObject;
import org.tango.pogo.pogo_gui.ClassTree;
import org.tango.pogo.pogo_gui.DeviceClass;
import org.tango.pogo.pogo_gui.DeviceIdDialog;
import org.tango.pogo.pogo_gui.EditDialog;
import org.tango.pogo.pogo_gui.InheritancePanel;
import org.tango.pogo.pogo_gui.PogoConst;
import org.tango.pogo.pogo_gui.tools.PogoException;
import org.tango.pogo.pogo_gui.tools.PogoFileFilter;
import org.tango.pogo.pogo_gui.tools.PogoProperty;
import org.tango.pogo.pogo_gui.tools.Utils;

public class ClassDialog
extends JDialog {
    private static int returnStatus;
    private DeviceClass deviceClass;
    private String origClassName = null;
    private InheritancePanel inheritancePanel;
    private JRadioButton[] langBtn;
    private boolean hasForcedGenerate = false;
    private static JFileChooser chooser;
    private DeviceIdDialog IDdialog;
    private ClassTree classTree;
    private JButton addInheritanceBtn;
    private JTextArea copyrightText;
    private JRadioButton cppBtn;
    private JTextArea descText;
    private JSplitPane horizontalPanel;
    private JScrollPane inheritanceScrollPane;
    private JRadioButton javaBtn;
    private JComboBox<String> licenseComboBox;
    private JTextField nameText;
    private JTextField projectText;
    private JRadioButton pythonBtn;
    private JRadioButton pythonHLBtn;

    public ClassDialog(JFrame jFrame, ClassTree classTree, DeviceClass deviceClass, boolean bl) {
        super((Frame)jFrame, true);
        String string;
        EObject eObject;
        this.classTree = classTree;
        this.initComponents();
        this.langBtn = new JRadioButton[4];
        this.langBtn[1] = this.cppBtn;
        this.langBtn[0] = this.javaBtn;
        this.langBtn[2] = this.pythonBtn;
        this.langBtn[3] = this.pythonHLBtn;
        this.licenseComboBox.addItem("GPL");
        this.licenseComboBox.addItem("LGPL");
        this.licenseComboBox.addItem("APACHE");
        this.licenseComboBox.addItem("MIT");
        this.licenseComboBox.addItem("none");
        if (deviceClass == null) {
            this.deviceClass = new DeviceClass("", null);
        } else {
            this.deviceClass = deviceClass;
            this.origClassName = deviceClass.getPogoDeviceClass().getName();
            this.addInheritanceBtn.setVisible(false);
            eObject = deviceClass.getPogoDeviceClass().getDescription();
            if (eObject != null) {
                this.setLanguage(eObject.getLanguage());
            }
        }
        eObject = this.deviceClass.getPogoDeviceClass();
        this.nameText.setText(eObject.getName());
        this.descText.setText(eObject.getDescription().getDescription());
        this.descText.setToolTipText(Utils.buildToolTip("Class Description", "Description for device server documentation."));
        if (deviceClass == null) {
            this.copyrightText.setText(PogoProperty.copyright);
        } else {
            this.copyrightText.setText(eObject.getDescription().getCopyright());
        }
        this.copyrightText.setToolTipText(Utils.buildToolTip("Copyright", "Copyright for the current class."));
        this.projectText.setText(eObject.getDescription().getTitle());
        this.projectText.setToolTipText(Utils.buildToolTip("Short description for documentation header"));
        this.IDdialog = new DeviceIdDialog(jFrame, eObject.getDescription().getIdentification());
        this.horizontalPanel.setLeftComponent(this.IDdialog.getCenterPanel());
        if (this.deviceClass.getPogoDeviceClass().getName().length() == 0) {
            this.deviceClass.getPogoDeviceClass().setName("New Tango Class");
        }
        this.inheritancePanel = new InheritancePanel(this.deviceClass);
        this.inheritanceScrollPane.setViewportView(this.inheritancePanel);
        if (bl) {
            this.nameText.setEditable(false);
        }
        if ((string = eObject.getDescription().getLicense()) != null) {
            this.licenseComboBox.setSelectedItem(string);
        }
        this.licenseComboBox.setToolTipText(Utils.buildToolTip("WARNING:", "The license will be written in header file\nThe header file will be generated in protected area.\nThat means, it will NOT be overwritten in case of change !!!!"));
        this.pack();
        ATKGraphicsUtils.centerDialog(this);
        this.nameText.requestFocus();
    }

    public ClassDialog(JFrame jFrame) {
        this(jFrame, null, null, false);
    }

    private void setLanguage(String string) {
        int n = Utils.getLanguage(string);
        if (n < 0) {
            n = 1;
        }
        for (int i = 0; i < this.langBtn.length; ++i) {
            this.langBtn[i].setSelected(i == n);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        this.horizontalPanel = new JSplitPane();
        JPanel jPanel2 = new JPanel();
        this.addInheritanceBtn = new JButton();
        JLabel jLabel = new JLabel();
        this.nameText = new JTextField();
        JLabel jLabel2 = new JLabel();
        this.projectText = new JTextField();
        JLabel jLabel3 = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        this.descText = new JTextArea();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel3 = new JPanel();
        this.cppBtn = new JRadioButton();
        this.javaBtn = new JRadioButton();
        this.pythonBtn = new JRadioButton();
        this.pythonHLBtn = new JRadioButton();
        JLabel jLabel5 = new JLabel();
        this.licenseComboBox = new JComboBox();
        JLabel jLabel6 = new JLabel();
        JScrollPane jScrollPane2 = new JScrollPane();
        this.copyrightText = new JTextArea();
        JButton jButton3 = new JButton();
        this.inheritanceScrollPane = new JScrollPane();
        this.setTitle("Class Definition Window");
        this.setBackground(new Color(198, 178, 168));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ClassDialog.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new FlowLayout(2));
        jButton.setText("OK");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.okBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton);
        jButton2.setText("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.cancelBtnActionPerformed(actionEvent);
            }
        });
        jPanel.add(jButton2);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel2.setLayout(new GridBagLayout());
        this.addInheritanceBtn.setText("Add Inheritance Class");
        this.addInheritanceBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.addInheritanceBtnActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        jPanel2.add((Component)this.addInheritanceBtn, gridBagConstraints);
        jLabel.setFont(new Font("Dialog", 1, 18));
        jLabel.setText("Class Name :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.nameText.setFont(new Font("Dialog", 1, 18));
        this.nameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.nameTextActionPerformed(actionEvent);
            }
        });
        this.nameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ClassDialog.this.nameTextKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel2.add((Component)this.nameText, gridBagConstraints);
        jLabel2.setText("Project Title :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel2.add((Component)this.projectText, gridBagConstraints);
        jLabel3.setText("Class Description:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 3, 0, 0);
        jPanel2.add((Component)jLabel3, gridBagConstraints);
        jScrollPane.setPreferredSize(new Dimension(500, 250));
        this.descText.setColumns(80);
        this.descText.setFont(new Font("Monospaced", 1, 12));
        this.descText.setMinimumSize(new Dimension(0, 100));
        this.descText.setPreferredSize(new Dimension(880, 400));
        jScrollPane.setViewportView(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        jPanel2.add((Component)jScrollPane, gridBagConstraints);
        jLabel4.setText("Language :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 3, 10, 0);
        jPanel2.add((Component)jLabel4, gridBagConstraints);
        this.cppBtn.setFont(new Font("Dialog", 1, 10));
        this.cppBtn.setSelected(true);
        this.cppBtn.setText("Cpp");
        this.cppBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.languageActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.cppBtn);
        this.javaBtn.setFont(new Font("Dialog", 1, 10));
        this.javaBtn.setText("Java");
        this.javaBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.languageActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.javaBtn);
        this.pythonBtn.setFont(new Font("Dialog", 1, 10));
        this.pythonBtn.setText("Python");
        this.pythonBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.languageActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.pythonBtn);
        this.pythonHLBtn.setFont(new Font("Dialog", 1, 10));
        this.pythonHLBtn.setText("PythonHL");
        this.pythonHLBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.languageActionPerformed(actionEvent);
            }
        });
        jPanel3.add(this.pythonHLBtn);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(20, 0, 10, 0);
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        jLabel5.setText("License :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 10, 0);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        jPanel2.add(this.licenseComboBox, gridBagConstraints);
        jLabel6.setText("Class Copyright:  ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 3, 0, 0);
        jPanel2.add((Component)jLabel6, gridBagConstraints);
        jScrollPane2.setPreferredSize(new Dimension(400, 100));
        this.copyrightText.setColumns(40);
        this.copyrightText.setFont(new Font("Monospaced", 1, 12));
        this.copyrightText.setRows(5);
        jScrollPane2.setViewportView(this.copyrightText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jScrollPane2, gridBagConstraints);
        jButton3.setText("...");
        jButton3.setBorder(BorderFactory.createTitledBorder(""));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassDialog.this.editButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel2.add((Component)jButton3, gridBagConstraints);
        this.horizontalPanel.setRightComponent(jPanel2);
        this.getContentPane().add((Component)this.horizontalPanel, "Center");
        this.inheritanceScrollPane.setPreferredSize(new Dimension(230, 250));
        this.getContentPane().add((Component)this.inheritanceScrollPane, "East");
    }

    private void manageOK() {
        String string = this.checkClassName();
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            this.IDdialog.checkInputs();
        }
        catch (PogoException pogoException) {
            pogoException.popup(this);
            return;
        }
        this.nameText.setText(string);
        if (this.checkClassNameChanged(string)) {
            this.doClose(0);
        }
    }

    private boolean checkClassNameChanged(String string) {
        if (this.classTree == null) {
            return true;
        }
        if (this.origClassName == null) {
            return true;
        }
        if (this.deviceClass.getPogoDeviceClass().getDescription().getSourcePath() == null) {
            return true;
        }
        if (string.equals(this.origClassName)) {
            return true;
        }
        Object[] objectArray = new Object[]{"Change Class name", "Create new class files", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Class name has changed", "Confirmation Window", -1, 2, null, objectArray, objectArray[0]);
        switch (n) {
            case 0: {
                System.out.println("Will generate");
                return this.manageClassNameChanged(string);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean manageClassNameChanged(String string) {
        if (JOptionPane.showConfirmDialog(this, "The " + string + " files (xmi and code) will be generated", "Confirmation Window", 0) != 0) {
            return false;
        }
        this.setCursor(new Cursor(3));
        Utils.getInstance().startSplashRefresher("Generate class: " + string);
        try {
            DeviceClass deviceClass = this.classTree.getDeviceClass();
            deviceClass.generateWithNewName(string, this.classTree.getModified(), this.classTree.getDeletedObjects(), this.classTree.getRenamedObjects());
            this.classTree.setModified(false);
            this.hasForcedGenerate = true;
            this.setCursor(new Cursor(0));
            Utils.getInstance().stopSplashRefresher();
        }
        catch (Exception exception) {
            this.setCursor(new Cursor(0));
            Utils.getInstance().stopSplashRefresher();
            PogoException.popup((Component)this, exception);
            return false;
        }
        return true;
    }

    public boolean hasForcedToGenerate() {
        return this.hasForcedGenerate;
    }

    private void nameTextActionPerformed(ActionEvent actionEvent) {
        this.manageOK();
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        this.manageOK();
    }

    private void cancelBtnActionPerformed(ActionEvent actionEvent) {
        this.doClose(2);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(2);
    }

    private void languageActionPerformed(ActionEvent actionEvent) {
        JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
        if (jRadioButton.getSelectedObjects() == null) {
            jRadioButton.setSelected(true);
        }
        if (this.deviceClass.getAncestors().size() > 0) {
            jRadioButton.setSelected(false);
            JOptionPane.showMessageDialog(this, this.deviceClass.getPogoDeviceClass().getName() + " inherits  for " + this.deviceClass.getAncestors().get(0).getPogoDeviceClass().getName() + ".\n It must be generated in same language !", "Error Window", 0);
        } else {
            this.setLanguage(jRadioButton.getText());
        }
    }

    private void addInheritanceBtnActionPerformed(ActionEvent actionEvent) {
        block6: {
            Object object;
            Object object2;
            if (chooser == null) {
                object2 = System.getenv("SOURCE_PATH");
                if (object2 == null && (object2 = System.getProperty("SOURCE_PATH")) == null) {
                    object2 = new File("").getAbsolutePath();
                }
                chooser = new JFileChooser(new File((String)object2).getAbsolutePath());
                object = new PogoFileFilter("xmi", "Tango Classes");
                ((PogoFileFilter)object).setExtensionListInDescription(false);
                chooser.setFileFilter((FileFilter)object);
            }
            if (chooser.showOpenDialog(this) == 0 && (object2 = chooser.getSelectedFile()) != null && !((File)object2).isDirectory()) {
                try {
                    object = new DeviceClass(((File)object2).getAbsolutePath());
                    this.deviceClass.addAncestor((DeviceClass)object);
                    this.inheritanceScrollPane.remove(this.inheritancePanel);
                    String string = this.nameText.getText();
                    if (string.length() > 0) {
                        this.deviceClass.getPogoDeviceClass().setName(string);
                    }
                    this.inheritancePanel = new InheritancePanel(this.deviceClass);
                    this.inheritanceScrollPane.setViewportView(this.inheritancePanel);
                    this.addInheritanceBtn.setVisible(false);
                    this.setLanguage(((DeviceClass)object).getPogoDeviceClass().getDescription().getLanguage());
                }
                catch (PogoException pogoException) {
                    if (pogoException.toString().equals("CANCEL")) break block6;
                    pogoException.popup(this);
                }
            }
        }
    }

    private void nameTextKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.doClose(2);
        }
    }

    private void editButtonActionPerformed(ActionEvent actionEvent) {
        EditDialog editDialog = new EditDialog(this, this.descText.getText(), new Dimension(640, 480));
        if (editDialog.showDialog() == 0) {
            this.descText.setText(editDialog.getText());
        }
    }

    public int showDialog() {
        this.setVisible(true);
        return returnStatus;
    }

    private void doClose(int n) {
        returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }

    DeviceClass getInputs() {
        PogoDeviceClass pogoDeviceClass = this.deviceClass.getPogoDeviceClass();
        pogoDeviceClass.setName(this.nameText.getText());
        String string = Utils.strReplaceSpecialCharToCode(this.projectText.getText());
        pogoDeviceClass.getDescription().setTitle(string);
        String string2 = Utils.strReplaceSpecialCharToCode(this.descText.getText());
        pogoDeviceClass.getDescription().setDescription(string2);
        String string3 = Utils.strReplaceSpecialCharToCode(this.copyrightText.getText());
        pogoDeviceClass.getDescription().setCopyright(string3);
        pogoDeviceClass.getDescription().setIdentification(this.IDdialog.getInputs());
        pogoDeviceClass.getDescription().setLicense(this.licenseComboBox.getSelectedItem().toString());
        if (this.pythonHLBtn.getSelectedObjects() != null) {
            pogoDeviceClass.getDescription().setLanguage(PogoConst.strLang[3]);
        } else if (this.pythonBtn.getSelectedObjects() != null) {
            pogoDeviceClass.getDescription().setLanguage(PogoConst.strLang[2]);
        } else if (this.javaBtn.getSelectedObjects() != null) {
            pogoDeviceClass.getDescription().setLanguage(PogoConst.strLang[0]);
        } else {
            pogoDeviceClass.getDescription().setLanguage(PogoConst.strLang[1]);
        }
        return this.deviceClass;
    }

    private String checkClassName() {
        if (this.nameText.getText().length() == 0) {
            return null;
        }
        String string = this.nameText.getText().toLowerCase();
        if (string.charAt(0) < 'a' || string.charAt(0) > 'z') {
            Utils.popupError(this, "First char of class name must be a letter");
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= 'a' && string.charAt(i) <= 'z' || string.charAt(i) >= '0' && string.charAt(i) <= '9' || string.charAt(i) == '_') continue;
            Utils.popupError(this, "Char '" + string.charAt(i) + "' is not authorized in class name");
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.nameText.getText());
        string = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() > 1) {
                string = string + string2.substring(0, 1).toUpperCase() + string2.substring(1);
                continue;
            }
            string = string + string2.toUpperCase();
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    static {
        chooser = null;
    }
}

