/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator.grammarAccess;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.xtext.generator.grammarAccess.ResourceSaveIndicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FragmentFakingEcoreResource
extends XMIResourceImpl {
    private final ResourceSaveIndicator isSaving;

    public FragmentFakingEcoreResource(URI uri, ResourceSaveIndicator isSaving) {
        super(uri);
        this.isSaving = isSaving;
        this.setEncoding("UTF-8");
        this.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        this.getDefaultSaveOptions().put("LINE_WIDTH", 80);
        this.getDefaultSaveOptions().put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
    }

    @Override
    protected boolean useIDs() {
        return this.eObjectToIDMap != null || this.idToEObjectMap != null;
    }

    @Override
    public String getURIFragment(EObject eObject) {
        String result;
        if (this.isSaving.isSaving() && eObject instanceof EClassifier && (result = this.getURIFragment((EClassifier)eObject)) != null) {
            return result;
        }
        return super.getURIFragment(eObject);
    }

    public String getURIFragment(EClassifier eObject) {
        EClassifier classifier = eObject;
        if (classifier.getEPackage().getESuperPackage() != null) {
            StringBuilder result = new StringBuilder(60);
            this.calculateURIFragment(classifier.getEPackage(), result, Sets.<EPackage>newHashSet());
            result.append(classifier.getName());
            return result.toString();
        }
        return null;
    }

    private void calculateURIFragment(EPackage ePackage, StringBuilder result, Set<EPackage> visited) {
        if (!visited.add(ePackage)) {
            throw new IllegalStateException();
        }
        if (ePackage.getESuperPackage() != null) {
            if (ePackage.eResource() == ePackage.getESuperPackage().eResource()) {
                this.calculateURIFragment(ePackage.getESuperPackage(), result, visited);
                if (!ePackage.getEClassifiers().isEmpty()) {
                    if (result.length() != 0) {
                        result.append(ePackage.getName()).append('/');
                    } else {
                        result.append("//");
                    }
                }
            } else {
                result.append("//");
            }
        } else {
            result.append("//");
        }
    }
}

