/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.impl.Messages;
import org.eclipse.xtext.ui.XtextProjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class BuildScheduler {
    private static final Logger log = Logger.getLogger(BuildScheduler.class);
    private final Set<IProject> projectsScheduledForBuild = Sets.newHashSet();
    private final Map<IProject, Map<String, String>> projectBuilderArguments = Maps.newHashMap();
    @Inject
    private IWorkspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleBuildIfNecessary(Iterable<IProject> toUpdate, IBuildFlag ... buildFlags) {
        ArrayList<IProject> scheduleUs = Lists.newArrayList();
        for (IProject project : toUpdate) {
            if (!this.isBuildable(project)) continue;
            scheduleUs.add(project);
        }
        if (scheduleUs.isEmpty()) {
            return;
        }
        Set<IProject> set = this.projectsScheduledForBuild;
        synchronized (set) {
            scheduleUs.removeAll(this.projectsScheduledForBuild);
            if (!scheduleUs.isEmpty()) {
                this.projectsScheduledForBuild.addAll(scheduleUs);
                for (IProject scheduled : scheduleUs) {
                    HashMap builderArguments = Maps.newHashMap();
                    if (buildFlags != null && buildFlags.length > 0) {
                        builderArguments = Maps.newHashMap();
                        IBuildFlag[] iBuildFlagArray = buildFlags;
                        int n = buildFlags.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IBuildFlag buildFlag = iBuildFlagArray[n2];
                            buildFlag.addToMap(builderArguments);
                            ++n2;
                        }
                    }
                    if (this.projectBuilderArguments.containsKey(scheduled)) {
                        Map<String, String> existingArguments = this.projectBuilderArguments.get(scheduled);
                        existingArguments.keySet().retainAll(builderArguments.keySet());
                        continue;
                    }
                    this.projectBuilderArguments.put(scheduled, builderArguments);
                }
                new BuildJob(Messages.BuildScheduler_JobName, scheduleUs).schedule();
            }
        }
    }

    protected boolean isBuildable(IProject project) {
        return XtextProjectHelper.hasNature((IProject)project) && XtextProjectHelper.hasBuilder((IProject)project);
    }

    static /* synthetic */ Set access$1(BuildScheduler buildScheduler) {
        return buildScheduler.projectsScheduledForBuild;
    }

    static /* synthetic */ Map access$2(BuildScheduler buildScheduler) {
        return buildScheduler.projectBuilderArguments;
    }

    static /* synthetic */ Logger access$3() {
        return log;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BuildJob
    extends Job {
        public BuildJob(String name, List<IProject> projects) {
            super(name);
            this.setRule(BuildScheduler.this.workspace.getRuleFactory().buildRule());
            this.updateTaskName(projects);
        }

        protected void updateTaskName(List<IProject> projects) {
            switch (projects.size()) {
                case 0: {
                    throw new IllegalArgumentException("projects may not be empty");
                }
                case 1: {
                    this.setName(NLS.bind(Messages.BuildScheduler_SingleJobName, projects.get(0).getName()));
                    break;
                }
                case 2: {
                    this.setName(NLS.bind(Messages.BuildScheduler_TwoJobsName, projects.get(0).getName(), projects.get(1).getName()));
                    break;
                }
                default: {
                    this.setName(NLS.bind(Messages.BuildScheduler_ManyJobsName, projects.get(0).getName(), projects.size() - 1));
                }
            }
        }

        public BuildJob(String name, IProject project) {
            this(name, Collections.singletonList(project));
        }

        @Override
        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
        }

        /*
         * Exception decompiling
         */
        @Override
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

