/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.preferences.WizardPropertyPage;

public class WorkingSetPropertyPage
extends WizardPropertyPage {
    private IWorkingSet fWorkingSet;

    public WorkingSetPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    @Override
    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.fWorkingSet = element instanceof IWorkingSet ? (IWorkingSet)element : (IWorkingSet)element.getAdapter(IWorkingSet.class);
    }

    @Override
    protected void applyChanges() {
    }

    @Override
    protected IWizard createWizard() {
        if (this.fWorkingSet.isEditable()) {
            return PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetEditWizard(this.fWorkingSet);
        }
        return new ReadOnlyWizard();
    }

    private static final class ReadOnlyPage
    extends WizardPage {
        protected ReadOnlyPage() {
            super(WorkbenchMessages.WorkingSetPropertyPage_ReadOnlyWorkingSet_title);
            this.setDescription(WorkbenchMessages.WorkingSetPropertyPage_ReadOnlyWorkingSet_description);
        }

        @Override
        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData(new GridData(4, 4, true, true));
            composite.setLayout(new GridLayout(1, false));
            this.setControl(composite);
        }
    }

    private static final class ReadOnlyWizard
    extends Wizard {
        @Override
        public boolean performFinish() {
            return true;
        }

        @Override
        public void addPages() {
            this.addPage(new ReadOnlyPage());
        }
    }
}

