/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicMenuContributionItem
extends ContributionItem {
    private final IConfigurationElement dynamicAddition;
    private final IServiceLocator locator;
    private boolean alreadyFailed;
    private ContributionItem loadedDynamicContribution;

    public DynamicMenuContributionItem(String id, IServiceLocator locator, IConfigurationElement dynamicAddition) {
        super(id);
        this.locator = locator;
        this.dynamicAddition = dynamicAddition;
    }

    @Override
    public boolean isDynamic() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isDynamic();
        }
        return true;
    }

    @Override
    public boolean isDirty() {
        if (this.loadedDynamicContribution != null) {
            return this.loadedDynamicContribution.isDirty();
        }
        return super.isDirty();
    }

    @Override
    public void fill(Composite parent) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            contributionItem.fill(parent);
        }
    }

    @Override
    public void fill(CoolBar parent, int index) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            contributionItem.fill(parent, index);
        }
    }

    @Override
    public void fill(Menu menu, int index) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            contributionItem.fill(menu, index);
        }
    }

    @Override
    public void fill(ToolBar parent, int index) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            contributionItem.fill(parent, index);
        }
    }

    private IContributionItem getContributionItem() {
        if (this.loadedDynamicContribution == null && !this.alreadyFailed) {
            this.createContributionItem();
        }
        return this.loadedDynamicContribution;
    }

    private void createContributionItem() {
        this.loadedDynamicContribution = (ContributionItem)Util.safeLoadExecutableExtension(this.dynamicAddition, "class", ContributionItem.class);
        if (this.loadedDynamicContribution == null) {
            this.alreadyFailed = true;
            return;
        }
        this.loadedDynamicContribution.setId(this.getId());
        this.loadedDynamicContribution.setParent(this.getParent());
        if (this.loadedDynamicContribution instanceof IWorkbenchContribution) {
            ((IWorkbenchContribution)((Object)this.loadedDynamicContribution)).initialize(this.locator);
        }
    }

    @Override
    public void dispose() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.dispose();
            this.loadedDynamicContribution = null;
        }
        super.dispose();
    }

    @Override
    public void update() {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.update();
        }
    }

    @Override
    public void update(String id) {
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.update(id);
        }
    }

    @Override
    public void setParent(IContributionManager parent) {
        super.setParent(parent);
        if (this.loadedDynamicContribution != null) {
            this.loadedDynamicContribution.setParent(parent);
        }
    }
}

